/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;

public class CertUtil {
    private static final int LINE_LENGTH = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean saveCert(Certificate cert, File file) {
        SecureFileOutputStream os = null;
        byte[] buf = cert.getEncoded();
        os = new SecureFileOutputStream(file);
        PrintWriter wr = new PrintWriter(os);
        wr.println("-----BEGIN CERTIFICATE-----");
        String b64 = Base64.encode(buf, true);
        for (int i = 0; i < b64.length(); i += 64) {
            wr.println(b64.substring(i, Math.min(i + 64, b64.length())));
        }
        wr.println("-----END CERTIFICATE-----");
        wr.flush();
        boolean bl = true;
        Object var8_11 = null;
        try {
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        catch (IOException foo) {
            // empty catch block
        }
        return bl;
        catch (CertificateEncodingException cee) {
            CertUtil.error("Error writing X509 Certificate " + file.getAbsolutePath(), cee);
            boolean bl2 = false;
            Object var8_12 = null;
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException foo) {
                // empty catch block
            }
            return bl2;
        }
        catch (IOException ioe) {
            CertUtil.error("Error writing X509 Certificate " + file.getAbsolutePath(), ioe);
            boolean bl3 = false;
            Object var8_13 = null;
            {
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    try {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                    catch (IOException foo) {}
                    throw throwable;
                }
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException foo) {
                // empty catch block
            }
            return bl3;
        }
    }

    public static String getSubjectValue(X509Certificate cert, String type) {
        type = type.toUpperCase(Locale.US);
        X500Principal p = cert.getSubjectX500Principal();
        String subj = p.getName();
        try {
            LdapName name = new LdapName(subj);
            for (Rdn rdn : name.getRdns()) {
                if (!type.equals(rdn.getType().toUpperCase(Locale.US))) continue;
                return (String)rdn.getValue();
            }
        }
        catch (InvalidNameException ine) {
            // empty catch block
        }
        return null;
    }

    private static void error(String msg, Throwable t) {
        CertUtil.log(I2PAppContext.getGlobalContext(), 40, msg, t);
    }

    private static void log(I2PAppContext ctx, int level, String msg, Throwable t) {
        Log l = ctx.logManager().getLog(CertUtil.class);
        l.log(level, msg, t);
    }
}

