/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.InputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSimpleClient;
import net.i2p.data.Base32;
import net.i2p.data.Destination;
import net.i2p.data.Hash;

class LookupDest {
    private static final long DEFAULT_TIMEOUT = 15000L;

    protected LookupDest(I2PAppContext context) {
    }

    static Destination lookupBase32Hash(I2PAppContext ctx, String key) throws I2PSessionException {
        byte[] h = Base32.decode(key);
        if (h == null) {
            return null;
        }
        return LookupDest.lookupHash(ctx, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Destination lookupHash(I2PAppContext ctx, byte[] h) throws I2PSessionException {
        Hash key = Hash.create(h);
        Destination rv = null;
        I2PSimpleClient client = new I2PSimpleClient();
        Properties opts = new Properties();
        String s = ctx.getProperty("i2cp.tcp.host");
        if (s != null) {
            opts.put("i2cp.tcp.host", s);
        }
        if ((s = ctx.getProperty("i2cp.tcp.port")) != null) {
            opts.put("i2cp.tcp.port", s);
        }
        I2PSession session = null;
        try {
            session = client.createSession((InputStream)null, opts);
            session.connect();
            rv = session.lookupDest(key, 15000L);
            Object var9_8 = null;
            if (session == null) return rv;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (session == null) throw throwable;
            session.destroySession();
            throw throwable;
        }
        session.destroySession();
        return rv;
    }

    public static void main(String[] args) throws I2PSessionException {
        Destination dest = LookupDest.lookupBase32Hash(I2PAppContext.getGlobalContext(), args[0]);
        if (dest == null) {
            System.out.println("Destination not found!");
        } else {
            System.out.println(dest.toBase64());
        }
    }
}

