/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import net.i2p.I2PException;
import net.i2p.client.streaming.AcceptingChannel;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;

class AcceptingChannelImpl
extends AcceptingChannel {
    private boolean _isRegistered;
    private SelectionKey whichKey;
    private SelectorProvider provider;
    private Selector sel;
    private Object lock;
    private volatile I2PSocket next;
    private final I2PServerSocket socket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected I2PSocket accept() throws I2PException, ConnectException {
        I2PSocket sock;
        try {
            sock = this.socket.accept();
        }
        catch (SocketTimeoutException ex) {
            return null;
        }
        AcceptingChannelImpl acceptingChannelImpl = this;
        synchronized (acceptingChannelImpl) {
            I2PSocket temp = this.next;
            this.next = sock;
            return temp;
        }
    }

    protected AcceptingChannelImpl(I2PSocketManager manager) {
        super(manager);
        this.socket = manager.getServerSocket();
        this.socket.setSoTimeout(100L);
    }

    public SelectorProvider provider() {
        return this.provider;
    }

    public int validOps() {
        return 16;
    }

    public boolean isRegistered() {
        return this._isRegistered;
    }

    public SelectionKey keyFor(Selector arg0) {
        return this.whichKey;
    }

    public SelectionKey register(final Selector sel, final int ops, Object lock) throws ClosedChannelException {
        this.sel = sel;
        this.provider = sel.provider();
        this.lock = lock;
        this._isRegistered = true;
        final AcceptingChannelImpl that = this;
        AbstractSelectionKey key = new AbstractSelectionKey(){
            int operations;
            {
                this.operations = ops;
            }

            public SelectableChannel channel() {
                return that;
            }

            public Selector selector() {
                return sel;
            }

            public int interestOps() {
                return this.operations;
            }

            public SelectionKey interestOps(int ops2) {
                this.operations = ops2;
                return this;
            }

            public int readyOps() {
                if ((this.operations & 0x10) != 0) {
                    if (AcceptingChannelImpl.this.next != null) {
                        return 16;
                    }
                    try {
                        AcceptingChannelImpl.this.accept();
                    }
                    catch (I2PException ex) {
                    }
                    catch (ConnectException connectException) {
                        // empty catch block
                    }
                    if (AcceptingChannelImpl.this.next != null) {
                        return 16;
                    }
                }
                return 0;
            }
        };
        key.attach(lock);
        sel.keys().add(key);
        return key;
    }

    public SelectableChannel configureBlocking(boolean blocking) throws IOException {
        if (!blocking) {
            return this;
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isBlocking() {
        return false;
    }

    public Object blockingLock() {
        return this.lock;
    }

    protected void implCloseChannel() throws IOException {
        I2PSocket nxt = this.next;
        if (nxt != null) {
            nxt.close();
        }
        this._socketManager.destroySocketManager();
    }
}

