/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.InvalidBEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PeerID
implements Comparable<PeerID> {
    private byte[] id;
    private Destination address;
    private final int port;
    private byte[] destHash;
    private boolean triedDestLookup;
    private final int hash;
    private final I2PSnarkUtil util;

    public PeerID(byte[] id, Destination address) {
        this.id = id;
        this.address = address;
        this.port = 6881;
        this.destHash = address.calculateHash().getData();
        this.hash = this.calculateHash();
        this.util = null;
    }

    public PeerID(BDecoder be) throws IOException {
        this(be.bdecodeMap().getMap());
    }

    public PeerID(Map<String, BEValue> m) throws InvalidBEncodingException, UnknownHostException {
        BEValue bevalue = m.get("peer id");
        if (bevalue == null) {
            throw new InvalidBEncodingException("peer id missing");
        }
        this.id = bevalue.getBytes();
        bevalue = m.get("ip");
        if (bevalue == null) {
            throw new InvalidBEncodingException("ip missing");
        }
        this.address = I2PSnarkUtil.getDestinationFromBase64(bevalue.getString());
        if (this.address == null) {
            throw new InvalidBEncodingException("Invalid destination [" + bevalue.getString() + "]");
        }
        this.port = 6881;
        this.destHash = this.address.calculateHash().getData();
        this.hash = this.calculateHash();
        this.util = null;
    }

    public PeerID(byte[] dest_hash, I2PSnarkUtil util) throws InvalidBEncodingException {
        this.port = 6881;
        if (dest_hash.length != 32) {
            throw new InvalidBEncodingException("bad hash length");
        }
        this.destHash = dest_hash;
        this.hash = DataHelper.hashCode(dest_hash);
        this.util = util;
    }

    public byte[] getID() {
        return this.id;
    }

    public void setID(byte[] xid) {
        this.id = xid;
    }

    public synchronized Destination getAddress() {
        if (this.address == null && this.destHash != null && !this.triedDestLookup) {
            String b32 = Base32.encode(this.destHash) + ".b32.i2p";
            this.address = this.util.getDestination(b32);
            this.triedDestLookup = true;
        }
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getDestHash() {
        return this.destHash;
    }

    private int calculateHash() {
        return DataHelper.hashCode(this.destHash);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean sameID(PeerID pid) {
        return DataHelper.eq(this.destHash, pid.getDestHash());
    }

    public boolean equals(Object o) {
        if (o instanceof PeerID) {
            PeerID pid = (PeerID)o;
            return this.sameID(pid);
        }
        return false;
    }

    @Override
    public int compareTo(PeerID pid) {
        int result = this.port - pid.port;
        if (result != 0) {
            return result;
        }
        result = this.address.hashCode() - pid.address.hashCode();
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < this.id.length; ++i) {
            result = this.id[i] - pid.id[i];
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        if (this.id == null || this.address == null) {
            return "unkn@" + Base64.encode(this.destHash).substring(0, 6);
        }
        int nonZero = 0;
        for (int i = 0; i < this.id.length; ++i) {
            if (this.id[i] == 0) continue;
            nonZero = i;
            break;
        }
        return Base64.encode(this.id, nonZero, this.id.length - nonZero).substring(0, 4) + "@" + this.address.toBase64().substring(0, 6);
    }

    public static String idencode(byte[] bs) {
        boolean leading_zeros = true;
        StringBuilder sb = new StringBuilder(bs.length * 2);
        for (int i = 0; i < bs.length; ++i) {
            int c = bs[i] & 0xFF;
            if (leading_zeros && c == 0) continue;
            leading_zeros = false;
            if (c < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        return sb.toString();
    }
}

