/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA1;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import org.klomp.snark.Piece;
import org.klomp.snark.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PartialPiece
implements Comparable<PartialPiece> {
    private final Piece piece;
    private final byte[] bs;
    private int off;
    private File tempfile;
    private RandomAccessFile raf;
    private final int pclen;
    private final File tempDir;
    private static final int BUFSIZE = 16384;
    private static final ByteCache _cache = ByteCache.getInstance(16, 16384);
    private static final int MAX_IN_MEM = 131072;
    private static int _max_in_mem = 131072;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartialPiece(Piece piece, int len, File tempDir) {
        block7: {
            this.piece = piece;
            this.pclen = len;
            this.tempDir = tempDir;
            byte[] tbs = null;
            try {
                if (len > 131072) break block7;
                try {
                    tbs = new byte[len];
                    return;
                }
                catch (OutOfMemoryError oom) {
                    if (_max_in_mem > 16384) {
                        _max_in_mem /= 2;
                    }
                    Log log = I2PAppContext.getGlobalContext().logManager().getLog(PartialPiece.class);
                    log.logAlways(30, "OOM creating new partial piece");
                }
            }
            finally {
                this.bs = tbs;
            }
        }
    }

    private void createTemp() throws IOException {
        this.tempfile = SecureFile.createTempFile("piece_" + this.piece.getId() + '_', null, this.tempDir);
        this.raf = new RandomAccessFile(this.tempfile, "rw");
    }

    public Request getRequest() {
        return new Request(this, this.off, Math.min(this.pclen - this.off, 16384));
    }

    public int getPiece() {
        return this.piece.getId();
    }

    public int getLength() {
        return this.pclen;
    }

    public int getDownloaded() {
        return this.off;
    }

    public void setDownloaded(int offset) {
        this.off = offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHash() throws IOException {
        MessageDigest sha1 = SHA1.getInstance();
        if (this.bs != null) {
            sha1.update(this.bs);
        } else {
            byte[] buf;
            ByteArray ba;
            int read = 0;
            int buflen = Math.min(this.pclen, 16384);
            if (buflen == 16384) {
                ba = _cache.acquire();
                buf = ba.getData();
            } else {
                ba = null;
                buf = new byte[buflen];
            }
            PartialPiece partialPiece = this;
            synchronized (partialPiece) {
                int rd;
                if (this.raf == null) {
                    throw new IOException();
                }
                this.raf.seek(0L);
                while (read < this.pclen && (rd = this.raf.read(buf, 0, Math.min(buf.length, this.pclen - read))) >= 0) {
                    read += rd;
                    sha1.update(buf, 0, rd);
                }
            }
            if (ba != null) {
                _cache.release(ba, false);
            }
            if (read < this.pclen) {
                throw new IOException();
            }
        }
        return sha1.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DataInputStream din, int off, int len) throws IOException {
        if (this.bs != null) {
            din.readFully(this.bs, off, len);
        } else {
            byte[] tmp;
            ByteArray ba;
            if (len == 16384) {
                ba = _cache.acquire();
                tmp = ba.getData();
            } else {
                ba = null;
                tmp = new byte[len];
            }
            din.readFully(tmp);
            PartialPiece partialPiece = this;
            synchronized (partialPiece) {
                if (this.raf == null) {
                    this.createTemp();
                }
                this.raf.seek(off);
                this.raf.write(tmp);
            }
            if (ba != null) {
                _cache.release(ba, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput out, int offset, int len) throws IOException {
        if (this.bs != null) {
            out.write(this.bs, offset, len);
        } else {
            byte[] buf;
            ByteArray ba;
            int read = 0;
            int buflen = Math.min(len, 16384);
            if (buflen == 16384) {
                ba = _cache.acquire();
                buf = ba.getData();
            } else {
                ba = null;
                buf = new byte[buflen];
            }
            PartialPiece partialPiece = this;
            synchronized (partialPiece) {
                if (this.raf == null) {
                    throw new IOException();
                }
                this.raf.seek(offset);
                while (read < len) {
                    int rd = Math.min(buf.length, len - read);
                    this.raf.readFully(buf, 0, rd);
                    read += rd;
                    out.write(buf, 0, rd);
                }
            }
            if (ba != null) {
                _cache.release(ba, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.bs == null) {
            PartialPiece partialPiece = this;
            synchronized (partialPiece) {
                if (this.raf != null) {
                    this.locked_release();
                }
            }
        }
    }

    private void locked_release() {
        try {
            this.raf.close();
        }
        catch (IOException ioe) {
            I2PAppContext.getGlobalContext().logManager().getLog(PartialPiece.class).warn("Error closing " + this.raf, ioe);
        }
        this.tempfile.delete();
    }

    @Override
    public int compareTo(PartialPiece opp) {
        int d = this.piece.compareTo(opp.piece);
        if (d != 0) {
            return d;
        }
        return opp.off - this.off;
    }

    public int hashCode() {
        return this.piece.getId() * 7777;
    }

    public boolean equals(Object o) {
        if (o instanceof PartialPiece) {
            PartialPiece pp = (PartialPiece)o;
            return pp.piece.getId() == this.piece.getId();
        }
        return false;
    }

    public String toString() {
        return "Partial(" + this.piece.getId() + ',' + this.off + ',' + this.pclen + ')';
    }
}

