/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Hash;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.PeerAcceptor;
import org.klomp.snark.PeerCoordinatorSet;

class ConnectionAcceptor
implements Runnable {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(ConnectionAcceptor.class);
    private final PeerAcceptor peeracceptor;
    private Thread thread;
    private final I2PSnarkUtil _util;
    private final ObjectCounter<Hash> _badCounter = new ObjectCounter();
    private final SimpleTimer2.TimedEvent _cleaner;
    private volatile boolean stop;
    private static final int MAX_BAD = 1;
    private static final long BAD_CLEAN_INTERVAL = 1800000L;

    public ConnectionAcceptor(I2PSnarkUtil util, PeerCoordinatorSet set) {
        this._util = util;
        this._cleaner = new Cleaner();
        this.peeracceptor = new PeerAcceptor(set);
    }

    public synchronized void startAccepting() {
        this.stop = false;
        if (this._log.shouldLog(30)) {
            this._log.warn("ConnectionAcceptor startAccepting new thread? " + (this.thread == null));
        }
        if (this.thread == null) {
            this.thread = new I2PAppThread(this, "I2PSnark acceptor");
            this.thread.setDaemon(true);
            this.thread.start();
            this._cleaner.reschedule(1800000L, false);
        }
    }

    public ConnectionAcceptor(I2PSnarkUtil util, PeerAcceptor peeracceptor) {
        this.peeracceptor = peeracceptor;
        this._util = util;
        this.thread = new I2PAppThread(this, "I2PSnark acceptor");
        this.thread.setDaemon(true);
        this.thread.start();
        this._cleaner = new Cleaner();
    }

    public synchronized void halt() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.locked_halt();
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
            this.thread = null;
        }
    }

    private void locked_halt() {
        I2PServerSocket ss = this._util.getServerSocket();
        if (ss != null) {
            try {
                ss.close();
            }
            catch (I2PException i2PException) {
                // empty catch block
            }
        }
        this._badCounter.clear();
        this._cleaner.cancel();
    }

    public synchronized void restart() {
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
    }

    public int getPort() {
        return 6881;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.run2();
        }
        finally {
            ConnectionAcceptor connectionAcceptor = this;
            synchronized (connectionAcceptor) {
                this.thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run2() {
        while (!this.stop) {
            I2PServerSocket serverSocket = this._util.getServerSocket();
            while (serverSocket == null && !this.stop) {
                if (!this._util.isConnecting() && !this._util.connected()) {
                    this.stop = true;
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                serverSocket = this._util.getServerSocket();
            }
            if (this.stop) break;
            try {
                I2PSocket socket = serverSocket.accept();
                if (socket == null) continue;
                if (socket.getPeerDestination().equals(this._util.getMyDestination())) {
                    this._log.error("Incoming connection from myself");
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {}
                    continue;
                }
                Hash h = socket.getPeerDestination().calculateHash();
                if (socket.getLocalPort() == 80) {
                    this._badCounter.increment(h);
                    if (this._log.shouldLog(30)) {
                        this._log.error("Dropping incoming HTTP from " + h);
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {}
                    continue;
                }
                int bad = this._badCounter.count(h);
                if (bad >= 1) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Rejecting connection from " + h + " after " + bad + " failures, max is " + 1);
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {}
                    continue;
                }
                I2PAppThread t = new I2PAppThread(new Handler(socket), "I2PSnark incoming connection");
                t.start();
            }
            catch (I2PException ioe) {
                int level;
                int n = level = this.stop ? 30 : 40;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "Error while accepting", ioe);
                }
                ConnectionAcceptor connectionAcceptor = this;
                synchronized (connectionAcceptor) {
                    if (!this.stop) {
                        this.locked_halt();
                        this.thread = null;
                        this.stop = true;
                    }
                }
            }
            catch (IOException ioe) {
                int level;
                int n = level = this.stop ? 30 : 40;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "Error while accepting", ioe);
                }
                ConnectionAcceptor connectionAcceptor = this;
                synchronized (connectionAcceptor) {
                    if (!this.stop) {
                        this.locked_halt();
                        this.thread = null;
                        this.stop = true;
                    }
                }
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("ConnectionAcceptor closed");
        }
    }

    private class Cleaner
    extends SimpleTimer2.TimedEvent {
        public Cleaner() {
            super(ConnectionAcceptor.this._util.getContext().simpleTimer2());
        }

        public void timeReached() {
            if (ConnectionAcceptor.this.stop) {
                return;
            }
            ConnectionAcceptor.this._badCounter.clear();
            this.schedule(1800000L);
        }
    }

    private class Handler
    implements Runnable {
        private final I2PSocket _socket;

        public Handler(I2PSocket socket) {
            this._socket = socket;
        }

        public void run() {
            try {
                InputStream in = this._socket.getInputStream();
                OutputStream out = this._socket.getOutputStream();
                in = new BufferedInputStream(in);
                if (ConnectionAcceptor.this._log.shouldLog(10)) {
                    ConnectionAcceptor.this._log.debug("Handling socket from " + this._socket.getPeerDestination().calculateHash());
                }
                ConnectionAcceptor.this.peeracceptor.connection(this._socket, in, out);
            }
            catch (PeerAcceptor.ProtocolException ihe) {
                ConnectionAcceptor.this._badCounter.increment(this._socket.getPeerDestination().calculateHash());
                if (ConnectionAcceptor.this._log.shouldLog(20)) {
                    ConnectionAcceptor.this._log.info("Protocol error from " + this._socket.getPeerDestination().calculateHash(), ihe);
                }
                try {
                    this._socket.close();
                }
                catch (IOException ignored) {}
            }
            catch (IOException ioe) {
                if (ConnectionAcceptor.this._log.shouldLog(10)) {
                    ConnectionAcceptor.this._log.debug("Error handling connection from " + this._socket.getPeerDestination().calculateHash(), ioe);
                }
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

