/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerID;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.InvalidBEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerInfo {
    private final String failure_reason;
    private final int interval;
    private final Set<Peer> peers;
    private int complete;
    private int incomplete;
    private static final int HASH_LENGTH = 32;

    public TrackerInfo(InputStream in, byte[] my_id, byte[] infohash, MetaInfo metainfo) throws IOException {
        this(new BDecoder(in), my_id, infohash, metainfo);
    }

    private TrackerInfo(BDecoder be, byte[] my_id, byte[] infohash, MetaInfo metainfo) throws IOException {
        this(be.bdecodeMap().getMap(), my_id, infohash, metainfo);
    }

    private TrackerInfo(Map m, byte[] my_id, byte[] infohash, MetaInfo metainfo) throws IOException {
        BEValue reason = (BEValue)m.get("failure reason");
        if (reason != null) {
            this.failure_reason = reason.getString();
            this.interval = -1;
            this.peers = null;
        } else {
            this.failure_reason = null;
            BEValue beInterval = (BEValue)m.get("interval");
            if (beInterval == null) {
                throw new InvalidBEncodingException("No interval given");
            }
            this.interval = beInterval.getInt();
            BEValue bePeers = (BEValue)m.get("peers");
            if (bePeers == null) {
                this.peers = Collections.EMPTY_SET;
            } else {
                Set<Peer> p;
                try {
                    p = TrackerInfo.getPeers(bePeers.getBytes(), my_id, infohash, metainfo);
                }
                catch (InvalidBEncodingException ibe) {
                    p = TrackerInfo.getPeers(bePeers.getList(), my_id, infohash, metainfo);
                }
                this.peers = p;
            }
            BEValue bev = (BEValue)m.get("complete");
            if (bev != null) {
                try {
                    this.complete = bev.getInt();
                    if (this.complete < 0) {
                        this.complete = 0;
                    }
                }
                catch (InvalidBEncodingException ibe) {
                    // empty catch block
                }
            }
            if ((bev = (BEValue)m.get("incomplete")) != null) {
                try {
                    this.incomplete = bev.getInt();
                    if (this.incomplete < 0) {
                        this.incomplete = 0;
                    }
                }
                catch (InvalidBEncodingException ibe) {
                    // empty catch block
                }
            }
        }
    }

    private static Set<Peer> getPeers(List<BEValue> l, byte[] my_id, byte[] infohash, MetaInfo metainfo) throws IOException {
        HashSet<Peer> peers = new HashSet<Peer>(l.size());
        for (BEValue bev : l) {
            PeerID peerID;
            try {
                peerID = new PeerID(bev.getMap());
            }
            catch (InvalidBEncodingException ibe) {
                try {
                    peerID = new PeerID(bev.getBytes());
                }
                catch (InvalidBEncodingException ibe2) {
                    continue;
                }
            }
            peers.add(new Peer(peerID, my_id, infohash, metainfo));
        }
        return peers;
    }

    private static Set<Peer> getPeers(byte[] l, byte[] my_id, byte[] infohash, MetaInfo metainfo) throws IOException {
        int count = l.length / 32;
        HashSet<Peer> peers = new HashSet<Peer>(count);
        for (int i = 0; i < count; ++i) {
            PeerID peerID;
            byte[] hash = new byte[32];
            System.arraycopy(l, i * 32, hash, 0, 32);
            try {
                peerID = new PeerID(hash);
            }
            catch (InvalidBEncodingException ibe) {
                continue;
            }
            peers.add(new Peer(peerID, my_id, infohash, metainfo));
        }
        return peers;
    }

    public Set<Peer> getPeers() {
        return this.peers;
    }

    public int getPeerCount() {
        int pc = this.peers == null ? 0 : this.peers.size();
        return Math.max(pc, this.complete + this.incomplete - 1);
    }

    public String getFailureReason() {
        return this.failure_reason;
    }

    public int getInterval() {
        return this.interval;
    }

    public String toString() {
        if (this.failure_reason != null) {
            return "TrackerInfo[FAILED: " + this.failure_reason + "]";
        }
        return "TrackerInfo[interval=" + this.interval + (this.complete > 0 ? ", complete=" + this.complete : "") + (this.incomplete > 0 ? ", incomplete=" + this.incomplete : "") + ", peers=" + this.peers + "]";
    }
}

