/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.util.Clock;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerID;
import org.klomp.snark.Snark;
import org.klomp.snark.SnarkManager;
import org.klomp.snark.TrackerInfo;

public class TrackerClient
implements Runnable {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(TrackerClient.class);
    private static final String NO_EVENT = "";
    private static final String STARTED_EVENT = "started";
    private static final String COMPLETED_EVENT = "completed";
    private static final String STOPPED_EVENT = "stopped";
    private static final String NOT_REGISTERED = "torrent not registered";
    private static final int SLEEP = 5;
    private static final int DELAY_MIN = 2000;
    private static final int DELAY_RAND = 6000;
    private static final int MAX_REGISTER_FAILS = 10;
    private static final int INITIAL_SLEEP = 90000;
    private static final int MAX_CONSEC_FAILS = 5;
    private static final int LONG_SLEEP = 1800000;
    private final I2PSnarkUtil _util;
    private final MetaInfo meta;
    private final String infoHash;
    private final String peerID;
    private final String additionalTrackerURL;
    private final PeerCoordinator coordinator;
    private final Snark snark;
    private final int port;
    private final String _threadName;
    private volatile boolean stop = true;
    private volatile boolean started;
    private volatile boolean _initialized;
    private volatile int _runCount;
    private volatile Thread _thread;
    private volatile SimpleTimer2.TimedEvent _event;
    private volatile boolean runStarted;
    private volatile int consecutiveFails;
    private volatile boolean _fastUnannounce;
    private final List<Tracker> trackers;

    public TrackerClient(I2PSnarkUtil util, MetaInfo meta, String additionalTrackerURL, PeerCoordinator coordinator, Snark snark) {
        String id = TrackerClient.urlencode(snark.getID());
        this._threadName = "TrackerClient " + id.substring(id.length() - 12);
        this._util = util;
        this.meta = meta;
        this.additionalTrackerURL = additionalTrackerURL;
        this.coordinator = coordinator;
        this.snark = snark;
        this.port = 6881;
        this.infoHash = TrackerClient.urlencode(snark.getInfoHash());
        this.peerID = TrackerClient.urlencode(snark.getID());
        this.trackers = new ArrayList<Tracker>(2);
    }

    public synchronized void start() {
        if (!this.stop) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Already started: " + this._threadName);
            }
            return;
        }
        this.stop = false;
        this.consecutiveFails = 0;
        this.runStarted = false;
        this._fastUnannounce = false;
        this._thread = new I2PAppThread(this, this._threadName + " #" + ++this._runCount, true);
        this._thread.start();
        this.started = true;
    }

    public boolean halted() {
        return this.stop;
    }

    public boolean started() {
        return this.started;
    }

    public synchronized void halt(boolean fast) {
        Thread t;
        SimpleTimer2.TimedEvent e;
        boolean wasStopped = this.stop;
        if (wasStopped) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Already stopped: " + this._threadName);
            }
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("Stopping: " + this._threadName);
            }
            this.stop = true;
        }
        if ((e = this._event) != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Cancelling next announce " + this._threadName);
            }
            e.cancel();
            this._event = null;
        }
        if ((t = this._thread) != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Interrupting " + t.getName());
            }
            t.interrupt();
        }
        this._fastUnannounce = true;
        if (!wasStopped) {
            this.unannounce();
        }
    }

    private void queueLoop(long delay) {
        this._event = new Runner(delay);
    }

    private boolean verifyConnected() {
        while (!this.stop && !this._util.connected()) {
            boolean ok = this._util.connect();
            if (ok) continue;
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.stop && this._util.connected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long begin = Clock.getInstance().now();
        if (this._log.shouldLog(10)) {
            this._log.debug("Start " + Thread.currentThread().getName());
        }
        try {
            if (!this._initialized) {
                this.setup();
                if (this.trackers.isEmpty()) {
                    this.stop = true;
                    return;
                }
                this._initialized = true;
                long delay = I2PAppContext.getGlobalContext().random().nextInt(30000);
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            this.loop();
        }
        finally {
            this._thread = null;
            if (this._log.shouldLog(10)) {
                this._log.debug("Finish " + Thread.currentThread().getName() + " after " + DataHelper.formatDuration(Clock.getInstance().now() - begin));
            }
        }
    }

    private void setup() {
        String primary = null;
        if (this.meta != null) {
            primary = this.meta.getAnnounce();
        } else if (this.additionalTrackerURL != null) {
            primary = this.additionalTrackerURL;
        }
        if (primary != null) {
            if (TrackerClient.isValidAnnounce(primary)) {
                this.trackers.add(new Tracker(primary, true));
                this._log.debug("Announce: [" + primary + "] infoHash: " + this.infoHash);
            } else {
                this._log.warn("Skipping invalid or non-i2p announce: " + primary);
            }
        } else {
            this._log.warn("No primary announce");
            primary = NO_EVENT;
        }
        List<String> tlist = this._util.getOpenTrackers();
        if (!(tlist == null || this.meta != null && this.meta.isPrivate())) {
            for (int i = 0; i < tlist.size(); ++i) {
                String url = tlist.get(i);
                if (!TrackerClient.isValidAnnounce(url)) {
                    this._log.error("Bad announce URL: [" + url + "]");
                    continue;
                }
                int slash = url.indexOf(47, 7);
                if (slash <= 7) {
                    this._log.error("Bad announce URL: [" + url + "]");
                    continue;
                }
                if (primary.startsWith(url.substring(0, slash))) continue;
                String dest = this._util.lookup(url.substring(7, slash));
                if (dest == null) {
                    this._log.error("Announce host unknown: [" + url.substring(7, slash) + "]");
                    continue;
                }
                if (primary.startsWith("http://" + dest) || primary.startsWith("http://i2p/" + dest)) continue;
                this.trackers.add(new Tracker(url, primary.equals(NO_EVENT)));
                this._log.debug("Additional announce: [" + url + "] for infoHash: " + this.infoHash);
            }
        }
        if (this.trackers.isEmpty()) {
            this.stop = true;
            SnarkManager.instance().addMessage("No valid trackers for " + this.snark.getBaseName() + " - enable opentrackers?");
            this._log.error("No valid trackers for " + this.snark.getBaseName());
            this.snark.stopTorrent();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loop() {
        block46: {
            try {
                r = I2PAppContext.getGlobalContext().random();
                while (!this.stop) {
                    if (!this.verifyConnected()) {
                        this.stop = true;
                        return;
                    }
                    if (this._util.getDHT() != null) {
                        this._util.getDHT().announce(this.snark.getInfoHash());
                    }
                    uploaded = this.coordinator.getUploaded();
                    downloaded = this.coordinator.getDownloaded();
                    left = this.coordinator.getLeft();
                    v0 = completed = left == 0L;
                    if (!completed && left == 0L) {
                        completed = true;
                        event = "completed";
                    } else {
                        event = "";
                    }
                    maxSeenPeers = 0;
                    for (Tracker tr : this.trackers) {
                        if (!(this.stop || tr.stop || !completed && !this.coordinator.needOutboundPeers() && tr.started || !event.equals("completed") && System.currentTimeMillis() <= tr.lastRequestTime + tr.interval)) {
                            try {
                                if (!tr.started) {
                                    event = "started";
                                }
                                info = this.doRequest(tr, this.infoHash, this.peerID, uploaded, downloaded, left, event);
                                this.snark.setTrackerProblems(null);
                                tr.trackerProblems = null;
                                tr.registerFails = 0;
                                tr.consecutiveFails = 0;
                                if (tr.isPrimary) {
                                    this.consecutiveFails = 0;
                                }
                                this.runStarted = true;
                                tr.started = true;
                                peers = info.getPeers();
                                tr.seenPeers = info.getPeerCount();
                                if (this.snark.getTrackerSeenPeers() < tr.seenPeers) {
                                    this.snark.setTrackerSeenPeers(tr.seenPeers);
                                }
                                if (this._util.getDHT() != null) {
                                    for (Peer peer : peers) {
                                        this._util.getDHT().announce(this.snark.getInfoHash(), peer.getPeerID().getDestHash());
                                    }
                                }
                                if (!this.coordinator.needOutboundPeers()) ** GOTO lbl73
                                ordered = new ArrayList<Peer>(peers);
                                Collections.shuffle(ordered, r);
                                it = ordered.iterator();
                                while (!this.stop && it.hasNext() && this.coordinator.needOutboundPeers()) {
                                    cur = (Peer)it.next();
                                    if (!this.coordinator.addPeer(cur) || !it.hasNext()) continue;
                                    delay = r.nextInt(6000) + 2000;
                                    try {
                                        Thread.sleep(delay);
                                    }
                                    catch (InterruptedException ie) {}
                                }
                            }
                            catch (IOException ioe) {
                                this._util.debug("WARNING: Could not contact tracker at '" + tr.announce + "': " + ioe, 2);
                                tr.trackerProblems = ioe.getMessage();
                                if (tr.isPrimary) {
                                    this.snark.setTrackerProblems(tr.trackerProblems);
                                }
                                if (tr.trackerProblems.toLowerCase(Locale.US).startsWith("torrent not registered")) {
                                    if (this.trackers.size() == 1) {
                                        this.stop = true;
                                        this.snark.stopTorrent();
                                    } else if (tr.registerFails++ > 10) {
                                        tr.stop = true;
                                    }
                                }
                                if (++tr.consecutiveFails != 5) ** GOTO lbl73
                                tr.seenPeers = 0;
                                if (tr.interval >= 1800000L) ** GOTO lbl73
                                tr.interval = 1800000L;
                            }
                        } else {
                            this._util.debug("Not announcing to " + tr.announce + " last announce was " + new Date(tr.lastRequestTime) + " interval is " + DataHelper.formatDuration(tr.interval), 4);
                        }
lbl73:
                        // 6 sources

                        if (tr.stop || maxSeenPeers >= tr.seenPeers) continue;
                        maxSeenPeers = tr.seenPeers;
                    }
                    if (!(!this.coordinator.needOutboundPeers() || this.meta != null && this.meta.isPrivate() || this.stop)) {
                        pids = this.coordinator.getPEXPeers();
                        if (!pids.isEmpty()) {
                            this._util.debug("Got " + pids.size() + " from PEX", 4);
                            peers = new ArrayList<Peer>(pids.size());
                            for (PeerID pID : pids) {
                                peers.add(new Peer(pID, this.snark.getID(), this.snark.getInfoHash(), this.snark.getMetaInfo()));
                            }
                            Collections.shuffle(peers, r);
                            it = peers.iterator();
                            while (!this.stop && it.hasNext() && this.coordinator.needOutboundPeers()) {
                                cur = (Peer)it.next();
                                if (!this.coordinator.addPeer(cur) || !it.hasNext()) continue;
                                delay = r.nextInt(6000) + 2000;
                                try {
                                    Thread.sleep(delay);
                                }
                                catch (InterruptedException ie) {}
                            }
                        }
                    } else {
                        this._util.debug("Not getting PEX peers", 4);
                    }
                    if (!(this._util.getDHT() == null || this.meta != null && this.meta.isPrivate() || this.stop)) {
                        numwant = event.equals("stopped") != false || this.coordinator.needOutboundPeers() == false ? 1 : this._util.getMaxConnections();
                        hashes = this._util.getDHT().getPeers(this.snark.getInfoHash(), numwant, 120000L);
                        this._util.debug("Got " + hashes + " from DHT", 4);
                        if (!this.stop) {
                            good = this._util.getDHT().announce(this.snark.getInfoHash(), 8, 300000L);
                            this._util.debug("Sent " + good + " good announces to DHT", 4);
                        }
                        if (!this.stop && !hashes.isEmpty()) {
                            peers = new ArrayList<Peer>(hashes.size());
                            for (Hash h : hashes) {
                                pID = new PeerID(h.getData());
                                peers.add(new Peer(pID, this.snark.getID(), this.snark.getInfoHash(), this.snark.getMetaInfo()));
                            }
                            Collections.shuffle(peers, r);
                            it = peers.iterator();
                            while (!this.stop && it.hasNext() && this.coordinator.needOutboundPeers()) {
                                cur = (Peer)it.next();
                                if (!this.coordinator.addPeer(cur) || !it.hasNext()) continue;
                                delay = r.nextInt(6000) + 2000;
                                try {
                                    Thread.sleep(delay);
                                }
                                catch (InterruptedException ie) {}
                            }
                        }
                    } else {
                        this._util.debug("Not getting DHT peers", 4);
                    }
                    this.snark.setTrackerSeenPeers(maxSeenPeers);
                    if (this.stop) {
                        return;
                    }
                    if (!this.runStarted) {
                        this._util.debug("         Retrying in one minute...", 5);
                    }
                    try {
                        random = r.nextInt(120000);
                        delay = completed != false && this.runStarted != false ? 900000 + random : (this.snark.getTrackerProblems() != null && ++this.consecutiveFails < 5 ? 90000 : 300000 + random);
                        if (delay > 20000) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("Requeueing in " + DataHelper.formatDuration(delay) + ": " + Thread.currentThread().getName());
                            }
                            this.queueLoop(delay);
                            return;
                        }
                        if (delay <= 0) continue;
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interrupt) {}
                }
            }
            catch (Throwable t) {
                this._util.debug("TrackerClient: " + t, 1, t);
                if (!(t instanceof OutOfMemoryError)) break block46;
                throw (OutOfMemoryError)t;
            }
        }
    }

    private void unannounce() {
        if (this._util.getDHT() != null) {
            this._util.getDHT().unannounce(this.snark.getInfoHash());
        }
        int i = 0;
        for (Tracker tr : this.trackers) {
            if (this._util.connected() && tr.started && !tr.stop && tr.trackerProblems == null) {
                try {
                    new I2PAppThread(new Unannouncer(tr), this._threadName + " U" + ++i, true).start();
                }
                catch (OutOfMemoryError oom) {
                    tr.reset();
                }
                continue;
            }
            tr.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackerInfo doRequest(Tracker tr, String infoHash, String peerID, long uploaded, long downloaded, long left, String event) throws IOException {
        StringBuilder buf = new StringBuilder(512);
        buf.append(tr.announce);
        if (tr.announce.contains("?")) {
            buf.append('&');
        } else {
            buf.append('?');
        }
        buf.append("info_hash=").append(infoHash).append("&peer_id=").append(peerID).append("&port=").append(this.port).append("&ip=").append(this._util.getOurIPString()).append(".i2p").append("&uploaded=").append(uploaded).append("&downloaded=").append(downloaded).append("&left=");
        if (left >= 0L) {
            buf.append(left);
        } else {
            buf.append('1');
        }
        buf.append("&compact=1");
        if (!event.equals(NO_EVENT)) {
            buf.append("&event=").append(event);
        }
        buf.append("&numwant=");
        if (left == 0L || event.equals(STOPPED_EVENT) || !this.coordinator.needOutboundPeers()) {
            buf.append('0');
        } else {
            buf.append(this._util.getMaxConnections());
        }
        String s = buf.toString();
        this._util.debug("Sending TrackerClient request: " + s, 4);
        tr.lastRequestTime = System.currentTimeMillis();
        boolean fast = this._fastUnannounce && event.equals(STOPPED_EVENT);
        File fetched = this._util.get(s, true, fast ? -1 : 0);
        if (fetched == null) {
            throw new IOException("Error fetching " + s);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(fetched);
            TrackerInfo info = new TrackerInfo(in, this.snark.getID(), this.snark.getInfoHash(), this.snark.getMetaInfo());
            this._util.debug("TrackerClient response: " + info, 4);
            String failure = info.getFailureReason();
            if (failure != null) {
                throw new IOException(failure);
            }
            tr.interval = info.getInterval() * 1000;
            TrackerInfo trackerInfo = info;
            return trackerInfo;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe) {}
            }
            fetched.delete();
        }
    }

    public static String urlencode(byte[] bs) {
        StringBuilder sb = new StringBuilder(bs.length * 3);
        for (int i = 0; i < bs.length; ++i) {
            int c = bs[i] & 0xFF;
            if (c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                sb.append((char)c);
                continue;
            }
            sb.append('%');
            if (c < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        return sb.toString();
    }

    public static boolean isValidAnnounce(String ann) {
        URL url;
        try {
            url = new URL(ann);
        }
        catch (MalformedURLException mue) {
            return false;
        }
        return url.getProtocol().equals("http") && (url.getHost().endsWith(".i2p") || url.getHost().equals("i2p")) && url.getPort() < 0;
    }

    private class Runner
    extends SimpleTimer2.TimedEvent {
        public Runner(long delay) {
            super(SimpleTimer2.getInstance(), delay);
        }

        public void timeReached() {
            TrackerClient.this._event = null;
            TrackerClient.this._thread = new I2PAppThread(TrackerClient.this, TrackerClient.this._threadName + " #" + ++TrackerClient.this._runCount, true);
            TrackerClient.this._thread.start();
        }
    }

    private static class Tracker {
        String announce;
        boolean isPrimary;
        long interval;
        long lastRequestTime;
        String trackerProblems;
        boolean stop;
        boolean started;
        int registerFails;
        int consecutiveFails;
        int seenPeers;

        public Tracker(String a, boolean p) {
            this.announce = a;
            this.isPrimary = p;
            this.interval = 90000L;
        }

        public void reset() {
            this.lastRequestTime = 0L;
            this.trackerProblems = null;
            this.stop = false;
            this.started = false;
            this.registerFails = 0;
            this.consecutiveFails = 0;
            this.seenPeers = 0;
        }
    }

    private class Unannouncer
    implements Runnable {
        private final Tracker tr;

        public Unannouncer(Tracker tr) {
            this.tr = tr;
        }

        public void run() {
            if (TrackerClient.this._log.shouldLog(10)) {
                TrackerClient.this._log.debug("Running unannounce " + TrackerClient.this._threadName + " to " + this.tr.announce);
            }
            long uploaded = TrackerClient.this.coordinator.getUploaded();
            long downloaded = TrackerClient.this.coordinator.getDownloaded();
            long left = TrackerClient.this.coordinator.getLeft();
            try {
                if (TrackerClient.this._util.connected() && this.tr.started && !this.tr.stop && this.tr.trackerProblems == null) {
                    TrackerClient.this.doRequest(this.tr, TrackerClient.this.infoHash, TrackerClient.this.peerID, uploaded, downloaded, left, TrackerClient.STOPPED_EVENT);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.tr.reset();
        }
    }
}

