/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.HashSet;
import java.util.Set;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerID;

class Piece
implements Comparable {
    private final int id;
    private final Set<PeerID> peers;
    private Set<PeerID> requests;
    private int priority;

    public Piece(int id) {
        this.id = id;
        this.peers = new HashSet<PeerID>(16);
    }

    public int compareTo(Object o) throws ClassCastException {
        int pdiff = ((Piece)o).priority - this.priority;
        if (pdiff != 0) {
            return pdiff;
        }
        return this.peers.size() - ((Piece)o).peers.size();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Piece) {
            return this.id == ((Piece)o).id;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 31 * hash + this.id;
        return hash;
    }

    public int getId() {
        return this.id;
    }

    public boolean addPeer(Peer peer) {
        return this.peers.add(peer.getPeerID());
    }

    public boolean removePeer(Peer peer) {
        return this.peers.remove(peer.getPeerID());
    }

    public int getPeerCount() {
        return this.peers.size();
    }

    public boolean isRequested() {
        return this.requests != null && !this.requests.isEmpty();
    }

    public void setRequested(Peer peer, boolean requested) {
        if (requested) {
            if (this.requests == null) {
                this.requests = new HashSet<PeerID>(2);
            }
            this.requests.add(peer.getPeerID());
        } else if (this.requests != null) {
            this.requests.remove(peer.getPeerID());
        }
    }

    public boolean isRequestedBy(Peer peer) {
        return this.requests != null && this.requests.contains(peer.getPeerID());
    }

    public int getRequestCount() {
        return this.requests == null ? 0 : this.requests.size();
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    public boolean isDisabled() {
        return this.priority < 0;
    }

    public void setDisabled() {
        this.priority = -1;
    }

    public String toString() {
        return String.valueOf(this.id);
    }
}

