/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataFormatException;
import net.i2p.sam.SAMMessageSession;
import net.i2p.sam.SAMRawReceiver;
import net.i2p.util.Log;

public class SAMRawSession
extends SAMMessageSession {
    private static final Log _log = new Log(SAMRawSession.class);
    public static final int RAW_SIZE_MAX = 32768;
    protected SAMRawReceiver recv = null;

    public SAMRawSession(String dest, Properties props, SAMRawReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(dest, props);
        this.recv = recv;
    }

    public SAMRawSession(InputStream destStream, Properties props, SAMRawReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(destStream, props);
        this.recv = recv;
    }

    public boolean sendBytes(String dest, byte[] data) throws DataFormatException {
        if (data.length > 32768) {
            throw new DataFormatException("Data size limit exceeded (" + data.length + ")");
        }
        return this.sendBytesThroughMessageSession(dest, data);
    }

    protected void messageReceived(byte[] msg) {
        try {
            this.recv.receiveRawBytes(msg);
        }
        catch (IOException e) {
            _log.error("Error forwarding message to receiver", e);
            this.close();
        }
    }

    protected void shutDown() {
        this.recv.stopRawReceiving();
    }
}

