/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.router.web.SummaryListener;
import net.i2p.util.Log;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphDefTemplate;

class SummaryRenderer {
    private final Log _log;
    private final SummaryListener _listener;
    private final I2PAppContext _context;
    static final Color RESTART_BAR_COLOR = new Color(255, 144, 0, 224);
    private static final boolean IS_WIN = System.getProperty("os.name").startsWith("Win");

    public SummaryRenderer(I2PAppContext ctx, SummaryListener lsnr) {
        this._log = ctx.logManager().getLog(SummaryRenderer.class);
        this._listener = lsnr;
        this._context = ctx;
    }

    public static synchronized void render(I2PAppContext ctx, OutputStream out, String filename) throws IOException {
        long end = ctx.clock().now() - 60000L;
        long start = end - 86400000L;
        try {
            RrdGraphDefTemplate template = new RrdGraphDefTemplate(filename);
            RrdGraphDef def = template.getRrdGraphDef();
            def.setTimeSpan(start / 1000L, end / 1000L);
            int width = 250;
            int height = 100;
            def.setWidth(width);
            def.setHeight(height);
            RrdGraph graph = new RrdGraph(def);
            int totalWidth = graph.getRrdGraphInfo().getWidth();
            int totalHeight = graph.getRrdGraphInfo().getHeight();
            BufferedImage img = new BufferedImage(totalWidth, totalHeight, 8);
            Graphics gfx = img.getGraphics();
            graph.render(gfx);
            MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(out);
            ImageIO.write((RenderedImage)img, "png", ios);
        }
        catch (RrdException re) {
            throw new IOException("Error plotting: " + re.getMessage());
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public void render(OutputStream out) throws IOException {
        this.render(out, 250, 100, false, false, false, false, -1, 0, false);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit) throws IOException {
        long end = this._listener.now() - 75000L;
        long period = this._listener.getRate().getPeriod();
        if (endp > 0) {
            end -= period * (long)endp;
        }
        if (periodCount <= 0 || periodCount > this._listener.getRows()) {
            periodCount = this._listener.getRows();
        }
        long start = end - period * (long)periodCount;
        ImageInputStream ios = null;
        try {
            RrdGraphDef def = new RrdGraphDef();
            def.setTimeSpan(start / 1000L, end / 1000L);
            def.setMinValue(0.0);
            String name = this._listener.getRate().getRateStat().getName();
            if ((name.startsWith("bw.") || name.indexOf("Size") >= 0 || name.indexOf("Bps") >= 0 || name.indexOf("memory") >= 0) && !showEvents) {
                def.setBase(1024.0);
            }
            if (!hideTitle) {
                String p = IS_WIN && "zh".equals(Messages.getLanguage(this._context)) ? DataHelper.formatDuration(period) : DataHelper.formatDuration2(period).replace("&nbsp;", " ");
                String title = showEvents ? name + ' ' + this._("events in {0}", p) : name + ' ' + this._("averaged for {0}", p);
                def.setTitle(title);
            }
            String path = this._listener.getData().getPath();
            String[] dsNames = this._listener.getData().getDsNames();
            String plotName = null;
            String descr = null;
            if (showEvents) {
                plotName = dsNames[1];
                descr = this._("Events per period");
            } else {
                plotName = dsNames[0];
                descr = this._(this._listener.getRate().getRateStat().getDescription());
            }
            long started = ((RouterContext)this._context).router().getWhenStarted();
            if (started > start && started < end) {
                def.vrule(started / 1000L, RESTART_BAR_COLOR, this._("Restart"), 4.0f);
            }
            def.datasource(plotName, path, plotName, "AVERAGE", this._listener.getBackendName());
            if (descr.length() > 0) {
                def.area(plotName, Color.BLUE, descr + "\\r");
            } else {
                def.area(plotName, Color.BLUE);
            }
            if (!hideLegend) {
                def.gprint(plotName, "AVERAGE", this._("avg") + ": %.2f %s");
                def.gprint(plotName, "MAX", ' ' + this._("max") + ": %.2f %S");
                def.gprint(plotName, "LAST", ' ' + this._("now") + ": %.2f %S\\r");
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM HH:mm");
                def.comment(sdf.format(new Date(start)) + " -- " + sdf.format(new Date(end)) + " UTC\\r");
            }
            if (!showCredit) {
                def.setShowSignature(false);
            }
            if (hideLegend) {
                def.setNoLegend(true);
            }
            if (hideGrid) {
                def.setDrawXGrid(false);
                def.setDrawYGrid(false);
            }
            def.setAntiAliasing(false);
            def.setWidth(width);
            def.setHeight(height);
            def.setImageFormat("PNG");
            def.setLazy(true);
            RrdGraph graph = new RrdGraph(def);
            int totalWidth = graph.getRrdGraphInfo().getWidth();
            int totalHeight = graph.getRrdGraphInfo().getHeight();
            BufferedImage img = new BufferedImage(totalWidth, totalHeight, 8);
            Graphics gfx = img.getGraphics();
            graph.render(gfx);
            ios = new MemoryCacheImageOutputStream(out);
            ImageIO.write((RenderedImage)img, "png", (ImageOutputStream)ios);
        }
        catch (RrdException re) {
            this._log.error("Error rendering", re);
            throw new IOException("Error plotting: " + re.getMessage());
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error rendering", ioe);
            }
            throw ioe;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error rendering", oom);
            throw new IOException("Error plotting: " + oom.getMessage());
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private String _(String s) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s;
        }
        return Messages.getString(s, this._context);
    }

    private String _(String s, String o) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s.replace("{0}", o);
        }
        return Messages.getString(s, o, this._context);
    }
}

