/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.router.web.SummaryListener;
import net.i2p.router.web.SummaryRenderer;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatSummarizer
implements Runnable {
    private final RouterContext _context = RouterContext.listContexts().get(0);
    private final Log _log = this._context.logManager().getLog(this.getClass());
    private final List<SummaryListener> _listeners = new CopyOnWriteArrayList<SummaryListener>();
    private static StatSummarizer _instance;
    private static final int MAX_CONCURRENT_PNG = 3;
    private final Semaphore _sem;
    private volatile boolean _isRunning = true;
    private boolean _isDisabled;
    private Thread _thread;
    private static final String DEFAULT_DATABASES = "bw.sendRate.60000,bw.recvRate.60000,router.memoryUsed.60000,router.activePeers.60000";
    private static final boolean IS_WIN;

    public StatSummarizer() {
        _instance = this;
        this._sem = new Semaphore(3, true);
        this._context.addShutdownTask(new Shutdown());
    }

    public static StatSummarizer instance() {
        return _instance;
    }

    @Override
    public void run() {
        String vendor = System.getProperty("java.vendor");
        if (vendor.startsWith("Apache") || vendor.startsWith("GNU Classpath") || vendor.startsWith("Free Software Foundation")) {
            this._log.logAlways(30, "Graphing not supported with this JVM: " + vendor + ' ' + System.getProperty("java.version") + " (" + System.getProperty("java.runtime.name") + ' ' + System.getProperty("java.runtime.version") + ')');
            this._isDisabled = true;
            this._isRunning = false;
            return;
        }
        boolean isPersistent = this._context.getBooleanPropertyDefaultTrue("routerconsole.graphPersistent");
        if (!isPersistent) {
            this.deleteOldRRDs();
        }
        this._thread = Thread.currentThread();
        String specs = "";
        while (this._isRunning && this._context.router().isAlive()) {
            specs = this.adjustDatabases(specs);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ie) {}
        }
    }

    static boolean isDisabled() {
        return _instance == null || StatSummarizer._instance._isDisabled;
    }

    List<SummaryListener> getListeners() {
        return this._listeners;
    }

    private String adjustDatabases(String oldSpecs) {
        String spec = this._context.getProperty("stat.summaries", DEFAULT_DATABASES);
        if (spec == null && oldSpecs == null || spec != null && oldSpecs != null && oldSpecs.equals(spec)) {
            return oldSpecs;
        }
        List<Rate> old = this.parseSpecs(oldSpecs);
        List<Rate> newSpecs = this.parseSpecs(spec);
        for (Rate r : old) {
            if (newSpecs.contains(r)) continue;
            this.removeDb(r);
        }
        StringBuilder buf = new StringBuilder();
        boolean comma = false;
        for (Rate r : newSpecs) {
            if (!old.contains(r)) {
                this.addDb(r);
            }
            if (comma) {
                buf.append(',');
            } else {
                comma = true;
            }
            buf.append(r.getRateStat().getName()).append(".").append(r.getPeriod());
        }
        return buf.toString();
    }

    private void removeDb(Rate r) {
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(r)) continue;
            this._listeners.remove(lsnr);
            lsnr.stopListening();
            return;
        }
    }

    private void addDb(Rate r) {
        SummaryListener lsnr = new SummaryListener(r);
        boolean success = lsnr.startListening();
        if (success) {
            this._listeners.add(lsnr);
        } else {
            this._log.error("Failed to add RRD for rate " + r.getRateStat().getName() + '.' + r.getPeriod());
        }
    }

    public boolean renderPng(Rate rate, OutputStream out) throws IOException {
        return this.renderPng(rate, out, 250, 100, false, false, false, false, -1, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderPng(Rate rate, OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            boolean bl = this.locked_renderPng(rate, out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit);
            return bl;
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_renderPng(Rate rate, OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int end, boolean showCredit) throws IOException {
        if (width > 2048) {
            width = 2048;
        } else if (width <= 0) {
            width = 250;
        }
        if (height > 1024) {
            height = 1024;
        } else if (height <= 0) {
            height = 100;
        }
        if (end < 0) {
            end = 0;
        }
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(rate)) continue;
            lsnr.renderPng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, end, showCredit);
            return true;
        }
        return false;
    }

    public boolean renderPng(OutputStream out, String templateFilename) throws IOException {
        SummaryRenderer.render(this._context, out, templateFilename);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getXML(Rate rate, OutputStream out) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = this.locked_getXML(rate, out);
            return bl;
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_getXML(Rate rate, OutputStream out) throws IOException {
        for (SummaryListener lsnr : this._listeners) {
            if (!lsnr.getRate().equals(rate)) continue;
            lsnr.getData().exportXml(out);
            out.write(("<!-- Rate: " + lsnr.getRate().getRateStat().getName() + " for period " + lsnr.getRate().getPeriod() + " -->\n").getBytes());
            out.write(("<!-- Average data soure name: " + lsnr.getName() + " event count data source name: " + lsnr.getEventName() + " -->\n").getBytes());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderRatePng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, boolean showCredit) throws IOException {
        try {
            try {
                this._sem.acquire();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            boolean bl = this.locked_renderRatePng(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, showCredit);
            return bl;
        }
        finally {
            this._sem.release();
        }
    }

    private boolean locked_renderRatePng(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, boolean showCredit) throws IOException {
        SummaryListener txLsnr = null;
        SummaryListener rxLsnr = null;
        for (SummaryListener lsnr : StatSummarizer.instance().getListeners()) {
            String title = lsnr.getRate().getRateStat().getName();
            if (title.equals("bw.sendRate")) {
                txLsnr = lsnr;
                continue;
            }
            if (!title.equals("bw.recvRate")) continue;
            rxLsnr = lsnr;
        }
        if (txLsnr == null || rxLsnr == null) {
            throw new IOException("no rates for combined graph");
        }
        long end = this._context.clock().now() - 75000L;
        if (width > 2048) {
            width = 2048;
        } else if (width <= 0) {
            width = 250;
        }
        if (height > 1024) {
            height = 1024;
        } else if (height <= 0) {
            height = 100;
        }
        if (periodCount <= 0 || periodCount > txLsnr.getRows()) {
            periodCount = txLsnr.getRows();
        }
        long period = 60000L;
        long start = end - period * (long)periodCount;
        ImageInputStream ios = null;
        try {
            long started;
            RrdGraphDef def = new RrdGraphDef();
            def.setTimeSpan(start / 1000L, end / 1000L);
            def.setMinValue(0.0);
            def.setBase(1024.0);
            String title = this._("Bandwidth usage");
            if (!hideTitle) {
                def.setTitle(title);
            }
            if ((started = this._context.router().getWhenStarted()) > start && started < end) {
                def.vrule(started / 1000L, SummaryRenderer.RESTART_BAR_COLOR, null, 4.0f);
            }
            String sendName = SummaryListener.createName(this._context, "bw.sendRate.60000");
            String recvName = SummaryListener.createName(this._context, "bw.recvRate.60000");
            def.datasource(sendName, txLsnr.getData().getPath(), sendName, "AVERAGE", txLsnr.getBackendName());
            def.datasource(recvName, rxLsnr.getData().getPath(), recvName, "AVERAGE", rxLsnr.getBackendName());
            def.area(sendName, Color.BLUE, this._("Outbound Bytes/sec"));
            def.line(recvName, Color.RED, this._("Inbound Bytes/sec") + "\\r", 3.0f);
            if (!hideLegend) {
                def.gprint(sendName, "AVERAGE", this._("Out average") + ": %.2f %s" + this._("Bps"));
                def.gprint(sendName, "MAX", ' ' + this._("max") + ": %.2f %S" + this._("Bps") + "\\r");
                def.gprint(recvName, "AVERAGE", this._("In average") + ": %.2f %S" + this._("Bps"));
                def.gprint(recvName, "MAX", ' ' + this._("max") + ": %.2f %S" + this._("Bps") + "\\r");
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM HH:mm");
                def.comment(sdf.format(new Date(start)) + " -- " + sdf.format(new Date(end)) + " UTC\\r");
            }
            if (!showCredit) {
                def.setShowSignature(false);
            }
            if (hideLegend) {
                def.setNoLegend(true);
            }
            if (hideGrid) {
                def.setDrawXGrid(false);
                def.setDrawYGrid(false);
            }
            def.setAntiAliasing(false);
            def.setWidth(width);
            def.setHeight(height);
            def.setImageFormat("PNG");
            def.setLazy(true);
            RrdGraph graph = new RrdGraph(def);
            int totalWidth = graph.getRrdGraphInfo().getWidth();
            int totalHeight = graph.getRrdGraphInfo().getHeight();
            BufferedImage img = new BufferedImage(totalWidth, totalHeight, 8);
            Graphics gfx = img.getGraphics();
            graph.render(gfx);
            ios = new MemoryCacheImageOutputStream(out);
            ImageIO.write((RenderedImage)img, "png", (ImageOutputStream)ios);
            boolean bl = true;
            return bl;
        }
        catch (RrdException re) {
            this._log.error("Error rendering", re);
            throw new IOException("Error plotting: " + re.getMessage());
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error rendering", ioe);
            }
            throw ioe;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error rendering", oom);
            throw new IOException("Error plotting: " + oom.getMessage());
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    List<Rate> parseSpecs(String specs) {
        StringTokenizer tok = new StringTokenizer(specs, ",");
        ArrayList<Rate> rv = new ArrayList<Rate>();
        while (tok.hasMoreTokens()) {
            String spec = tok.nextToken();
            int split = spec.lastIndexOf(46);
            if (split <= 0 || split + 1 >= spec.length()) continue;
            String name = spec.substring(0, split);
            String per = spec.substring(split + 1);
            long period = -1L;
            try {
                Rate r;
                period = Long.parseLong(per);
                RateStat rs = this._context.statManager().getRate(name);
                if (rs == null || (r = rs.getRate(period)) == null) continue;
                rv.add(r);
            }
            catch (NumberFormatException nfe) {}
        }
        return rv;
    }

    private void deleteOldRRDs() {
        File rrdDir = new File(this._context.getRouterDir(), "rrd");
        FileUtil.rmdir(rrdDir, false);
    }

    private String _(String s) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s;
        }
        return Messages.getString(s, this._context);
    }

    static {
        IS_WIN = System.getProperty("os.name").startsWith("Win");
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            StatSummarizer.this._isRunning = false;
            if (StatSummarizer.this._thread != null) {
                StatSummarizer.this._thread.interrupt();
            }
            for (SummaryListener lsnr : StatSummarizer.this._listeners) {
                lsnr.stopListening();
            }
            StatSummarizer.this._listeners.clear();
        }
    }
}

