/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.List;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.UpdateHandler;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.PartialEepGet;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;
import net.i2p.util.VersionComparator;

public class PluginUpdateChecker
extends UpdateHandler {
    private static PluginUpdateCheckerRunner _pluginUpdateCheckerRunner;
    private String _appName;
    private String _oldVersion;
    private String _xpi2pURL;
    private volatile boolean _isNewerAvailable;
    private static PluginUpdateChecker _instance;

    public static final synchronized PluginUpdateChecker getInstance(RouterContext ctx) {
        if (_instance != null) {
            return _instance;
        }
        _instance = new PluginUpdateChecker(ctx);
        return _instance;
    }

    private PluginUpdateChecker(RouterContext ctx) {
        super(ctx);
    }

    public void update() {
        I2PAppThread t = new I2PAppThread(new AllCheckerRunner(), "AllAppChecker", true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String appName) {
        if ("true".equals(System.getProperty("net.i2p.router.web.UpdateHandler.updateInProgress"))) {
            this._log.error("Update already running");
            return;
        }
        Class<UpdateHandler> clazz = UpdateHandler.class;
        synchronized (UpdateHandler.class) {
            Properties props = PluginStarter.pluginProperties(this._context, appName);
            String oldVersion = props.getProperty("version");
            String xpi2pURL = props.getProperty("updateURL");
            if (oldVersion == null || xpi2pURL == null) {
                this.updateStatus("<b>" + this._("Cannot check, plugin {0} is not installed", appName) + "</b>");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (_pluginUpdateCheckerRunner == null) {
                _pluginUpdateCheckerRunner = new PluginUpdateCheckerRunner();
            }
            if (_pluginUpdateCheckerRunner.isRunning()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this._xpi2pURL = xpi2pURL;
            this._appName = appName;
            this._oldVersion = oldVersion;
            this._isNewerAvailable = false;
            System.setProperty("net.i2p.router.web.UpdateHandler.updateInProgress", "true");
            I2PAppThread update = new I2PAppThread(_pluginUpdateCheckerRunner, "AppChecker", true);
            update.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setAppStatus(String status) {
        this.updateStatus(status);
    }

    public void setDoneStatus(String status) {
        this.updateStatus(status);
        this.scheduleStatusClean(status);
    }

    public boolean isRunning() {
        return _pluginUpdateCheckerRunner != null && _pluginUpdateCheckerRunner.isRunning();
    }

    public boolean isDone() {
        return false;
    }

    public boolean isNewerAvailable() {
        return this._isNewerAvailable;
    }

    private void scheduleStatusClean(String msg) {
        SimpleScheduler.getInstance().addEvent(new Cleaner(msg), 1200000L);
    }

    public class AllCheckerRunner
    implements Runnable {
        public void run() {
            List<String> plugins = PluginStarter.getPlugins();
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private final String _msg;

        public Cleaner(String msg) {
            this._msg = msg;
        }

        public void timeReached() {
            if (this._msg.equals(UpdateHandler.getStatus())) {
                PluginUpdateChecker.this.updateStatus("");
            }
        }
    }

    public class PluginUpdateCheckerRunner
    extends UpdateHandler.UpdateRunner
    implements Runnable,
    EepGet.StatusListener {
        ByteArrayOutputStream _baos;

        public PluginUpdateCheckerRunner() {
            super(PluginUpdateChecker.this);
            this._baos = new ByteArrayOutputStream(56);
        }

        protected void update() {
            PluginUpdateChecker.this._isNewerAvailable = false;
            PluginUpdateChecker.this.updateStatus("<b>" + PluginUpdateChecker.this._("Checking for update of plugin {0}", PluginUpdateChecker.this._appName) + "</b>");
            String proxyHost = PluginUpdateChecker.this._context.getProperty("router.updateProxyHost", "127.0.0.1");
            int proxyPort = ConfigUpdateHandler.proxyPort(PluginUpdateChecker.this._context);
            this._baos.reset();
            try {
                this._get = new PartialEepGet((I2PAppContext)PluginUpdateChecker.this._context, proxyHost, proxyPort, this._baos, PluginUpdateChecker.this._xpi2pURL, 56L);
                this._get.addStatusListener(this);
                this._get.fetch(55000L);
            }
            catch (Throwable t) {
                PluginUpdateChecker.this._log.error("Error checking update for plugin", t);
            }
        }

        public boolean isNewerAvailable() {
            return PluginUpdateChecker.this._isNewerAvailable;
        }

        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        }

        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
            String msg;
            boolean newer;
            String newVersion = TrustedUpdate.getVersionString(new ByteArrayInputStream(this._baos.toByteArray()));
            boolean bl = newer = new VersionComparator().compare(newVersion, PluginUpdateChecker.this._oldVersion) > 0;
            if (newer) {
                msg = "<b>" + PluginUpdateChecker.this._("New plugin version {0} is available", newVersion) + "</b>";
                PluginUpdateChecker.this._isNewerAvailable = true;
            } else {
                msg = "<b>" + PluginUpdateChecker.this._("No new version is available for plugin {0}", PluginUpdateChecker.this._appName) + "</b>";
            }
            PluginUpdateChecker.this.updateStatus(msg);
            PluginUpdateChecker.this.scheduleStatusClean(msg);
        }

        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
            File f = new File(PluginUpdateChecker.this._updateFile);
            f.delete();
            String msg = "<b>" + PluginUpdateChecker.this._("Update check failed for plugin {0}", PluginUpdateChecker.this._appName) + "</b>";
            PluginUpdateChecker.this.updateStatus(msg);
            PluginUpdateChecker.this.scheduleStatusClean(msg);
        }
    }
}

