/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.router.web.ConfigRestartBean;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryListener;
import net.i2p.stat.Rate;

public class GraphHelper
extends FormHandler {
    protected Writer _out;
    private int _periodCount;
    private boolean _showEvents;
    private int _width;
    private int _height;
    private int _refreshDelaySeconds;
    private boolean _persistent;
    private String _stat;
    private int _end;
    private static final String PROP_X = "routerconsole.graphX";
    private static final String PROP_Y = "routerconsole.graphY";
    private static final String PROP_REFRESH = "routerconsole.graphRefresh";
    private static final String PROP_PERIODS = "routerconsole.graphPeriods";
    private static final String PROP_EVENTS = "routerconsole.graphEvents";
    public static final int DEFAULT_X = 250;
    public static final int DEFAULT_Y = 100;
    private static final int DEFAULT_REFRESH = 60;
    private static final int DEFAULT_PERIODS = 60;
    static final int MAX_X = 2048;
    static final int MAX_Y = 1024;
    private static final int MIN_X = 200;
    private static final int MIN_Y = 60;
    private static final int MIN_C = 20;
    private static final int MAX_C = 131040;
    private static final int MIN_REFRESH = 15;
    private static final int[] times = new int[]{60, 120, 300, 600, 1800, 3600, -1};

    public void setContextId(String contextId) {
        super.setContextId(contextId);
        this._width = this._context.getProperty(PROP_X, 250);
        this._height = this._context.getProperty(PROP_Y, 100);
        this._periodCount = this._context.getProperty(PROP_PERIODS, 60);
        this._refreshDelaySeconds = this._context.getProperty(PROP_REFRESH, 60);
        this._showEvents = this._context.getBooleanProperty(PROP_EVENTS);
    }

    public String getRefreshMeta() {
        if (this._refreshDelaySeconds <= 8 || ConfigRestartBean.getRestartTimeRemaining() < (long)(1000 * (this._refreshDelaySeconds + 30))) {
            return "";
        }
        return "<meta http-equiv=\"refresh\" content=\"" + (this._refreshDelaySeconds - 3) + "\">";
    }

    public void storeWriter(Writer out) {
        this._out = out;
    }

    public void setPeriodCount(String str) {
        this.setC(str);
    }

    public void setE(String str) {
        try {
            this._end = Math.max(0, Integer.parseInt(str));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setC(String str) {
        try {
            this._periodCount = Math.max(20, Math.min(Integer.parseInt(str), 131040));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setShowEvents(String b) {
        this._showEvents = !"false".equals(b);
    }

    public void setHeight(String str) {
        this.setH(str);
    }

    public void setH(String str) {
        try {
            this._height = Math.max(60, Math.min(Integer.parseInt(str), 1024));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setWidth(String str) {
        this.setW(str);
    }

    public void setW(String str) {
        try {
            this._width = Math.max(200, Math.min(Integer.parseInt(str), 2048));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setRefreshDelay(String str) {
        try {
            int rds = Integer.parseInt(str);
            this._refreshDelaySeconds = rds > 0 ? Math.max(rds, 15) : -1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setPersistent(String foo) {
        this._persistent = true;
    }

    public void setStat(String stat) {
        this._stat = stat;
    }

    public String getImages() {
        if (StatSummarizer.isDisabled()) {
            return "";
        }
        try {
            List<SummaryListener> listeners = StatSummarizer.instance().getListeners();
            TreeSet<SummaryListener> ordered = new TreeSet<SummaryListener>(new AlphaComparator());
            ordered.addAll(listeners);
            boolean hasTx = false;
            boolean hasRx = false;
            for (SummaryListener lsnr : ordered) {
                String title = lsnr.getRate().getRateStat().getName();
                if (title.equals("bw.sendRate")) {
                    hasTx = true;
                    continue;
                }
                if (!title.equals("bw.recvRate")) continue;
                hasRx = true;
            }
            if (hasTx && hasRx && !this._showEvents) {
                this._out.write("<a href=\"viewstat?stat=bw.combined&amp;periodCount=" + 3 * this._periodCount + "&amp;width=" + 3 * this._width + "&amp;height=" + 3 * this._height + "\">");
                String title = this._("Combined bandwidth graph");
                this._out.write("<img class=\"statimage\" src=\"viewstat.jsp?stat=bw.combined&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + (this._height - 13) + "\" alt=\"" + title + "\" title=\"" + title + "\"></a>\n");
            }
            for (SummaryListener lsnr : ordered) {
                Rate r = lsnr.getRate();
                String title = this._("{0} for {1}", r.getRateStat().getName(), DataHelper.formatDuration2((long)this._periodCount * r.getPeriod()));
                this._out.write("<a href=\"graph?stat=" + r.getRateStat().getName() + '.' + r.getPeriod() + "&amp;c=" + 3 * this._periodCount + "&amp;w=" + 3 * this._width + "&amp;h=" + 3 * this._height + (this._showEvents ? "&amp;showEvents=1" : "") + "\">");
                this._out.write("<img class=\"statimage\" border=\"0\" src=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + this._periodCount + "&amp;width=" + this._width + "&amp;height=" + this._height + "\" alt=\"" + title + "\" title=\"" + title + "\"></a>\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    public String getSingleStat() {
        try {
            if (StatSummarizer.isDisabled()) {
                return "";
            }
            if (this._stat == null) {
                this._out.write("No stat");
                return "";
            }
            List<Rate> rates = StatSummarizer.instance().parseSpecs(this._stat);
            if (rates.size() != 1) {
                this._out.write("Graphs not enabled for " + this._stat);
                return "";
            }
            Rate r = rates.get(0);
            this._out.write("<h3>");
            this._out.write(this._("{0} for {1}", r.getRateStat().getName(), DataHelper.formatDuration2((long)this._periodCount * r.getPeriod())));
            if (this._end > 0) {
                this._out.write(' ' + this._("ending {0} ago", DataHelper.formatDuration2((long)this._end * r.getPeriod())));
            }
            this._out.write("</h3><p><img class=\"statimage\" border=\"0\" src=\"viewstat.jsp?stat=" + r.getRateStat().getName() + "&amp;showEvents=" + this._showEvents + "&amp;period=" + r.getPeriod() + "&amp;periodCount=" + this._periodCount + "&amp;end=" + this._end + "&amp;width=" + this._width + "&amp;height=" + this._height + "\"></p><p>\n");
            if (this._width < 2048 && this._height < 1024) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width * 3 / 2, this._height * 3 / 2));
                this._out.write(this._("Larger"));
                this._out.write("</a> - ");
            }
            if (this._width > 200 && this._height > 60) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width * 2 / 3, this._height * 2 / 3));
                this._out.write(this._("Smaller"));
                this._out.write("</a> - ");
            }
            if (this._height < 1024) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width, this._height * 3 / 2));
                this._out.write(this._("Taller"));
                this._out.write("</a> - ");
            }
            if (this._height > 60) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width, this._height * 2 / 3));
                this._out.write(this._("Shorter"));
                this._out.write("</a> - ");
            }
            if (this._width < 2048) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width * 3 / 2, this._height));
                this._out.write(this._("Wider"));
                this._out.write("</a> - ");
            }
            if (this._width > 200) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end, this._width * 2 / 3, this._height));
                this._out.write(this._("Narrower"));
                this._out.write("</a>");
            }
            this._out.write("<br>");
            if (this._periodCount < 131040) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount * 2, this._end, this._width, this._height));
                this._out.write(this._("Larger interval"));
                this._out.write("</a> - ");
            }
            if (this._periodCount > 20) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount / 2, this._end, this._width, this._height));
                this._out.write(this._("Smaller interval"));
                this._out.write("</a>");
            }
            this._out.write("<br>");
            if (this._periodCount < 131040) {
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, this._end + this._periodCount, this._width, this._height));
                this._out.write(this._("Previous interval"));
                this._out.write("</a>");
            }
            if (this._end > 0) {
                int end = this._end - this._periodCount;
                if (end <= 0) {
                    end = 0;
                }
                if (this._periodCount < 131040) {
                    this._out.write(" - ");
                }
                this._out.write(GraphHelper.link(this._stat, this._showEvents, this._periodCount, end, this._width, this._height));
                this._out.write(this._("Next interval"));
                this._out.write("</a> ");
            }
            this._out.write("<br>");
            this._out.write(GraphHelper.link(this._stat, !this._showEvents, this._periodCount, this._end, this._width, this._height));
            this._out.write(this._showEvents ? this._("Plot averages") : this._("plot events"));
            this._out.write("</a>");
            this._out.write("</p><p><i>" + this._("All times are UTC.") + "</i></p>\n");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private static String link(String stat, boolean showEvents, int periodCount, int end, int width, int height) {
        return "<a href=\"graph?stat=" + stat + "&amp;c=" + periodCount + "&amp;w=" + width + "&amp;h=" + height + (end > 0 ? "&amp;e=" + end : "") + (showEvents ? "&amp;showEvents=1" : "") + "\">";
    }

    public String getForm() {
        if (StatSummarizer.isDisabled()) {
            return "";
        }
        String prev = System.getProperty("net.i2p.router.web.GraphHelper.nonce");
        if (prev != null) {
            System.setProperty("net.i2p.router.web.GraphHelper.noncePrev", prev);
        }
        String nonce = "" + this._context.random().nextLong();
        System.setProperty("net.i2p.router.web.GraphHelper.nonce", nonce);
        try {
            this._out.write("<br><h3>" + this._("Configure Graph Display") + " [<a href=\"configstats\">" + this._("Select Stats") + "</a>]</h3>");
            this._out.write("<form action=\"graphs\" method=\"POST\">\n<input type=\"hidden\" name=\"action\" value=\"foo\">\n<input type=\"hidden\" name=\"nonce\" value=\"" + nonce + "\" >\n");
            this._out.write(this._("Periods") + ": <input size=\"5\" style=\"text-align: right;\" type=\"text\" name=\"periodCount\" value=\"" + this._periodCount + "\"><br>\n");
            this._out.write(this._("Plot averages") + ": <input type=\"radio\" class=\"optbox\" name=\"showEvents\" value=\"false\" " + (this._showEvents ? "" : "checked=\"checked\" ") + "> ");
            this._out.write(this._("or") + " " + this._("plot events") + ": <input type=\"radio\" class=\"optbox\" name=\"showEvents\" value=\"true\" " + (this._showEvents ? "checked=\"checked\" " : "") + "><br>\n");
            this._out.write(this._("Image sizes") + ": " + this._("width") + ": <input size=\"4\" style=\"text-align: right;\" type=\"text\" name=\"width\" value=\"" + this._width + "\"> " + this._("pixels") + ", " + this._("height") + ": <input size=\"4\" style=\"text-align: right;\" type=\"text\" name=\"height\" value=\"" + this._height + "\"> " + this._("pixels") + "<br>\n");
            this._out.write(this._("Refresh delay") + ": <select name=\"refreshDelay\">");
            for (int i = 0; i < times.length; ++i) {
                this._out.write("<option value=\"");
                this._out.write(Integer.toString(times[i]));
                this._out.write("\"");
                if (times[i] == this._refreshDelaySeconds) {
                    this._out.write(" selected=\"selected\"");
                }
                this._out.write(">");
                if (times[i] > 0) {
                    this._out.write(DataHelper.formatDuration2(times[i] * 1000));
                } else {
                    this._out.write(this._("Never"));
                }
                this._out.write("</option>\n");
            }
            this._out.write("</select><br>\n" + this._("Store graph data on disk?") + " <input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"persistent\"");
            boolean persistent = this._context.getBooleanPropertyDefaultTrue("routerconsole.graphPersistent");
            if (persistent) {
                this._out.write(" checked=\"checked\"");
            }
            this._out.write("><hr><div class=\"formaction\"><input type=\"submit\" class=\"acceot\" value=\"" + this._("Save settings and redraw graphs") + "\"></div></form>");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    public String getAllMessages() {
        if (StatSummarizer.isDisabled()) {
            this.addFormError("Graphing not supported with this JVM: " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + " (" + System.getProperty("java.runtime.name") + ' ' + System.getProperty("java.runtime.version") + ')');
            if (this._context.getProperty(PROP_REFRESH, 0) >= 0) {
                this._context.router().saveConfig(PROP_REFRESH, "-1");
            }
        }
        return super.getAllMessages();
    }

    protected void processForm() {
        this.saveSettings();
    }

    private void saveSettings() {
        if (this._width != this._context.getProperty(PROP_X, 250) || this._height != this._context.getProperty(PROP_Y, 100) || this._periodCount != this._context.getProperty(PROP_PERIODS, 60) || this._refreshDelaySeconds != this._context.getProperty(PROP_REFRESH, 60) || this._showEvents != this._context.getBooleanProperty(PROP_EVENTS) || this._persistent != this._context.getBooleanPropertyDefaultTrue("routerconsole.graphPersistent")) {
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_X, "" + this._width);
            changes.put(PROP_Y, "" + this._height);
            changes.put(PROP_PERIODS, "" + this._periodCount);
            changes.put(PROP_REFRESH, "" + this._refreshDelaySeconds);
            changes.put(PROP_EVENTS, "" + this._showEvents);
            changes.put("routerconsole.graphPersistent", "" + this._persistent);
            this._context.router().saveConfig(changes, null);
            this.addFormNotice(this._("Graph settings saved"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlphaComparator
    implements Comparator<SummaryListener> {
        private AlphaComparator() {
        }

        @Override
        public int compare(SummaryListener l, SummaryListener r) {
            String rName;
            String lName = l.getRate().getRateStat().getName();
            int rv = lName.compareTo(rName = r.getRate().getRateStat().getName());
            if (rv != 0) {
                return rv;
            }
            return (int)(l.getRate().getPeriod() - r.getRate().getPeriod());
        }
    }
}

