/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NewsFetcher;

public class ConfigUpdateHelper
extends HelperBase {
    private boolean _dontInstall;
    private static final long[] PERIODS = new long[]{43200000L, 86400000L, 129600000L, 172800000L, 259200000L, 604800000L, -1L};

    public void setContextId(String contextId) {
        super.setContextId(contextId);
        this._dontInstall = NewsFetcher.getInstance(this._context).dontInstall();
    }

    public boolean canInstall() {
        return !this._dontInstall;
    }

    public boolean updateAvailable() {
        return true;
    }

    public String getNewsURL() {
        return ConfigUpdateHelper.getNewsURL(this._context);
    }

    public static String getNewsURL(I2PAppContext ctx) {
        String url = ctx.getProperty("router.newsURL");
        if (url != null && !url.equals("http://complication.i2p/news.xml")) {
            return url;
        }
        return "http://echelon.i2p/i2p/news.xml";
    }

    public String getUpdateURL() {
        String url = this._context.getProperty("router.updateURL");
        if (url != null) {
            return url.replace(",", "\n");
        }
        return ConfigUpdateHandler.DEFAULT_UPDATE_URL;
    }

    public String getProxyHost() {
        if (this.isInternal()) {
            return this._("internal") + "\" readonly=\"readonly";
        }
        return this._context.getProperty("router.updateProxyHost", "127.0.0.1");
    }

    public String getProxyPort() {
        if (this.isInternal()) {
            return this._("internal") + "\" readonly=\"readonly";
        }
        return Integer.toString(ConfigUpdateHandler.proxyPort(this._context));
    }

    private boolean isInternal() {
        String host = this._context.getProperty("router.updateProxyHost");
        String port = this._context.getProperty("router.updateProxyPort");
        return !(host != null && !host.equals("127.0.0.1") || port != null && !port.equals("4444") || this._context.portMapper().getPort("HTTP") != 4444);
    }

    public String getUpdateThroughProxy() {
        String proxy = this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY);
        if (Boolean.valueOf(proxy).booleanValue()) {
            return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateThroughProxy\" checked=\"checked\" >";
        }
        return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateThroughProxy\" >";
    }

    public String getUpdateUnsigned() {
        String foo = this._context.getProperty("router.updateUnsigned");
        if (Boolean.valueOf(foo).booleanValue()) {
            return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateUnsigned\" checked=\"checked\" >";
        }
        return "<input type=\"checkbox\" class=\"optbox\" value=\"true\" name=\"updateUnsigned\" >";
    }

    public String getRefreshFrequencySelectBox() {
        String freq = this._context.getProperty("router.newsRefreshFrequency", ConfigUpdateHandler.DEFAULT_REFRESH_FREQUENCY);
        long ms = 129600000L;
        try {
            ms = Long.parseLong(freq);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select name=\"refreshFrequency\">");
        for (int i = 0; i < PERIODS.length; ++i) {
            buf.append("<option value=\"").append(PERIODS[i]);
            if (PERIODS[i] == ms) {
                buf.append("\" selected=\"selected");
            }
            if (PERIODS[i] == -1L) {
                buf.append("\">" + this._("Never") + "</option>\n");
                continue;
            }
            buf.append("\">" + this._("Every") + " ").append(DataHelper.formatDuration2(PERIODS[i])).append("</option>\n");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getUpdatePolicySelectBox() {
        String policy = this._context.getProperty("router.updatePolicy", "download");
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select name=\"updatePolicy\">");
        buf.append("<option value=\"notify\"");
        if ("notify".equals(policy) || this._dontInstall) {
            buf.append(" selected=\"selected\"");
        }
        buf.append('>').append(this._("Notify only")).append("</option>");
        buf.append("<option value=\"download\"");
        if (this._dontInstall) {
            buf.append(" disabled=\"disabled\"");
        } else if ("download".equals(policy)) {
            buf.append(" selected=\"selected\"");
        }
        buf.append('>').append(this._("Download and verify only")).append("</option>");
        if (this._context.hasWrapper()) {
            buf.append("<option value=\"install\"");
            if (this._dontInstall) {
                buf.append(" disabled=\"disabled\"");
            } else if ("install".equals(policy)) {
                buf.append(" selected=\"selected\"");
            }
            buf.append('>').append(this._("Download, verify, and restart")).append("</option>");
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public String getTrustedKeys() {
        return new TrustedUpdate(this._context).getTrustedKeysString();
    }

    public String getZipURL() {
        return this._context.getProperty("router.updateUnsignedURL", "");
    }

    public String getNewsStatus() {
        return NewsFetcher.getInstance(this._context).status();
    }
}

