/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.http;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Locale;
import org.cybergarage.util.Debug;

public class HTTPHeader {
    private String name;
    private String value;

    public HTTPHeader(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public HTTPHeader(String lineStr) {
        this.setName("");
        this.setValue("");
        if (lineStr == null) {
            return;
        }
        int colonIdx = lineStr.indexOf(58);
        if (colonIdx < 0) {
            return;
        }
        String _name = new String(lineStr.getBytes(), 0, colonIdx);
        String _value = new String(lineStr.getBytes(), colonIdx + 1, lineStr.length() - colonIdx - 1);
        this.setName(_name.trim());
        this.setValue(_value.trim());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasName() {
        return this.name != null && this.name.length() > 0;
    }

    public static final String getValue(LineNumberReader reader, String name) {
        String bigName = name.toUpperCase(Locale.US);
        try {
            String lineStr = reader.readLine();
            while (lineStr != null && 0 < lineStr.length()) {
                HTTPHeader header = new HTTPHeader(lineStr);
                if (!header.hasName()) {
                    lineStr = reader.readLine();
                    continue;
                }
                String bigLineHeaderName = header.getName().toUpperCase(Locale.US);
                if (!bigLineHeaderName.equals(bigName)) {
                    lineStr = reader.readLine();
                    continue;
                }
                return header.getValue();
            }
        }
        catch (IOException e) {
            Debug.warning(e);
            return "";
        }
        return "";
    }

    public static final String getValue(String data, String name) {
        StringReader strReader = new StringReader(data);
        LineNumberReader lineReader = new LineNumberReader(strReader);
        return HTTPHeader.getValue(lineReader, name);
    }

    public static final String getValue(byte[] data, String name) {
        return HTTPHeader.getValue(new String(data), name);
    }

    public static final int getIntegerValue(String data, String name) {
        try {
            return Integer.parseInt(HTTPHeader.getValue(data, name));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static final int getIntegerValue(byte[] data, String name) {
        try {
            return Integer.parseInt(HTTPHeader.getValue(data, name));
        }
        catch (Exception e) {
            return 0;
        }
    }
}

