/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.http;

import java.util.Calendar;
import java.util.TimeZone;

public class Date {
    private Calendar cal;
    private static final String[] MONTH_STRING = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] WEEK_STRING = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    public Date(Calendar cal) {
        this.cal = cal;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public int getHour() {
        return this.getCalendar().get(11);
    }

    public int getMinute() {
        return this.getCalendar().get(12);
    }

    public int getSecond() {
        return this.getCalendar().get(13);
    }

    public static final Date getLocalInstance() {
        return new Date(Calendar.getInstance());
    }

    public static final Date getInstance() {
        return new Date(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
    }

    public static final String toDateString(int value) {
        if (value < 10) {
            return "0" + Integer.toString(value);
        }
        return Integer.toString(value);
    }

    public static final String toMonthString(int value) {
        if (0 <= (value += 0) && value < 12) {
            return MONTH_STRING[value];
        }
        return "";
    }

    public static final String toWeekString(int value) {
        if (0 <= --value && value < 7) {
            return WEEK_STRING[value];
        }
        return "";
    }

    public static final String toTimeString(int value) {
        String str = "";
        if (value < 10) {
            str = str + "0";
        }
        str = str + Integer.toString(value);
        return str;
    }

    public String getDateString() {
        Calendar _cal = this.getCalendar();
        return Date.toWeekString(_cal.get(7)) + ", " + Date.toTimeString(_cal.get(5)) + " " + Date.toMonthString(_cal.get(2)) + " " + Integer.toString(_cal.get(1)) + " " + Date.toTimeString(_cal.get(11)) + ":" + Date.toTimeString(_cal.get(12)) + ":" + Date.toTimeString(_cal.get(13)) + " GMT";
    }

    public String getTimeString() {
        Calendar _cal = this.getCalendar();
        return Date.toDateString(_cal.get(11)) + (_cal.get(13) % 2 == 0 ? ":" : " ") + Date.toDateString(_cal.get(12));
    }
}

