/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import net.i2p.util.RandomSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomIterator<E>
implements Iterator<E> {
    private final BitSet served;
    private int servedCount = 0;
    private final List<E> list;
    private final int LIST_SIZE;
    private final Random rand = RandomSource.getInstance();
    private int lower;
    private int upper;

    public RandomIterator(List<E> list) {
        this.list = list;
        this.LIST_SIZE = list.size();
        this.served = new BitSet(this.LIST_SIZE);
        this.upper = this.LIST_SIZE - 1;
    }

    @Override
    public boolean hasNext() {
        return this.servedCount < this.LIST_SIZE;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int range = this.upper - this.lower + 1;
        int start = this.lower + this.rand.nextInt(range);
        int index = start % 2 == 0 ? this.served.nextClearBit(start) : this.previousClearBit(start);
        if (index < 0) {
            throw new NoSuchElementException("shouldn't happen");
        }
        ++this.servedCount;
        this.served.set(index);
        if (this.hasNext()) {
            if (index == this.lower) {
                this.lower = this.served.nextClearBit(this.lower);
            } else if (index == this.upper) {
                this.upper = this.previousClearBit(this.upper - 1);
            }
        }
        return this.list.get(index);
    }

    private int previousClearBit(int n) {
        for (int i = n; i >= this.lower; --i) {
            if (this.served.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

