/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class RFC822Date {
    private static final SimpleDateFormat[] rfc822DateFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("d MMM yyyy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yyyy HH:mm:ss z", Locale.US)};

    public static long parse822Date(String s) {
        for (int i = 0; i < rfc822DateFormats.length; ++i) {
            try {
                Date date = rfc822DateFormats[i].parse(s);
                if (date == null) continue;
                return date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static String to822Date(long t) {
        return new SimpleDateFormat("d MMM yyyy HH:mm:ss z", Locale.US).format(new Date(t));
    }
}

