/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

class ParticipatingThrottler {
    private final RouterContext context;
    private final ObjectCounter<Hash> counter;
    private static final int LIFETIME_PORTION = 3;
    private static final int MIN_LIMIT = 6;
    private static final int MAX_LIMIT = 22;
    private static final int PERCENT_LIMIT = 4;
    private static final long CLEAN_TIME = 220000L;

    ParticipatingThrottler(RouterContext ctx) {
        this.context = ctx;
        this.counter = new ObjectCounter();
        SimpleScheduler.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Cleaner(), 220000L);
    }

    boolean shouldThrottle(Hash h) {
        int numTunnels = this.context.tunnelManager().getParticipatingCount();
        int limit = Math.max(6, Math.min(22, numTunnels * 4 / 100));
        return this.counter.increment((Object)h) > limit;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            ParticipatingThrottler.this.counter.clear();
        }
    }
}

