/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class FragmentedMessage {
    private final I2PAppContext _context;
    private final Log _log;
    private long _messageId;
    private Hash _toRouter;
    private TunnelId _toTunnel;
    private final ByteArray[] _fragments;
    private boolean _lastReceived;
    private int _highFragmentNum;
    private final long _createdOn;
    private boolean _completed;
    private long _releasedAfter;
    private SimpleTimer.TimedEvent _expireEvent;
    private static final ByteCache _cache = ByteCache.getInstance((int)512, (int)1024);
    private static final int MAX_FRAGMENTS = 64;

    public FragmentedMessage(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(FragmentedMessage.class);
        this._messageId = -1L;
        this._fragments = new ByteArray[64];
        this._highFragmentNum = -1;
        this._releasedAfter = -1L;
        this._createdOn = ctx.clock().now();
    }

    public boolean receive(long messageId, int fragmentNum, byte[] payload, int offset, int length, boolean isLast) {
        if (fragmentNum < 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("Fragment # == " + fragmentNum + " for messageId " + messageId);
            }
            return false;
        }
        if (payload == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Payload is null for messageId " + messageId);
            }
            return false;
        }
        if (length <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Length is impossible (" + length + ") for messageId " + messageId);
            }
            return false;
        }
        if (offset + length > payload.length) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Length is impossible (" + length + "/" + offset + " out of " + payload.length + ") for messageId " + messageId);
            }
            return false;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive message " + messageId + " fragment " + fragmentNum + " with " + length + " bytes (last? " + isLast + ") offset = " + offset);
        }
        this._messageId = messageId;
        ByteArray ba = _cache.acquire();
        System.arraycopy(payload, offset, ba.getData(), 0, length);
        ba.setValid(length);
        ba.setOffset(0);
        this._fragments[fragmentNum] = ba;
        boolean bl = this._lastReceived = this._lastReceived || isLast;
        if (fragmentNum > this._highFragmentNum) {
            this._highFragmentNum = fragmentNum;
        }
        if (isLast && fragmentNum <= 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("hmm, isLast and fragmentNum=" + fragmentNum + " for message " + messageId);
            }
            return false;
        }
        return true;
    }

    public boolean receive(long messageId, byte[] payload, int offset, int length, boolean isLast, Hash toRouter, TunnelId toTunnel) {
        if (payload == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Payload is null for messageId " + messageId);
            }
            return false;
        }
        if (length <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Length is impossible (" + length + ") for messageId " + messageId);
            }
            return false;
        }
        if (offset + length > payload.length) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Length is impossible (" + length + "/" + offset + " out of " + payload.length + ") for messageId " + messageId);
            }
            return false;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive message " + messageId + " with " + length + " bytes (last? " + isLast + ") targetting " + toRouter + " / " + toTunnel + " offset=" + offset);
        }
        this._messageId = messageId;
        ByteArray ba = _cache.acquire();
        System.arraycopy(payload, offset, ba.getData(), 0, length);
        ba.setValid(length);
        ba.setOffset(0);
        this._fragments[0] = ba;
        this._lastReceived = this._lastReceived || isLast;
        this._toRouter = toRouter;
        this._toTunnel = toTunnel;
        if (this._highFragmentNum < 0) {
            this._highFragmentNum = 0;
        }
        return true;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public Hash getTargetRouter() {
        return this._toRouter;
    }

    public TunnelId getTargetTunnel() {
        return this._toTunnel;
    }

    public int getFragmentCount() {
        int found = 0;
        for (int i = 0; i < this._fragments.length; ++i) {
            if (this._fragments[i] == null) continue;
            ++found;
        }
        return found;
    }

    SimpleTimer.TimedEvent getExpireEvent() {
        return this._expireEvent;
    }

    void setExpireEvent(SimpleTimer.TimedEvent evt) {
        this._expireEvent = evt;
    }

    public boolean isComplete() {
        if (!this._lastReceived) {
            return false;
        }
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            if (this._fragments[i] != null) continue;
            return false;
        }
        return true;
    }

    public int getCompleteSize() {
        if (!this._lastReceived) {
            throw new IllegalStateException("wtf, don't get the completed size when we're not complete");
        }
        if (this._releasedAfter > 0L) {
            RuntimeException e = new RuntimeException("use after free in FragmentedMessage");
            this._log.error("FM completeSize()", (Throwable)e);
            throw e;
        }
        int size = 0;
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            if (ba == null) {
                throw new IllegalStateException("wtf, don't get the completed size when we're not complete - null fragment i=" + i + " of " + this._highFragmentNum);
            }
            size += ba.getValid();
        }
        return size;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._createdOn;
    }

    public boolean getReleased() {
        return this._completed;
    }

    private void writeComplete(byte[] target, int offset) {
        if (this._releasedAfter > 0L) {
            RuntimeException e = new RuntimeException("use after free in FragmentedMessage");
            this._log.error("FM writeComplete() 2", (Throwable)e);
            throw e;
        }
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            System.arraycopy(ba.getData(), ba.getOffset(), target, offset, ba.getValid());
            offset += ba.getValid();
        }
        this._completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        FragmentedMessage fragmentedMessage = this;
        synchronized (fragmentedMessage) {
            if (this._releasedAfter > 0L) {
                return null;
            }
            byte[] rv = new byte[this.getCompleteSize()];
            this.writeComplete(rv, 0);
            this.releaseFragments();
            return rv;
        }
    }

    public long getReleasedAfter() {
        return this._releasedAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed() {
        FragmentedMessage fragmentedMessage = this;
        synchronized (fragmentedMessage) {
            this.releaseFragments();
        }
    }

    private void releaseFragments() {
        if (this._releasedAfter > 0L) {
            RuntimeException e = new RuntimeException("double free in FragmentedMessage");
            this._log.error("FM releaseFragments()", (Throwable)e);
            throw e;
        }
        this._releasedAfter = this.getLifetime();
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            if (ba == null || ba.getData().length != 1024) continue;
            _cache.release(ba);
            this._fragments[i] = null;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("Fragments for ").append(this._messageId).append(": ");
        for (int i = 0; i <= this._highFragmentNum; ++i) {
            ByteArray ba = this._fragments[i];
            if (ba != null) {
                buf.append(i).append(":").append(ba.getValid()).append(" bytes ");
                continue;
            }
            buf.append(i).append(":missing ");
        }
        buf.append(" highest received: ").append(this._highFragmentNum);
        buf.append(" last received? ").append(this._lastReceived);
        buf.append(" lifetime: ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this._createdOn)));
        if (this._toRouter != null) {
            buf.append(" targetting ").append(this._toRouter.toBase64().substring(0, 4));
            if (this._toTunnel != null) {
                buf.append(":").append(this._toTunnel.getTunnelId());
            }
        }
        if (this._completed) {
            buf.append(" completed");
        }
        if (this._releasedAfter > 0L) {
            buf.append(" released after " + DataHelper.formatDuration((long)this._releasedAfter));
        }
        return buf.toString();
    }
}

