/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class UDPSender {
    private final RouterContext _context;
    private final Log _log;
    private DatagramSocket _socket;
    private String _name;
    private final BlockingQueue<UDPPacket> _outboundQueue;
    private boolean _keepRunning;
    private final Runner _runner;
    private static final int TYPE_POISON = 99999;
    private static final int MAX_HEAD_LIFETIME = 1000;

    public UDPSender(RouterContext ctx, DatagramSocket socket, String name) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPSender.class);
        this._outboundQueue = new LinkedBlockingQueue<UDPPacket>();
        this._socket = socket;
        this._runner = new Runner();
        this._name = name;
        this._context.statManager().createRateStat("udp.pushTime", "How long a UDP packet takes to get pushed out", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendQueueSize", "How many packets are queued on the UDP sender", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendQueueFailed", "How often it was unable to add a new packet to the queue", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendQueueTrimmed", "How many packets were removed from the queue for being too old (duration == remaining)", "udp", UDPTransport.RATES);
        this._context.statManager().createRequiredRateStat("udp.sendPacketSize", "Size of sent packets (bytes)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.socketSendTime", "How long the actual socket.send took", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendBWThrottleTime", "How long the send is blocked by the bandwidth throttle", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendACKTime", "How long an ACK packet is blocked for (duration == lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRequiredRateStat("udp.sendException", "Send fails (Windows exception?)", "udp", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("udp.sendPacketSize.42", "ack-only packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.43", "hole punch packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.44", "relay response packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.45", "relay intro packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.46", "relay request packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.47", "peer test charlie to bob packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.48", "peer test bob to charlie packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.49", "peer test to alice packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.50", "peer test from alice packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.51", "session confirmed packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.52", "session request packet size", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize.53", "session created packet size", "udp", UDPTransport.RATES);
    }

    public void startup() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Starting the runner: " + this._name);
        }
        this._keepRunning = true;
        I2PThread t = new I2PThread((Runnable)this._runner, this._name, true);
        t.start();
    }

    public void shutdown() {
        this._keepRunning = false;
        this._outboundQueue.clear();
        UDPPacket poison = UDPPacket.acquire(this._context, false);
        poison.setMessageType(99999);
        this._outboundQueue.offer(poison);
        for (int i = 1; i <= 5 && !this._outboundQueue.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._outboundQueue.clear();
    }

    public DatagramSocket updateListeningPort(DatagramSocket socket, int newPort) {
        return this._runner.updateListeningPort(socket, newPort);
    }

    public int add(UDPPacket packet, int blockTime) {
        return this.add(packet);
    }

    public int add(UDPPacket packet) {
        if (packet == null || !this._keepRunning) {
            return 0;
        }
        int size = 0;
        int psz = packet.getPacket().getLength();
        if (psz > 1484) {
            this._log.error("Sending large UDP packet " + psz + " bytes: " + packet);
        }
        this._outboundQueue.offer(packet);
        if (this._log.shouldLog(10)) {
            size = this._outboundQueue.size();
            this._log.debug("Added the packet onto the queue with " + size + " remaining and a lifetime of " + packet.getLifetime());
        }
        return size;
    }

    private class Runner
    implements Runnable {
        private boolean _socketChanged;
        FIFOBandwidthLimiter.Request req;

        private Runner() {
            this.req = UDPSender.this._context.bandwidthLimiter().createRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (UDPSender.this._log.shouldLog(10)) {
                UDPSender.this._log.debug("Running the UDP sender");
            }
            this._socketChanged = false;
            while (UDPSender.this._keepRunning) {
                UDPPacket packet;
                if (this._socketChanged) {
                    Thread.currentThread().setName(UDPSender.this._name);
                    this._socketChanged = false;
                }
                if ((packet = this.getNextPacket()) == null) continue;
                if (UDPSender.this._log.shouldLog(10)) {
                    UDPSender.this._log.debug("Packet to send known: " + packet);
                }
                long acquireTime = UDPSender.this._context.clock().now();
                int size = packet.getPacket().getLength();
                if (size > 0) {
                    this.req = UDPSender.this._context.bandwidthLimiter().requestOutbound(size, "UDP sender");
                    while (this.req.getPendingOutboundRequested() > 0) {
                        this.req.waitForNextAllocation();
                    }
                }
                long afterBW = UDPSender.this._context.clock().now();
                if (UDPSender.this._log.shouldLog(10)) {
                    // empty if block
                }
                if (packet.getMessageType() >= 42) {
                    UDPSender.this._context.statManager().addRateData("udp.sendPacketSize." + packet.getMessageType(), (long)size, (long)packet.getFragmentCount());
                }
                try {
                    long throttleTime;
                    long before = UDPSender.this._context.clock().now();
                    Runner runner = this;
                    synchronized (runner) {
                        DatagramPacket dp = packet.getPacket();
                        if (UDPSender.this._log.shouldLog(10)) {
                            UDPSender.this._log.debug("Just before socket.send of " + packet);
                        }
                        UDPSender.this._socket.send(dp);
                        if (UDPSender.this._log.shouldLog(10)) {
                            UDPSender.this._log.debug("Just after socket.send of " + packet);
                        }
                    }
                    long sendTime = UDPSender.this._context.clock().now() - before;
                    UDPSender.this._context.statManager().addRateData("udp.socketSendTime", sendTime, packet.getLifetime());
                    if (UDPSender.this._log.shouldLog(20)) {
                        UDPSender.this._log.info("Sent the packet " + packet);
                    }
                    if ((throttleTime = afterBW - acquireTime) > 10L) {
                        UDPSender.this._context.statManager().addRateData("udp.sendBWThrottleTime", throttleTime, acquireTime - packet.getBegin());
                    }
                    if (packet.getMarkedType() == 1) {
                        UDPSender.this._context.statManager().addRateData("udp.sendACKTime", throttleTime, packet.getLifetime());
                    }
                    UDPSender.this._context.statManager().addRateData("udp.pushTime", packet.getLifetime(), packet.getLifetime());
                    UDPSender.this._context.statManager().addRateData("udp.sendPacketSize", (long)size, packet.getLifetime());
                }
                catch (IOException ioe) {
                    if (UDPSender.this._log.shouldLog(30)) {
                        UDPSender.this._log.warn("Error sending", (Throwable)ioe);
                    }
                    UDPSender.this._context.statManager().addRateData("udp.sendException", 1L, packet.getLifetime());
                }
                packet.release();
            }
            if (UDPSender.this._log.shouldLog(10)) {
                UDPSender.this._log.debug("Stop sending...");
            }
        }

        private UDPPacket getNextPacket() {
            UDPPacket packet = null;
            while (UDPSender.this._keepRunning && (packet == null || packet.getLifetime() > 1000L)) {
                if (packet != null) {
                    UDPSender.this._context.statManager().addRateData("udp.sendQueueTrimmed", 1L, 0L);
                }
                try {
                    packet = (UDPPacket)UDPSender.this._outboundQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (packet == null || packet.getMessageType() != 99999) continue;
                return null;
            }
            return packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DatagramSocket updateListeningPort(DatagramSocket socket, int newPort) {
            UDPSender.this._name = "UDPSend on " + newPort;
            DatagramSocket old = null;
            Runner runner = this;
            synchronized (runner) {
                old = UDPSender.this._socket;
                UDPSender.this._socket = socket;
            }
            this._socketChanged = true;
            return old;
        }
    }
}

