/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class UDPReceiver {
    private final RouterContext _context;
    private final Log _log;
    private DatagramSocket _socket;
    private String _name;
    private final BlockingQueue<UDPPacket> _inboundQueue;
    private boolean _keepRunning;
    private final Runner _runner;
    private final UDPTransport _transport;
    private static int __id;
    private final int _id;
    private static final int TYPE_POISON = -99999;
    private static final long MAX_QUEUE_PERIOD = 2000L;

    public UDPReceiver(RouterContext ctx, UDPTransport transport, DatagramSocket socket, String name) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPReceiver.class);
        this._id = ++__id;
        this._name = name;
        this._inboundQueue = new LinkedBlockingQueue<UDPPacket>();
        this._socket = socket;
        this._transport = transport;
        this._runner = new Runner();
        this._context.statManager().createRateStat("udp.receivePacketSize", "How large packets received are", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveRemaining", "How many packets are left sitting on the receiver's queue", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInbound", "How many packet are queued up but not yet received when we drop", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveHolePunch", "How often we receive a NAT hole punch", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.ignorePacketFromDroplist", "Packet lifetime for those dropped on the drop list", "udp", UDPTransport.RATES);
    }

    public void startup() {
        this._keepRunning = true;
        I2PThread t = new I2PThread((Runnable)this._runner, this._name + '.' + this._id, true);
        t.start();
    }

    public void shutdown() {
        int i;
        this._keepRunning = false;
        this._inboundQueue.clear();
        for (i = 0; i < this._transport.getPacketHandlerCount(); ++i) {
            UDPPacket poison = UDPPacket.acquire(this._context, false);
            poison.setMessageType(-99999);
            this._inboundQueue.offer(poison);
        }
        for (i = 1; i <= 5 && !this._inboundQueue.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._inboundQueue.clear();
    }

    public DatagramSocket updateListeningPort(DatagramSocket socket, int newPort) {
        return this._runner.updateListeningPort(socket, newPort);
    }

    private int receive(UDPPacket packet) {
        return this.doReceive(packet);
    }

    private final int doReceive(UDPPacket packet) {
        RemoteHostId from;
        if (!this._keepRunning) {
            return 0;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Received: " + packet);
        }
        if (this._transport.isInDropList(from = packet.getRemoteHost())) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring packet from the drop-listed peer: " + from);
            }
            this._context.statManager().addRateData("udp.ignorePacketFromDroplist", packet.getLifetime(), 0L);
            packet.release();
            return 0;
        }
        packet.enqueue();
        boolean rejected = false;
        int queueSize = 0;
        long headPeriod = 0L;
        UDPPacket head = (UDPPacket)this._inboundQueue.peek();
        if (head != null && (headPeriod = head.getLifetime()) > 2000L) {
            rejected = true;
        }
        if (!rejected) {
            this._inboundQueue.offer(packet);
            return 0;
        }
        packet.release();
        this._context.statManager().addRateData("udp.droppedInbound", (long)queueSize, headPeriod);
        if (this._log.shouldLog(30)) {
            queueSize = this._inboundQueue.size();
            StringBuilder msg = new StringBuilder();
            msg.append("Dropping inbound packet with ");
            msg.append(queueSize);
            msg.append(" queued for ");
            msg.append(headPeriod);
            msg.append(" packet handlers: ").append(this._transport.getPacketHandlerStatus());
            this._log.warn(msg.toString());
        }
        return queueSize;
    }

    public UDPPacket receiveNext() {
        UDPPacket rv = null;
        while (this._keepRunning && rv == null) {
            try {
                rv = this._inboundQueue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (rv == null || rv.getMessageType() != -99999) continue;
            return null;
        }
        return rv;
    }

    private class Runner
    implements Runnable {
        private boolean _socketChanged;

        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._socketChanged = false;
            FIFOBandwidthLimiter.Request req = UDPReceiver.this._context.bandwidthLimiter().createRequest();
            while (UDPReceiver.this._keepRunning) {
                if (this._socketChanged) {
                    Thread.currentThread().setName(UDPReceiver.this._name + "." + UDPReceiver.this._id);
                    this._socketChanged = false;
                }
                UDPPacket packet = UDPPacket.acquire(UDPReceiver.this._context, true);
                if (UDPReceiver.this._log.shouldLog(10)) {
                    UDPReceiver.this._log.debug("Before throttling receive");
                }
                while (!UDPReceiver.this._context.throttle().acceptNetworkMessage()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {}
                }
                try {
                    if (UDPReceiver.this._log.shouldLog(20)) {
                        UDPReceiver.this._log.info("Before blocking socket.receive on " + System.identityHashCode(packet));
                    }
                    Runner ie = this;
                    synchronized (ie) {
                        UDPReceiver.this._socket.receive(packet.getPacket());
                    }
                    int size = packet.getPacket().getLength();
                    if (UDPReceiver.this._log.shouldLog(20)) {
                        UDPReceiver.this._log.info("After blocking socket.receive: packet is " + size + " bytes on " + System.identityHashCode(packet));
                    }
                    packet.resetBegin();
                    if (size >= 1572) {
                        throw new IOException("packet too large! truncated and dropped from: " + packet.getRemoteHost());
                    }
                    if (size > 0) {
                        req = UDPReceiver.this._context.bandwidthLimiter().requestInbound(size, "UDP receiver");
                        while (req.getPendingInboundRequested() > 0) {
                            req.waitForNextAllocation();
                        }
                        int queued = UDPReceiver.this.receive(packet);
                        UDPReceiver.this._context.statManager().addRateData("udp.receivePacketSize", (long)size, (long)queued);
                        continue;
                    }
                    UDPReceiver.this._context.statManager().addRateData("udp.receiveHolePunch", 1L, 0L);
                    if (!UDPReceiver.this._log.shouldLog(20)) continue;
                    UDPReceiver.this._log.info("Received a 0 byte udp packet from " + packet.getPacket().getAddress() + ":" + packet.getPacket().getPort());
                }
                catch (IOException ioe) {
                    if (this._socketChanged) {
                        if (UDPReceiver.this._log.shouldLog(20)) {
                            UDPReceiver.this._log.info("Changing ports...");
                        }
                    } else if (UDPReceiver.this._log.shouldLog(30)) {
                        UDPReceiver.this._log.warn("Error receiving", (Throwable)ioe);
                    }
                    packet.release();
                }
            }
            if (UDPReceiver.this._log.shouldLog(10)) {
                UDPReceiver.this._log.debug("Stop receiving...");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DatagramSocket updateListeningPort(DatagramSocket socket, int newPort) {
            UDPReceiver.this._name = "UDPReceive on " + newPort;
            DatagramSocket old = null;
            Runner runner = this;
            synchronized (runner) {
                old = UDPReceiver.this._socket;
                UDPReceiver.this._socket = socket;
            }
            this._socketChanged = true;
            old.close();
            return old;
        }
    }
}

