/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPReceiver;
import net.i2p.router.transport.udp.UDPSender;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;

class UDPEndpoint {
    private RouterContext _context;
    private Log _log;
    private int _listenPort;
    private UDPTransport _transport;
    private UDPSender _sender;
    private UDPReceiver _receiver;
    private DatagramSocket _socket;
    private InetAddress _bindAddress;
    public static final String PROP_MIN_PORT = "i2np.udp.minPort";
    public static final String PROP_MAX_PORT = "i2np.udp.maxPort";
    private static final int MIN_RANDOM_PORT = 9111;
    private static final int MAX_RANDOM_PORT = 30777;
    private static final int MAX_PORT_RETRIES = 20;

    public UDPEndpoint(RouterContext ctx, UDPTransport transport, int listenPort, InetAddress bindAddress) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPEndpoint.class);
        this._transport = transport;
        this._bindAddress = bindAddress;
        this._listenPort = listenPort;
    }

    public void startup() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Starting up the UDP endpoint");
        }
        this.shutdown();
        this._socket = this.getSocket();
        if (this._socket == null) {
            this._log.log(50, "UDP Unable to open a port");
            return;
        }
        this._sender = new UDPSender(this._context, this._socket, "UDPSender");
        this._receiver = new UDPReceiver(this._context, this._transport, this._socket, "UDPReceiver");
        this._sender.startup();
        this._receiver.startup();
    }

    public void shutdown() {
        if (this._sender != null) {
            this._sender.shutdown();
            this._receiver.shutdown();
        }
        if (this._socket != null) {
            this._socket.close();
        }
    }

    public void setListenPort(int newPort) {
        this._listenPort = newPort;
    }

    private DatagramSocket getSocket() {
        DatagramSocket socket = null;
        int port = this._listenPort;
        for (int i = 0; i < 20; ++i) {
            if (port <= 0) {
                int minPort = this._context.getProperty(PROP_MIN_PORT, 9111);
                int maxPort = this._context.getProperty(PROP_MAX_PORT, 30777);
                port = minPort + this._context.random().nextInt(maxPort - minPort);
            }
            try {
                if (this._bindAddress == null) {
                    socket = new DatagramSocket(port);
                    break;
                }
                socket = new DatagramSocket(port, this._bindAddress);
                break;
            }
            catch (SocketException se) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Binding to port " + port + " failed: " + se);
                }
                port = -1;
                continue;
            }
        }
        if (socket == null) {
            this._log.log(50, "SSU Unable to bind to a port on " + this._bindAddress);
        } else if (port != this._listenPort) {
            if (this._listenPort > 0) {
                this._log.error("SSU Unable to bind to requested port " + this._listenPort + ", using random port " + port);
            } else {
                this._log.logAlways(20, "UDP selected random port " + port);
            }
        }
        this._listenPort = port;
        return socket;
    }

    public int getListenPort() {
        return this._listenPort;
    }

    public UDPSender getSender() {
        return this._sender;
    }

    public int send(UDPPacket packet) {
        if (this._sender == null) {
            return 0;
        }
        return this._sender.add(packet);
    }

    public UDPPacket receive() {
        if (this._receiver == null) {
            return null;
        }
        return this._receiver.receiveNext();
    }
}

