/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import net.i2p.data.SessionKey;

class PeerTestState {
    private long _testNonce;
    private short _ourRole;
    private InetAddress _aliceIP;
    private int _alicePort;
    private InetAddress _bobIP;
    private int _bobPort;
    private InetAddress _charlieIP;
    private int _charliePort;
    private InetAddress _aliceIPFromCharlie;
    private int _alicePortFromCharlie;
    private SessionKey _aliceIntroKey;
    private SessionKey _charlieIntroKey;
    private SessionKey _bobCipherKey;
    private SessionKey _bobMACKey;
    private long _beginTime;
    private long _lastSendTime;
    private long _receiveAliceTime;
    private long _receiveBobTime;
    private long _receiveCharlieTime;
    private int _packetsRelayed;
    public static final short ALICE = 1;
    public static final short BOB = 2;
    public static final short CHARLIE = 3;

    PeerTestState() {
    }

    public long getNonce() {
        return this._testNonce;
    }

    public void setNonce(long nonce) {
        this._testNonce = nonce;
    }

    public short getOurRole() {
        return this._ourRole;
    }

    public void setOurRole(short role) {
        this._ourRole = role;
    }

    public InetAddress getAliceIP() {
        return this._aliceIP;
    }

    public void setAliceIP(InetAddress ip) {
        this._aliceIP = ip;
    }

    public InetAddress getBobIP() {
        return this._bobIP;
    }

    public void setBobIP(InetAddress ip) {
        this._bobIP = ip;
    }

    public InetAddress getCharlieIP() {
        return this._charlieIP;
    }

    public void setCharlieIP(InetAddress ip) {
        this._charlieIP = ip;
    }

    public InetAddress getAliceIPFromCharlie() {
        return this._aliceIPFromCharlie;
    }

    public void setAliceIPFromCharlie(InetAddress ip) {
        this._aliceIPFromCharlie = ip;
    }

    public int getAlicePort() {
        return this._alicePort;
    }

    public void setAlicePort(int alicePort) {
        this._alicePort = alicePort;
    }

    public int getBobPort() {
        return this._bobPort;
    }

    public void setBobPort(int bobPort) {
        this._bobPort = bobPort;
    }

    public int getCharliePort() {
        return this._charliePort;
    }

    public void setCharliePort(int charliePort) {
        this._charliePort = charliePort;
    }

    public int getAlicePortFromCharlie() {
        return this._alicePortFromCharlie;
    }

    public void setAlicePortFromCharlie(int alicePortFromCharlie) {
        this._alicePortFromCharlie = alicePortFromCharlie;
    }

    public SessionKey getAliceIntroKey() {
        return this._aliceIntroKey;
    }

    public void setAliceIntroKey(SessionKey key) {
        this._aliceIntroKey = key;
    }

    public SessionKey getCharlieIntroKey() {
        return this._charlieIntroKey;
    }

    public void setCharlieIntroKey(SessionKey key) {
        this._charlieIntroKey = key;
    }

    public SessionKey getBobCipherKey() {
        return this._bobCipherKey;
    }

    public void setBobCipherKey(SessionKey key) {
        this._bobCipherKey = key;
    }

    public SessionKey getBobMACKey() {
        return this._bobMACKey;
    }

    public void setBobMACKey(SessionKey key) {
        this._bobMACKey = key;
    }

    public long getBeginTime() {
        return this._beginTime;
    }

    public void setBeginTime(long when) {
        this._beginTime = when;
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public void setLastSendTime(long when) {
        this._lastSendTime = when;
    }

    public long getReceiveAliceTime() {
        return this._receiveAliceTime;
    }

    public void setReceiveAliceTime(long when) {
        this._receiveAliceTime = when;
    }

    public long getReceiveBobTime() {
        return this._receiveBobTime;
    }

    public void setReceiveBobTime(long when) {
        this._receiveBobTime = when;
    }

    public long getReceiveCharlieTime() {
        return this._receiveCharlieTime;
    }

    public void setReceiveCharlieTime(long when) {
        this._receiveCharlieTime = when;
    }

    public int getPacketsRelayed() {
        return this._packetsRelayed;
    }

    public void incrementPacketsRelayed() {
        ++this._packetsRelayed;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("Role: ");
        if (this._ourRole == 1) {
            buf.append("Alice");
        } else if (this._ourRole == 2) {
            buf.append("Bob");
        } else if (this._ourRole == 3) {
            buf.append("Charlie");
        } else {
            buf.append("unkown!");
        }
        if (this._aliceIP != null) {
            buf.append(" alice: ").append(this._aliceIP).append(':').append(this._alicePort);
        }
        if (this._aliceIPFromCharlie != null) {
            buf.append(" (fromCharlie ").append(this._aliceIPFromCharlie).append(':').append(this._alicePortFromCharlie).append(')');
        }
        if (this._bobIP != null) {
            buf.append(" bob: ").append(this._bobIP).append(':').append(this._bobPort);
        }
        if (this._charlieIP != null) {
            buf.append(" charlie: ").append(this._charlieIP).append(':').append(this._charliePort);
        }
        buf.append(" last send after ").append(this._lastSendTime - this._beginTime).append("ms");
        if (this._receiveAliceTime > 0L) {
            buf.append(" receive from alice after ").append(this._receiveAliceTime - this._beginTime).append("ms");
        }
        if (this._receiveBobTime > 0L) {
            buf.append(" receive from bob after ").append(this._receiveBobTime - this._beginTime).append("ms");
        }
        if (this._receiveCharlieTime > 0L) {
            buf.append(" receive from charlie after ").append(this._receiveCharlieTime - this._beginTime).append("ms");
        }
        buf.append(" packets relayed: ").append(this._packetsRelayed);
        return buf.toString();
    }
}

