/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.InboundMessageState;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PeerState {
    private final RouterContext _context;
    private final Log _log;
    private final Hash _remotePeer;
    private SessionKey _currentMACKey;
    private SessionKey _currentCipherKey;
    private SessionKey _nextMACKey;
    private SessionKey _nextCipherKey;
    private byte[] _nextKeyingMaterial;
    private boolean _rekeyBeganLocally;
    private long _keyEstablishedTime;
    private long _clockSkew;
    private long _currentReceiveSecond;
    private long _lastSendTime;
    private long _lastSendFullyTime;
    private long _lastReceiveTime;
    private int _consecutiveFailedSends;
    private final Set<Long> _currentACKs;
    private final Queue<Long> _currentACKsResend;
    private volatile long _lastACKSend;
    private volatile long _wantACKSendSince;
    private boolean _currentSecondECNReceived;
    private boolean _remoteWantsPreviousACKs;
    private volatile int _sendWindowBytes;
    private volatile int _sendWindowBytesRemaining;
    private long _lastSendRefill;
    private int _sendBps;
    private int _sendBytes;
    private int _receiveBps;
    private int _receiveBytes;
    private long _receivePeriodBegin;
    private volatile long _lastCongestionOccurred;
    private volatile int _slowStartThreshold;
    private final byte[] _remoteIP;
    private transient InetAddress _remoteIPAddress;
    private final int _remotePort;
    private final RemoteHostId _remoteHostId;
    private boolean _remoteRequiresIntroduction;
    private long _weRelayToThemAs;
    private long _theyRelayToUsAs;
    private int _mtu;
    private int _mtuReceive;
    private long _consecutiveSmall;
    private long _mtuIncreases;
    private long _mtuDecreases;
    private volatile int _rtt;
    private volatile int _rttDeviation;
    private volatile int _rto;
    static final long RETRANSMISSION_PERIOD_WIDTH = 100L;
    private long _messagesReceived;
    private long _messagesSent;
    private long _packetsTransmitted;
    private long _packetsRetransmitted;
    private long _packetsPeriodTransmitted;
    private int _packetsPeriodRetransmitted;
    private int _packetRetransmissionRate;
    private long _packetsReceivedDuplicate;
    private long _packetsReceived;
    private final Map<Long, InboundMessageState> _inboundMessages;
    private final List<OutboundMessageState> _outboundMessages;
    private OutboundMessageState _retransmitter;
    private final UDPTransport _transport;
    private volatile boolean _dead;
    private static final int MIN_CONCURRENT_MSGS = 8;
    private volatile int _concurrentMessagesAllowed = 8;
    private volatile int _concurrentMessagesActive = 0;
    private volatile int _consecutiveRejections = 0;
    private final boolean _isInbound;
    private long _lastIntroducerTime;
    private static final int DEFAULT_SEND_WINDOW_BYTES = 8192;
    private static final int MINIMUM_WINDOW_BYTES = 8192;
    private static final int MAX_SEND_WINDOW_BYTES = 0x100000;
    public static final int MIN_MTU = 620;
    private static final int DEFAULT_MTU = 620;
    public static final int LARGE_MTU = 1484;
    private static final int MIN_RTO = 600;
    private static final int MAX_RTO = 3000;
    private static final String PROP_DEFAULT_MTU = "i2np.udp.mtu";
    private static final boolean IGNORE_CWIN = false;
    private static final boolean ALWAYS_ALLOW_FIRST_PUSH = false;
    private static final int MAX_RESEND_ACKS = 16;
    private static final int MAX_RESEND_ACKS_LARGE = 16;
    private static final int MAX_RESEND_ACKS_SMALL = 16;
    private static final int MTU_RCV_DISPLAY_THRESHOLD = 20;
    private static final boolean THROTTLE_RESENDS = true;
    private static final boolean THROTTLE_INITIAL_SEND = true;
    private static final int MIN_EXPLICIT_ACKS = 3;
    private static final int MIN_ACK_SIZE = 13;

    public PeerState(RouterContext ctx, UDPTransport transport, byte[] remoteIP, int remotePort, Hash remotePeer, boolean isInbound) {
        long now;
        this._context = ctx;
        this._log = ctx.logManager().getLog(PeerState.class);
        this._transport = transport;
        this._keyEstablishedTime = now = ctx.clock().now();
        this._currentReceiveSecond = now - now % 1000L;
        this._lastSendTime = now;
        this._lastReceiveTime = now;
        this._currentACKs = new ConcurrentHashSet();
        this._currentACKsResend = new LinkedBlockingQueue<Long>();
        this._sendWindowBytes = 8192;
        this._sendWindowBytesRemaining = 8192;
        this._slowStartThreshold = 524288;
        this._lastSendRefill = now;
        this._receivePeriodBegin = now;
        this._lastCongestionOccurred = -1L;
        this._remotePort = remotePort;
        this._mtuReceive = this._mtu = this.getDefaultMTU();
        this._lastACKSend = -1L;
        this._rto = 600;
        this._rttDeviation = this._rtt = this._rto / 2;
        this._inboundMessages = new HashMap<Long, InboundMessageState>(8);
        this._outboundMessages = new ArrayList<OutboundMessageState>(32);
        this._remoteIP = remoteIP;
        this._remotePeer = remotePeer;
        this._isInbound = isInbound;
        this._remoteHostId = new RemoteHostId(remoteIP, remotePort);
    }

    private int getDefaultMTU() {
        return this._context.getProperty(PROP_DEFAULT_MTU, 620);
    }

    public Hash getRemotePeer() {
        return this._remotePeer;
    }

    public SessionKey getCurrentMACKey() {
        return this._currentMACKey;
    }

    public SessionKey getCurrentCipherKey() {
        return this._currentCipherKey;
    }

    public SessionKey getNextMACKey() {
        return this._nextMACKey;
    }

    public SessionKey getNextCipherKey() {
        return this._nextCipherKey;
    }

    public byte[] getNextKeyingMaterial() {
        return this._nextKeyingMaterial;
    }

    public boolean getRekeyBeganLocally() {
        return this._rekeyBeganLocally;
    }

    public long getKeyEstablishedTime() {
        return this._keyEstablishedTime;
    }

    public long getClockSkew() {
        return this._clockSkew;
    }

    public long getCurrentReceiveSecond() {
        return this._currentReceiveSecond;
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public long getLastSendFullyTime() {
        return this._lastSendFullyTime;
    }

    public long getLastReceiveTime() {
        return this._lastReceiveTime;
    }

    public int getConsecutiveFailedSends() {
        return this._consecutiveFailedSends;
    }

    public boolean getCurrentSecondECNReceived() {
        return this._currentSecondECNReceived;
    }

    public boolean getRemoteWantsPreviousACKs() {
        return this._remoteWantsPreviousACKs;
    }

    public int getSendWindowBytes() {
        return this._sendWindowBytes;
    }

    public int getSendWindowBytesRemaining() {
        return this._sendWindowBytesRemaining;
    }

    public byte[] getRemoteIP() {
        return this._remoteIP;
    }

    public InetAddress getRemoteIPAddress() {
        block3: {
            if (this._remoteIPAddress == null) {
                try {
                    this._remoteIPAddress = InetAddress.getByAddress(this._remoteIP);
                }
                catch (UnknownHostException uhe) {
                    if (!this._log.shouldLog(40)) break block3;
                    this._log.error("Invalid IP? ", (Throwable)uhe);
                }
            }
        }
        return this._remoteIPAddress;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public boolean getRemoteRequiresIntroduction() {
        return this._remoteRequiresIntroduction;
    }

    public long getWeRelayToThemAs() {
        return this._weRelayToThemAs;
    }

    public long getTheyRelayToUsAs() {
        return this._theyRelayToUsAs;
    }

    public int getMTU() {
        return this._mtu;
    }

    public int getReceiveMTU() {
        return this._mtuReceive;
    }

    public void setCurrentMACKey(SessionKey key) {
        this._currentMACKey = key;
    }

    public void setCurrentCipherKey(SessionKey key) {
        this._currentCipherKey = key;
    }

    public void setNextMACKey(SessionKey key) {
        this._nextMACKey = key;
    }

    public void setNextCipherKey(SessionKey key) {
        this._nextCipherKey = key;
    }

    public void setNextKeyingMaterial(byte[] data) {
        this._nextKeyingMaterial = data;
    }

    public void setRekeyBeganLocally(boolean local) {
        this._rekeyBeganLocally = local;
    }

    public void setKeyEstablishedTime(long when) {
        this._keyEstablishedTime = when;
    }

    public void adjustClockSkew(long skew) {
        this._clockSkew = (long)(0.9 * (double)this._clockSkew + 0.1 * (double)(skew - (long)(this._rtt / 2)));
    }

    public void setCurrentReceiveSecond(long sec) {
        this._currentReceiveSecond = sec;
    }

    public void setLastSendTime(long when) {
        this._lastSendTime = when;
    }

    public void setLastReceiveTime(long when) {
        this._lastReceiveTime = when;
    }

    public int getSendBps() {
        return this._sendBps;
    }

    public int getReceiveBps() {
        return this._receiveBps;
    }

    public int incrementConsecutiveFailedSends() {
        --this._concurrentMessagesActive;
        if (this._concurrentMessagesActive < 0) {
            this._concurrentMessagesActive = 0;
        }
        ++this._consecutiveFailedSends;
        return this._consecutiveFailedSends;
    }

    public long getInactivityTime() {
        long now = this._context.clock().now();
        long lastActivity = Math.max(this._lastReceiveTime, this._lastSendFullyTime);
        return now - lastActivity;
    }

    public void remoteDoesNotWantPreviousACKs() {
        this._remoteWantsPreviousACKs = false;
    }

    public boolean allocateSendingBytes(int size, int messagePushCount) {
        return this.allocateSendingBytes(size, false, messagePushCount);
    }

    public boolean allocateSendingBytes(int size, boolean isForACK) {
        return this.allocateSendingBytes(size, isForACK, -1);
    }

    public boolean allocateSendingBytes(int size, boolean isForACK, int messagePushCount) {
        long now = this._context.clock().now();
        long duration = now - this._lastSendRefill;
        if (duration >= 1000L) {
            this._sendWindowBytesRemaining = this._sendWindowBytes;
            this._sendBytes += size;
            this._sendBps = (int)(0.9f * (float)this._sendBps + 0.1f * ((float)this._sendBytes * (1000.0f / (float)duration)));
            this._sendBytes = 0;
            this._lastSendRefill = now;
        }
        if (size <= this._sendWindowBytesRemaining) {
            if (messagePushCount == 0 && this._concurrentMessagesActive > this._concurrentMessagesAllowed) {
                ++this._consecutiveRejections;
                this._context.statManager().addRateData("udp.rejectConcurrentActive", (long)this._concurrentMessagesActive, (long)this._consecutiveRejections);
                return false;
            }
            if (messagePushCount == 0) {
                this._context.statManager().addRateData("udp.allowConcurrentActive", (long)this._concurrentMessagesActive, (long)this._concurrentMessagesAllowed);
                ++this._concurrentMessagesActive;
                if (this._consecutiveRejections > 0) {
                    this._context.statManager().addRateData("udp.rejectConcurrentSequence", (long)this._consecutiveRejections, (long)this._concurrentMessagesActive);
                }
                this._consecutiveRejections = 0;
            }
            this._sendWindowBytesRemaining -= size;
            this._sendBytes += size;
            this._lastSendTime = now;
            return true;
        }
        return false;
    }

    public void setRemoteRequiresIntroduction(boolean required) {
        this._remoteRequiresIntroduction = required;
    }

    public void setWeRelayToThemAs(long tag) {
        this._weRelayToThemAs = tag;
    }

    public void setTheyRelayToUsAs(long tag) {
        this._theyRelayToUsAs = tag;
    }

    public int getSlowStartThreshold() {
        return this._slowStartThreshold;
    }

    public int getConcurrentSends() {
        return this._concurrentMessagesActive;
    }

    public int getConcurrentSendWindow() {
        return this._concurrentMessagesAllowed;
    }

    public int getConsecutiveSendRejections() {
        return this._consecutiveRejections;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public long getIntroducerTime() {
        return this._lastIntroducerTime;
    }

    public void setIntroducerTime() {
        this._lastIntroducerTime = this._context.clock().now();
    }

    public void messageFullyReceived(Long messageId, int bytes) {
        this.messageFullyReceived(messageId, bytes, false);
    }

    public void messageFullyReceived(Long messageId, int bytes, boolean isForACK) {
        if (bytes > 0) {
            this._receiveBytes += bytes;
        } else {
            ++this._packetsReceivedDuplicate;
        }
        long now = this._context.clock().now();
        long duration = now - this._receivePeriodBegin;
        if (duration >= 1000L) {
            this._receiveBps = (int)(0.9f * (float)this._receiveBps + 0.1f * ((float)this._receiveBytes * (1000.0f / (float)duration)));
            this._receiveBytes = 0;
            this._receivePeriodBegin = now;
            this._context.statManager().addRateData("udp.receiveBps", (long)this._receiveBps, 0L);
        }
        if (this._wantACKSendSince <= 0L) {
            this._wantACKSendSince = now;
        }
        this._currentACKs.add(messageId);
        ++this._messagesReceived;
    }

    public void messagePartiallyReceived() {
        if (this._wantACKSendSince <= 0L) {
            this._wantACKSendSince = this._context.clock().now();
        }
    }

    public Map<Long, InboundMessageState> getInboundMessages() {
        return this._inboundMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expireInboundMessages() {
        int rv = 0;
        Map<Long, InboundMessageState> map = this._inboundMessages;
        synchronized (map) {
            Iterator<InboundMessageState> iter = this._inboundMessages.values().iterator();
            while (iter.hasNext()) {
                InboundMessageState state = iter.next();
                if (state.isExpired() || this._dead) {
                    iter.remove();
                    continue;
                }
                if (state.isComplete()) {
                    this._log.error("inbound message is complete, but wasn't handled inline? " + state + " with " + this);
                    iter.remove();
                    continue;
                }
                ++rv;
            }
        }
        return rv;
    }

    private boolean congestionOccurred() {
        long now = this._context.clock().now();
        if (this._lastCongestionOccurred + (long)this._rto > now) {
            return false;
        }
        this._lastCongestionOccurred = now;
        this._context.statManager().addRateData("udp.congestionOccurred", (long)this._sendWindowBytes, (long)this._sendBps);
        int congestionAt = this._sendWindowBytes;
        this._sendWindowBytes /= 2;
        if (this._sendWindowBytes < 8192) {
            this._sendWindowBytes = 8192;
        }
        this._slowStartThreshold = congestionAt / 2;
        return true;
    }

    public List<Long> getCurrentFullACKs() {
        ArrayList<Long> rv = new ArrayList<Long>(this._currentACKs);
        if (this._log.shouldLog(10)) {
            this._log.debug("Returning " + this._currentACKs.size() + " current acks");
        }
        return rv;
    }

    public List<Long> getCurrentResendACKs() {
        ArrayList<Long> randomResends = new ArrayList<Long>(this._currentACKsResend);
        Collections.shuffle(randomResends, (Random)this._context.random());
        if (this._log.shouldLog(10)) {
            this._log.debug("Returning " + randomResends.size() + " resend acks");
        }
        return randomResends;
    }

    public void removeACKMessage(Long messageId) {
        boolean removed = this._currentACKs.remove(messageId);
        if (removed) {
            this._currentACKsResend.offer(messageId);
            while (this._currentACKsResend.size() > 16) {
                this._currentACKsResend.poll();
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Sent ack " + messageId + " now " + this._currentACKs.size() + " current and " + this._currentACKsResend.size() + " resend acks");
            }
        }
        this._lastACKSend = this._context.clock().now();
    }

    public List<ACKBitfield> retrieveACKBitfields() {
        return this.retrieveACKBitfields(true);
    }

    public List<ACKBitfield> retrieveACKBitfields(boolean alwaysIncludeRetransmissions) {
        int bytesRemaining;
        ArrayList<ACKBitfield> rv = new ArrayList<ACKBitfield>(16);
        int resendSize = this._currentACKsResend.size();
        int maxResendAcks = bytesRemaining < 620 ? 16 : 16;
        ArrayList<Long> randomResends = new ArrayList<Long>(this._currentACKsResend);
        Iterator<Long> iter = this._currentACKs.iterator();
        for (bytesRemaining = this.countMaxACKData(); bytesRemaining >= 4 && iter.hasNext(); bytesRemaining -= 4) {
            Long val = iter.next();
            iter.remove();
            long id = val;
            rv.add(new FullACKBitfield(id));
            this._currentACKsResend.offer(val);
        }
        if (this._currentACKs.isEmpty()) {
            this._wantACKSendSince = -1L;
        }
        if (alwaysIncludeRetransmissions || !rv.isEmpty()) {
            int oldIndex = Math.min(resendSize, maxResendAcks);
            if (oldIndex > 0 && oldIndex < resendSize) {
                Collections.shuffle(randomResends, (Random)this._context.random());
            }
            iter = randomResends.iterator();
            while (bytesRemaining >= 4 && oldIndex-- > 0 && iter.hasNext()) {
                Long cur = iter.next();
                long c = cur;
                FullACKBitfield bf = new FullACKBitfield(c);
                rv.add(bf);
                bytesRemaining -= 4;
            }
        }
        while (this._currentACKsResend.size() > 16) {
            this._currentACKsResend.poll();
        }
        int partialIncluded = 0;
        if (bytesRemaining > 4) {
            ArrayList<ACKBitfield> partial = new ArrayList<ACKBitfield>();
            this.fetchPartialACKs(partial);
            for (int i = 0; bytesRemaining > 4 && i < partial.size(); ++i) {
                ACKBitfield bitfield = (ACKBitfield)partial.get(i);
                int bytes = bitfield.fragmentCount() / 7 + 1;
                if (bytesRemaining <= bytes + 4) continue;
                rv.add(bitfield);
                bytesRemaining -= bytes + 4;
                ++partialIncluded;
            }
        }
        this._lastACKSend = this._context.clock().now();
        if (partialIncluded > 0) {
            this._context.statManager().addRateData("udp.sendACKPartial", (long)partialIncluded, (long)(rv.size() - partialIncluded));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchPartialACKs(List<ACKBitfield> rv) {
        InboundMessageState[] states = null;
        int curState = 0;
        Map<Long, InboundMessageState> map = this._inboundMessages;
        synchronized (map) {
            int numMessages = this._inboundMessages.size();
            if (numMessages <= 0) {
                return;
            }
            Iterator<InboundMessageState> iter = this._inboundMessages.values().iterator();
            while (iter.hasNext()) {
                InboundMessageState state = iter.next();
                if (state.isExpired()) {
                    iter.remove();
                    continue;
                }
                if (state.isComplete()) continue;
                if (states == null) {
                    states = new InboundMessageState[numMessages];
                }
                states[curState++] = state;
            }
        }
        if (states != null) {
            for (int i = curState - 1; i >= 0; --i) {
                if (states[i] == null) continue;
                rv.add(states[i].createACKBitfield());
            }
        }
    }

    public void messageACKed(int bytesACKed, long lifetime, int numSends) {
        --this._concurrentMessagesActive;
        if (this._concurrentMessagesActive < 0) {
            this._concurrentMessagesActive = 0;
        }
        this._consecutiveFailedSends = 0;
        if (numSends < 2) {
            if (this._context.random().nextInt(this._concurrentMessagesAllowed) <= 0) {
                ++this._concurrentMessagesAllowed;
            }
            if (this._sendWindowBytes <= this._slowStartThreshold) {
                this._sendWindowBytes += bytesACKed;
            } else {
                float prob = (float)bytesACKed / (float)(this._sendWindowBytes << 1);
                float v = this._context.random().nextFloat();
                if (v < 0.0f) {
                    v = 0.0f - v;
                }
                if (v <= prob) {
                    this._sendWindowBytes += bytesACKed;
                }
            }
        } else {
            int allow = this._concurrentMessagesAllowed - 1;
            if (allow < 8) {
                allow = 8;
            }
            this._concurrentMessagesAllowed = allow;
        }
        if (this._sendWindowBytes > 0x100000) {
            this._sendWindowBytes = 0x100000;
        }
        this._lastSendFullyTime = this._lastReceiveTime = this._context.clock().now();
        this._sendWindowBytesRemaining = this._sendWindowBytesRemaining + bytesACKed <= this._sendWindowBytes ? (this._sendWindowBytesRemaining += bytesACKed) : this._sendWindowBytes;
        ++this._messagesSent;
        if (numSends < 2) {
            this.recalculateTimeouts(lifetime);
            this.adjustMTU();
        } else if (this._log.shouldLog(20)) {
            this._log.info("acked after numSends=" + numSends + " w/ lifetime=" + lifetime + " and size=" + bytesACKed);
        }
        this._context.statManager().addRateData("udp.sendBps", (long)this._sendBps, lifetime);
    }

    private void recalculateTimeouts(long lifetime) {
        this._rttDeviation += (int)(0.25 * (double)(Math.abs(lifetime - (long)this._rtt) - (long)this._rttDeviation));
        float scale = 0.1f;
        if (this._sendBps > 0) {
            scale = (float)lifetime / ((float)lifetime + (float)this._sendBps);
        }
        if (scale < 0.001f) {
            scale = 0.001f;
        }
        this._rtt = (int)((float)this._rtt * (1.0f - scale) + scale * (float)lifetime);
        this._rto = this._rtt + (this._rttDeviation << 2);
        if (this._log.shouldLog(10)) {
            this._log.debug("Recalculating timeouts w/ lifetime=" + lifetime + ": rtt=" + this._rtt + " rttDev=" + this._rttDeviation + " rto=" + this._rto);
        }
        if (this._rto < this.minRTO()) {
            this._rto = this.minRTO();
        }
        if (this._rto > 3000) {
            this._rto = 3000;
        }
    }

    private void adjustMTU() {
        double retransPct = 0.0;
        if (this._packetsTransmitted > 10L) {
            boolean wantLarge;
            retransPct = (double)this._packetsRetransmitted / (double)this._packetsTransmitted;
            boolean bl = wantLarge = retransPct < 0.3;
            if (wantLarge && this._mtu != 1484) {
                if (this._context.random().nextLong(this._mtuDecreases) <= 0L) {
                    this._mtu = 1484;
                    ++this._mtuIncreases;
                    this._context.statManager().addRateData("udp.mtuIncrease", this._mtuIncreases, this._mtuDecreases);
                }
            } else if (!wantLarge && this._mtu == 1484) {
                this._mtu = 620;
                ++this._mtuDecreases;
                this._context.statManager().addRateData("udp.mtuDecrease", this._mtuDecreases, this._mtuIncreases);
            }
        } else {
            this._mtu = 620;
        }
    }

    public void messageRetransmitted(int packets) {
        this._packetsRetransmitted += (long)packets;
        this.congestionOccurred();
        this._context.statManager().addRateData("udp.congestedRTO", (long)this._rto, (long)this._rttDeviation);
        this.adjustMTU();
    }

    public void packetsTransmitted(int packets) {
        this._packetsTransmitted += (long)packets;
    }

    public int getRTT() {
        return this._rtt;
    }

    public int getRTO() {
        return this._rto;
    }

    public long getRTTDeviation() {
        return this._rttDeviation;
    }

    public long getMessagesSent() {
        return this._messagesSent;
    }

    public long getMessagesReceived() {
        return this._messagesReceived;
    }

    public long getPacketsTransmitted() {
        return this._packetsTransmitted;
    }

    public long getPacketsRetransmitted() {
        return this._packetsRetransmitted;
    }

    public long getPacketsPeriodTransmitted() {
        return this._packetsPeriodTransmitted;
    }

    public int getPacketsPeriodRetransmitted() {
        return this._packetsPeriodRetransmitted;
    }

    public long getPacketRetransmissionRate() {
        return this._packetRetransmissionRate;
    }

    public long getPacketsReceived() {
        return this._packetsReceived;
    }

    public long getPacketsReceivedDuplicate() {
        return this._packetsReceivedDuplicate;
    }

    public void packetReceived(int size) {
        ++this._packetsReceived;
        if (size <= 620) {
            ++this._consecutiveSmall;
        } else {
            this._consecutiveSmall = 0L;
            this._mtuReceive = 1484;
            return;
        }
        if (this._packetsReceived > 20L) {
            this._mtuReceive = this._consecutiveSmall < 20L ? 1484 : 620;
        }
    }

    public void ECNReceived() {
        this.congestionOccurred();
        this._currentSecondECNReceived = true;
        this._lastReceiveTime = this._context.clock().now();
    }

    public void dataReceived() {
        this._lastReceiveTime = this._context.clock().now();
    }

    public long getLastACKSend() {
        return this._lastACKSend;
    }

    public void setLastACKSend(long when) {
        this._lastACKSend = when;
    }

    public long getWantedACKSendSince() {
        return this._wantACKSendSince;
    }

    public boolean unsentACKThresholdReached() {
        int threshold = this.countMaxACKData() / 4;
        return this._currentACKs.size() >= threshold;
    }

    private int countMaxACKData() {
        return this._mtu - 20 - 8 - 16 - 16 - 1 - 4 - 1 - 1 - 16;
    }

    private int minRTO() {
        if (this._packetRetransmissionRate < 10) {
            return 600;
        }
        if (this._packetRetransmissionRate < 50) {
            return 1200;
        }
        return 3000;
    }

    RemoteHostId getRemoteHostId() {
        return this._remoteHostId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(OutboundMessageState state) {
        if (this._dead) {
            this._transport.failed(state, false);
            return 0;
        }
        state.setPeer(this);
        if (this._log.shouldLog(10)) {
            this._log.debug("Adding to " + this._remotePeer.toBase64() + ": " + state.getMessageId());
        }
        int rv = 0;
        boolean fail = false;
        List<OutboundMessageState> list = this._outboundMessages;
        synchronized (list) {
            rv = this._outboundMessages.size() + 1;
            if (rv > 32) {
                fail = true;
                --rv;
            } else {
                this._outboundMessages.add(state);
            }
        }
        if (fail) {
            this._transport.failed(state, false);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropOutbound() {
        this._dead = true;
        this._retransmitter = null;
        int sz = 0;
        ArrayList<OutboundMessageState> tempList = null;
        List<OutboundMessageState> list = this._outboundMessages;
        synchronized (list) {
            sz = this._outboundMessages.size();
            if (sz > 0) {
                tempList = new ArrayList<OutboundMessageState>(this._outboundMessages);
                this._outboundMessages.clear();
            }
        }
        for (int i = 0; i < sz; ++i) {
            this._transport.failed((OutboundMessageState)tempList.get(i), false);
        }
        this._wantACKSendSince = -1L;
    }

    public int getOutboundMessageCount() {
        if (this._dead) {
            return 0;
        }
        return this._outboundMessages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int finishMessages() {
        OutNetMessage msg;
        OutboundMessageState state;
        int i;
        if (this._outboundMessages.isEmpty()) {
            return 0;
        }
        if (this._dead) {
            this.dropOutbound();
            return 0;
        }
        int rv = 0;
        ArrayList<OutboundMessageState> succeeded = null;
        ArrayList<OutboundMessageState> failed = null;
        List<OutboundMessageState> list = this._outboundMessages;
        synchronized (list) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                OutboundMessageState state2 = iter.next();
                if (state2.isComplete()) {
                    iter.remove();
                    if (this._retransmitter == state2) {
                        this._retransmitter = null;
                    }
                    if (succeeded == null) {
                        succeeded = new ArrayList<OutboundMessageState>(4);
                    }
                    succeeded.add(state2);
                    continue;
                }
                if (state2.isExpired()) {
                    iter.remove();
                    if (this._retransmitter == state2) {
                        this._retransmitter = null;
                    }
                    this._context.statManager().addRateData("udp.sendFailed", (long)state2.getPushCount(), state2.getLifetime());
                    if (failed == null) {
                        failed = new ArrayList<OutboundMessageState>(4);
                    }
                    failed.add(state2);
                    continue;
                }
                if (state2.getPushCount() <= 10) continue;
                iter.remove();
                if (state2 == this._retransmitter) {
                    this._retransmitter = null;
                }
                this._context.statManager().addRateData("udp.sendAggressiveFailed", (long)state2.getPushCount(), state2.getLifetime());
                if (failed == null) {
                    failed = new ArrayList(4);
                }
                failed.add(state2);
            }
            rv = this._outboundMessages.size();
        }
        for (i = 0; succeeded != null && i < succeeded.size(); ++i) {
            state = (OutboundMessageState)succeeded.get(i);
            this._transport.succeeded(state);
            state.releaseResources();
            msg = state.getMessage();
            if (msg == null) continue;
            msg.timestamp("sending complete");
        }
        for (i = 0; failed != null && i < failed.size(); ++i) {
            state = (OutboundMessageState)failed.get(i);
            msg = state.getMessage();
            if (msg != null) {
                msg.timestamp("expired in the active pool");
                this._transport.failed(state);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Unable to send a direct message: " + state);
            }
            state.releaseResources();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundMessageState allocateSend() {
        if (this._dead) {
            return null;
        }
        List<OutboundMessageState> list = this._outboundMessages;
        synchronized (list) {
            for (OutboundMessageState state : this._outboundMessages) {
                if (!this.locked_shouldSend(state)) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Allocate sending to " + this._remotePeer.toBase64() + ": " + state.getMessageId());
                }
                return state;
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Nothing to send to " + this._remotePeer.toBase64() + ", with " + this._outboundMessages.size() + " remaining");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextDelay() {
        int rv = Integer.MAX_VALUE;
        if (this._dead) {
            return rv;
        }
        long now = this._context.clock().now();
        List<OutboundMessageState> list = this._outboundMessages;
        synchronized (list) {
            if (this._retransmitter != null) {
                rv = (int)(this._retransmitter.getNextSendTime() - now);
                return rv;
            }
            for (OutboundMessageState state : this._outboundMessages) {
                int delay = (int)(state.getNextSendTime() - now);
                if (delay >= rv) continue;
                rv = delay;
            }
        }
        return rv;
    }

    private static final int fragmentSize(int mtu) {
        return mtu - 87;
    }

    private boolean locked_shouldSend(OutboundMessageState state) {
        long now = this._context.clock().now();
        if (state.getNextSendTime() <= now) {
            OutboundMessageState retrans;
            if (!state.isFragmented()) {
                state.fragment(PeerState.fragmentSize(this._mtu));
                if (state.getMessage() != null) {
                    state.getMessage().timestamp("fragment into " + state.getFragmentCount());
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Fragmenting " + state);
                }
            }
            if ((retrans = this._retransmitter) != null && (retrans.isExpired() || retrans.isComplete())) {
                this._retransmitter = null;
                retrans = null;
            }
            if (retrans != null && retrans != state) {
                this._context.statManager().addRateData("udp.blockedRetransmissions", this._packetsRetransmitted, this._packetsTransmitted);
                int max = state.getMaxSends();
                if (max <= 0) {
                    // empty if block
                }
                if (max > 0) {
                    // empty if block
                }
                return false;
            }
            int size = state.getUnackedSize();
            if (this.allocateSendingBytes(size, state.getPushCount())) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Allocation of " + size + " allowed with " + this.getSendWindowBytesRemaining() + "/" + this.getSendWindowBytes() + " remaining" + " for message " + state.getMessageId() + ": " + state);
                }
                if (state.getPushCount() > 0) {
                    this._retransmitter = state;
                }
                state.push();
                int rto = this.getRTO();
                state.setNextSendTime(now + (long)rto);
                return true;
            }
            this._context.statManager().addRateData("udp.sendRejected", (long)state.getPushCount(), state.getLifetime());
            if (this._log.shouldLog(20)) {
                this._log.info("Allocation of " + size + " rejected w/ wsize=" + this.getSendWindowBytes() + " available=" + this.getSendWindowBytesRemaining() + " for message " + state.getMessageId() + ": " + state);
            }
            state.setNextSendTime(now + 250L + (long)this._context.random().nextInt(500));
            if (this._log.shouldLog(20)) {
                this._log.info("Retransmit after choke for next send time in " + (state.getNextSendTime() - now) + "ms");
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acked(long messageId) {
        if (this._dead) {
            return false;
        }
        OutboundMessageState state = null;
        List<OutboundMessageState> list = this._outboundMessages;
        synchronized (list) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                state = iter.next();
                if (state.getMessageId() == messageId) {
                    iter.remove();
                    break;
                }
                state = null;
            }
            if (state != null && state == this._retransmitter) {
                this._retransmitter = null;
            }
        }
        if (state != null) {
            int numSends = state.getMaxSends();
            if (this._log.shouldLog(20)) {
                this._log.info("Received ack of " + messageId + " by " + this._remotePeer.toBase64() + " after " + state.getLifetime() + " and " + numSends + " sends");
            }
            this._context.statManager().addRateData("udp.sendConfirmTime", state.getLifetime(), state.getLifetime());
            if (state.getFragmentCount() > 1) {
                this._context.statManager().addRateData("udp.sendConfirmFragments", (long)state.getFragmentCount(), state.getLifetime());
            }
            if (numSends > 1) {
                this._context.statManager().addRateData("udp.sendConfirmVolley", (long)numSends, (long)state.getFragmentCount());
            }
            this._transport.succeeded(state);
            int numFragments = state.getFragmentCount();
            this.messageACKed(numFragments * state.getFragmentSize(), state.getLifetime(), numSends);
            state.releaseResources();
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Received an ACK for a message not pending: " + messageId);
        }
        return state != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acked(ACKBitfield bitfield) {
        if (this._dead) {
            return false;
        }
        if (bitfield.receivedComplete()) {
            return this.acked(bitfield.getMessageId());
        }
        OutboundMessageState state = null;
        boolean isComplete = false;
        List<OutboundMessageState> list = this._outboundMessages;
        synchronized (list) {
            Iterator<OutboundMessageState> iter = this._outboundMessages.iterator();
            while (iter.hasNext()) {
                state = iter.next();
                if (state.getMessageId() == bitfield.getMessageId()) {
                    boolean complete = state.acked(bitfield);
                    if (!complete) break;
                    isComplete = true;
                    iter.remove();
                    if (state != this._retransmitter) break;
                    this._retransmitter = null;
                    break;
                }
                state = null;
            }
        }
        if (state != null) {
            int numSends = state.getMaxSends();
            int bits = bitfield.fragmentCount();
            int numACKed = 0;
            for (int i = 0; i < bits; ++i) {
                if (!bitfield.received(i)) continue;
                ++numACKed;
            }
            this._context.statManager().addRateData("udp.partialACKReceived", (long)numACKed, state.getLifetime());
            if (this._log.shouldLog(20)) {
                this._log.info("Received partial ack of " + state.getMessageId() + " by " + this._remotePeer.toBase64() + " after " + state.getLifetime() + " and " + numSends + " sends: " + bitfield + ": completely removed? " + isComplete + ": " + state);
            }
            if (isComplete) {
                this._context.statManager().addRateData("udp.sendConfirmTime", state.getLifetime(), state.getLifetime());
                if (state.getFragmentCount() > 1) {
                    this._context.statManager().addRateData("udp.sendConfirmFragments", (long)state.getFragmentCount(), state.getLifetime());
                }
                if (numSends > 1) {
                    this._context.statManager().addRateData("udp.sendConfirmVolley", (long)numSends, (long)state.getFragmentCount());
                }
                this._transport.succeeded(state);
                this.messageACKed(state.getFragmentCount() * state.getFragmentSize(), state.getLifetime(), 0);
                state.releaseResources();
            }
            return isComplete;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Received an ACK for a message not pending: " + bitfield);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrom(PeerState oldPeer) {
        this._rto = oldPeer._rto;
        this._rtt = oldPeer._rtt;
        this._rttDeviation = oldPeer._rttDeviation;
        this._slowStartThreshold = oldPeer._slowStartThreshold;
        this._sendWindowBytes = oldPeer._sendWindowBytes;
        oldPeer._dead = true;
        ArrayList<Long> tmp = new ArrayList<Long>();
        for (Long l : oldPeer._currentACKs) {
            tmp.add(l);
        }
        oldPeer._currentACKs.clear();
        if (!this._dead) {
            this._currentACKs.addAll(tmp);
        }
        tmp.clear();
        tmp.addAll(oldPeer._currentACKsResend);
        oldPeer._currentACKsResend.clear();
        if (!this._dead) {
            this._currentACKsResend.addAll(tmp);
        }
        HashMap<Long, InboundMessageState> msgs = new HashMap<Long, InboundMessageState>();
        Map<Long, InboundMessageState> map = oldPeer._inboundMessages;
        synchronized (map) {
            msgs.putAll(oldPeer._inboundMessages);
            oldPeer._inboundMessages.clear();
        }
        if (!this._dead) {
            Map<Long, InboundMessageState> map2 = this._inboundMessages;
            synchronized (map2) {
                this._inboundMessages.putAll(msgs);
            }
        }
        msgs.clear();
        ArrayList<OutboundMessageState> arrayList = new ArrayList<OutboundMessageState>();
        OutboundMessageState retransmitter = null;
        List<OutboundMessageState> list = oldPeer._outboundMessages;
        synchronized (list) {
            arrayList.addAll(oldPeer._outboundMessages);
            oldPeer._outboundMessages.clear();
            retransmitter = oldPeer._retransmitter;
            oldPeer._retransmitter = null;
        }
        if (!this._dead) {
            list = this._outboundMessages;
            synchronized (list) {
                this._outboundMessages.addAll(arrayList);
                this._retransmitter = retransmitter;
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(this._remoteHostId.toString());
        if (this._remotePeer != null) {
            buf.append(" ").append(this._remotePeer.toBase64().substring(0, 6));
        }
        long now = this._context.clock().now();
        buf.append(" recvAge: ").append(now - this._lastReceiveTime);
        buf.append(" sendAge: ").append(now - this._lastSendFullyTime);
        buf.append(" sendAttemptAge: ").append(now - this._lastSendTime);
        buf.append(" sendACKAge: ").append(now - this._lastACKSend);
        buf.append(" lifetime: ").append(now - this._keyEstablishedTime);
        buf.append(" cwin: ").append(this._sendWindowBytes);
        buf.append(" acwin: ").append(this._sendWindowBytesRemaining);
        buf.append(" consecFail: ").append(this._consecutiveFailedSends);
        buf.append(" recv OK/Dup: ").append(this._packetsReceived).append('/').append(this._packetsReceivedDuplicate);
        buf.append(" send OK/Dup: ").append(this._packetsTransmitted).append('/').append(this._packetsRetransmitted);
        return buf.toString();
    }

    private static class FullACKBitfield
    implements ACKBitfield {
        private final long _msgId;

        public FullACKBitfield(long id) {
            this._msgId = id;
        }

        public int fragmentCount() {
            return 0;
        }

        public long getMessageId() {
            return this._msgId;
        }

        public boolean received(int fragmentNum) {
            return true;
        }

        public boolean receivedComplete() {
            return true;
        }

        public int hashCode() {
            return (int)this._msgId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FullACKBitfield)) {
                return false;
            }
            return this._msgId == ((ACKBitfield)o).getMessageId();
        }

        public String toString() {
            return "Full ACK of " + this._msgId;
        }
    }
}

