/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Date;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPEndpoint;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class PacketHandler {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final UDPEndpoint _endpoint;
    private final EstablishmentManager _establisher;
    private final InboundMessageFragments _inbound;
    private final PeerTestManager _testManager;
    private final IntroductionManager _introManager;
    private boolean _keepReading;
    private final Handler[] _handlers;
    private static final int MIN_NUM_HANDLERS = 2;
    private static final int MAX_NUM_HANDLERS = 5;
    private static final long GRACE_PERIOD = 90000L;
    private static final short OUTBOUND_FALLBACK = 1;
    private static final short INBOUND_FALLBACK = 2;
    private static final short NEW_PEER = 3;

    PacketHandler(RouterContext ctx, UDPTransport transport, UDPEndpoint endpoint, EstablishmentManager establisher, InboundMessageFragments inbound, PeerTestManager testManager, IntroductionManager introManager) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(PacketHandler.class);
        this._transport = transport;
        this._endpoint = endpoint;
        this._establisher = establisher;
        this._inbound = inbound;
        this._testManager = testManager;
        this._introManager = introManager;
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x6000000L;
        }
        int num_handlers = maxMemory < 0x2000000L ? 1 : (maxMemory < 0x4000000L ? 2 : Math.max(2, Math.min(5, ctx.bandwidthLimiter().getInboundKBytesPerSecond() / 20)));
        this._handlers = new Handler[num_handlers];
        for (int i = 0; i < num_handlers; ++i) {
            this._handlers[i] = new Handler();
        }
        this._context.statManager().createRateStat("udp.handleTime", "How long it takes to handle a received packet after its been pulled off the queue", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.queueTime", "How long after a packet is received can we begin handling it", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSkew", "How long ago after the packet was sent did we receive it", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidUnkown", "How old the packet we dropped due to invalidity (unkown type) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidReestablish", "How old the packet we dropped due to invalidity (doesn't use existing key, not an establishment) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish", "How old the packet we dropped due to invalidity (establishment, bad key) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.inbound", "How old the packet we dropped due to invalidity (even though we have an active inbound establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.outbound", "How old the packet we dropped due to invalidity (even though we have an active outbound establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.new", "How old the packet we dropped due to invalidity (even though we do not have any active establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidInboundEstablish", "How old the packet we dropped due to invalidity (inbound establishment, bad key) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidSkew", "How skewed the packet we dropped due to invalidity (valid except bad skew) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.packetDequeueTime", "How long it takes the UDPReader to pull a packet off the inbound packet queue (when its slow)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.packetVerifyTime", "How long it takes the PacketHandler to verify a data packet after dequeueing (period is dequeue time)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.packetVerifyTimeSlow", "How long it takes the PacketHandler to verify a data packet after dequeueing when its slow (period is dequeue time)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.packetValidateMultipleCount", "How many times we validate a packet, if done more than once (period = afterValidate-enqueue)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.packetNoValidationLifetime", "How long packets that are never validated are around for", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.sessionRequest", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.sessionConfirmed", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.sessionCreated", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataKnown", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataKnownAck", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataUnknown", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataUnknownAck", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.test", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.relayRequest", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.relayIntro", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.relayResponse", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
    }

    public void startup() {
        this._keepReading = true;
        for (int i = 0; i < this._handlers.length; ++i) {
            I2PThread t = new I2PThread((Runnable)this._handlers[i], "UDP Packet handler " + (i + 1) + '/' + this._handlers.length, true);
            t.start();
        }
    }

    public void shutdown() {
        this._keepReading = false;
    }

    String getHandlerStatus() {
        StringBuilder rv = new StringBuilder();
        rv.append("Handlers: ").append(this._handlers.length);
        for (int i = 0; i < this._handlers.length; ++i) {
            Handler handler = this._handlers[i];
            rv.append(" handler ").append(i).append(" state: ").append(handler._state);
        }
        return rv.toString();
    }

    int getHandlerCount() {
        return this._handlers.length;
    }

    private class Handler
    implements Runnable {
        private final UDPPacketReader _reader;
        public int _state;

        public Handler() {
            this._reader = new UDPPacketReader(PacketHandler.this._context);
        }

        public void run() {
            this._state = 1;
            while (PacketHandler.this._keepReading) {
                long handleStart;
                long queueTime;
                UDPPacket packet;
                block14: {
                    this._state = 2;
                    packet = PacketHandler.this._endpoint.receive();
                    this._state = 3;
                    if (packet == null) break;
                    packet.received();
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Received the packet " + packet);
                    }
                    this._state = 4;
                    queueTime = packet.getLifetime();
                    handleStart = PacketHandler.this._context.clock().now();
                    try {
                        this._state = 5;
                        this.handlePacket(this._reader, packet);
                        this._state = 6;
                    }
                    catch (Exception e) {
                        this._state = 7;
                        if (!PacketHandler.this._log.shouldLog(40)) break block14;
                        PacketHandler.this._log.error("Crazy error handling a packet: " + packet, (Throwable)e);
                    }
                }
                long handleTime = PacketHandler.this._context.clock().now() - handleStart;
                packet.afterHandling();
                PacketHandler.this._context.statManager().addRateData("udp.handleTime", handleTime, packet.getLifetime());
                PacketHandler.this._context.statManager().addRateData("udp.queueTime", queueTime, packet.getLifetime());
                this._state = 8;
                if (PacketHandler.this._log.shouldLog(20)) {
                    PacketHandler.this._log.info("Done receiving the packet " + packet);
                }
                if (handleTime > 1000L && PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Took " + handleTime + " to process the packet " + packet + ": " + this._reader);
                }
                long enqueueTime = packet.getEnqueueTime();
                long recvTime = packet.getReceivedTime();
                long beforeValidateTime = packet.getBeforeValidate();
                long afterValidateTime = packet.getAfterValidate();
                int validateCount = packet.getValidateCount();
                long timeToDequeue = recvTime - enqueueTime;
                long timeToValidate = 0L;
                long authTime = 0L;
                if (afterValidateTime > 0L) {
                    timeToValidate = afterValidateTime - enqueueTime;
                    authTime = afterValidateTime - beforeValidateTime;
                }
                if (timeToDequeue > 50L) {
                    PacketHandler.this._context.statManager().addRateData("udp.packetDequeueTime", timeToDequeue, timeToDequeue);
                }
                if (authTime > 50L) {
                    PacketHandler.this._context.statManager().addRateData("udp.packetAuthRecvTime", authTime, beforeValidateTime - recvTime);
                }
                if (afterValidateTime > 0L) {
                    PacketHandler.this._context.statManager().addRateData("udp.packetVerifyTime", timeToValidate, authTime);
                    if (timeToValidate > 50L) {
                        PacketHandler.this._context.statManager().addRateData("udp.packetVerifyTimeSlow", timeToValidate, authTime);
                    }
                }
                if (validateCount > 1) {
                    PacketHandler.this._context.statManager().addRateData("udp.packetValidateMultipleCount", (long)validateCount, timeToValidate);
                } else if (validateCount <= 0) {
                    PacketHandler.this._context.statManager().addRateData("udp.packetNoValidationLifetime", packet.getLifetime(), 0L);
                }
                packet.release();
                this._state = 9;
            }
        }

        private void handlePacket(UDPPacketReader reader, UDPPacket packet) {
            if (packet == null) {
                return;
            }
            this._state = 10;
            RemoteHostId rem = packet.getRemoteHost();
            PeerState state = PacketHandler.this._transport.getPeerState(rem);
            if (state == null) {
                if (PacketHandler.this._log.shouldLog(10)) {
                    PacketHandler.this._log.debug("Packet received is not for a connected peer");
                }
                this._state = 11;
                InboundEstablishState est = PacketHandler.this._establisher.getInboundState(rem);
                if (est != null) {
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Packet received IS for an inbound establishment");
                    }
                    this._state = 12;
                    this.receivePacket(reader, packet, est);
                } else {
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Packet received is not for an inbound establishment");
                    }
                    this._state = 13;
                    OutboundEstablishState oest = PacketHandler.this._establisher.getOutboundState(rem);
                    if (oest != null) {
                        if (PacketHandler.this._log.shouldLog(10)) {
                            PacketHandler.this._log.debug("Packet received IS for an outbound establishment");
                        }
                        this._state = 14;
                        this.receivePacket(reader, packet, oest);
                    } else {
                        if (PacketHandler.this._log.shouldLog(10)) {
                            PacketHandler.this._log.debug("Packet received is not for an inbound or outbound establishment");
                        }
                        this._state = 15;
                        this.receivePacket(reader, packet, (short)3);
                    }
                }
            } else {
                if (PacketHandler.this._log.shouldLog(10)) {
                    PacketHandler.this._log.debug("Packet received IS for an existing peer");
                }
                this._state = 16;
                this.receivePacket(reader, packet, state);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void receivePacket(UDPPacketReader reader, UDPPacket packet, PeerState state) {
            block11: {
                this._state = 17;
                boolean isValid = packet.validate(state.getCurrentMACKey());
                if (!isValid) {
                    this._state = 18;
                    if (state.getNextMACKey() != null) {
                        isValid = packet.validate(state.getNextMACKey());
                    }
                    if (!isValid) {
                        this._state = 19;
                        if (PacketHandler.this._log.shouldLog(20)) {
                            PacketHandler.this._log.info("Failed validation with existing con, trying as new con: " + packet);
                        }
                        if (isValid = packet.validate(PacketHandler.this._transport.getIntroKey())) {
                            this._state = 20;
                            if (PacketHandler.this._log.shouldLog(10)) {
                                PacketHandler.this._log.debug("Validation with existing con failed, but validation as reestablish/stray passed");
                            }
                            packet.decrypt(PacketHandler.this._transport.getIntroKey());
                            break block11;
                        } else {
                            this._state = 21;
                            InboundEstablishState est = PacketHandler.this._establisher.getInboundState(packet.getRemoteHost());
                            if (est != null) {
                                if (PacketHandler.this._log.shouldLog(10)) {
                                    PacketHandler.this._log.debug("Packet from an existing peer IS for an inbound establishment");
                                }
                                this._state = 22;
                                this.receivePacket(reader, packet, est, false);
                                return;
                            }
                            if (PacketHandler.this._log.shouldLog(30)) {
                                PacketHandler.this._log.warn("Validation with existing con failed, and validation as reestablish failed too.  DROP");
                            }
                            PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidReestablish", packet.getLifetime(), packet.getExpiration());
                            return;
                        }
                    }
                    this._state = 23;
                    packet.decrypt(state.getNextCipherKey());
                } else {
                    this._state = 24;
                    packet.decrypt(state.getCurrentCipherKey());
                }
            }
            this._state = 25;
            this.handlePacket(reader, packet, state, null, null);
            this._state = 26;
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, short peerType) {
            this._state = 27;
            boolean isValid = packet.validate(PacketHandler.this._transport.getIntroKey());
            if (!isValid) {
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Invalid introduction packet received: " + packet, (Throwable)new Exception("path"));
                }
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish", packet.getLifetime(), packet.getExpiration());
                switch (peerType) {
                    case 2: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.inbound", packet.getLifetime(), packet.getTimeSinceReceived());
                        break;
                    }
                    case 1: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.outbound", packet.getLifetime(), packet.getTimeSinceReceived());
                        break;
                    }
                    case 3: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.new", packet.getLifetime(), packet.getTimeSinceReceived());
                    }
                }
                this._state = 28;
                return;
            }
            if (PacketHandler.this._log.shouldLog(10)) {
                PacketHandler.this._log.debug("Valid introduction packet received: " + packet);
            }
            this._state = 29;
            packet.decrypt(PacketHandler.this._transport.getIntroKey());
            this.handlePacket(reader, packet, null, null, null);
            this._state = 30;
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, InboundEstablishState state) {
            this.receivePacket(reader, packet, state, true);
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, InboundEstablishState state, boolean allowFallback) {
            this._state = 31;
            if (PacketHandler.this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Attempting to receive a packet on a known inbound state: ");
                buf.append(state);
                buf.append(" MAC key: ").append(state.getMACKey());
                buf.append(" intro key: ").append(PacketHandler.this._transport.getIntroKey());
                PacketHandler.this._log.debug(buf.toString());
            }
            boolean isValid = false;
            if (state.getMACKey() != null) {
                isValid = packet.validate(state.getMACKey());
                if (isValid) {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Valid introduction packet received for inbound con: " + packet);
                    }
                    this._state = 32;
                    packet.decrypt(state.getCipherKey());
                    this.handlePacket(reader, packet, null, null, null);
                    return;
                }
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Invalid introduction packet received for inbound con, falling back: " + packet);
                }
                this._state = 33;
            }
            if (allowFallback) {
                this._state = 34;
                this.receivePacket(reader, packet, (short)2);
            } else {
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidInboundEstablish", packet.getLifetime(), packet.getExpiration());
            }
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, OutboundEstablishState state) {
            this._state = 35;
            if (PacketHandler.this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Attempting to receive a packet on a known outbound state: ");
                buf.append(state);
                buf.append(" MAC key: ").append(state.getMACKey());
                buf.append(" intro key: ").append(state.getIntroKey());
                PacketHandler.this._log.debug(buf.toString());
            }
            boolean isValid = false;
            if (state.getMACKey() != null) {
                this._state = 36;
                isValid = packet.validate(state.getMACKey());
                if (isValid) {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Valid introduction packet received for outbound established con: " + packet);
                    }
                    this._state = 37;
                    packet.decrypt(state.getCipherKey());
                    this.handlePacket(reader, packet, null, state, null);
                    this._state = 38;
                    return;
                }
            }
            if (isValid = packet.validate(state.getIntroKey())) {
                if (PacketHandler.this._log.shouldLog(20)) {
                    PacketHandler.this._log.info("Valid introduction packet received for outbound established con with old intro key: " + packet);
                }
                this._state = 39;
                packet.decrypt(state.getIntroKey());
                this.handlePacket(reader, packet, null, state, null);
                this._state = 40;
                return;
            }
            if (PacketHandler.this._log.shouldLog(30)) {
                PacketHandler.this._log.warn("Invalid introduction packet received for outbound established con with old intro key, falling back: " + packet);
            }
            this._state = 41;
            this.receivePacket(reader, packet, (short)1);
            this._state = 42;
        }

        private void handlePacket(UDPPacketReader reader, UDPPacket packet, PeerState state, OutboundEstablishState outState, InboundEstablishState inState) {
            this._state = 43;
            reader.initialize(packet);
            this._state = 44;
            long recvOn = packet.getBegin();
            long sendOn = reader.readTimestamp() * 1000L;
            long skew = recvOn - sendOn;
            if (state != null) {
                if (PacketHandler.this._log.shouldLog(10)) {
                    PacketHandler.this._log.debug("Received packet from " + state.getRemoteHostId().toString() + " with skew " + skew);
                }
                state.adjustClockSkew(skew);
            }
            PacketHandler.this._context.statManager().addRateData("udp.receivePacketSkew", skew, packet.getLifetime());
            if (!PacketHandler.this._context.clock().getUpdatedSuccessfully()) {
                PacketHandler.this._context.clock().setOffset(0L - skew, true);
                if (skew != 0L) {
                    PacketHandler.this._log.logAlways(30, "NTP failure, UDP adjusting clock by " + DataHelper.formatDuration((long)Math.abs(skew)));
                }
            }
            if (skew > 90000L) {
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Packet too far in the past: " + new Date(sendOn) + ": " + packet);
                }
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidSkew", skew, packet.getExpiration());
                return;
            }
            if (skew < -90000L) {
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Packet too far in the future: " + new Date(sendOn) + ": " + packet);
                }
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidSkew", 0L - skew, packet.getExpiration());
                return;
            }
            this._state = 45;
            RemoteHostId from = packet.getRemoteHost();
            this._state = 46;
            switch (reader.readPayloadType()) {
                case 0: {
                    this._state = 47;
                    PacketHandler.this._establisher.receiveSessionRequest(from, reader);
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.sessionRequest", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 2: {
                    this._state = 48;
                    PacketHandler.this._establisher.receiveSessionConfirmed(from, reader);
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.sessionConfirmed", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 1: {
                    this._state = 49;
                    PacketHandler.this._establisher.receiveSessionCreated(from, reader);
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.sessionCreated", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 6: {
                    this._state = 50;
                    if (outState != null) {
                        state = PacketHandler.this._establisher.receiveData(outState);
                    }
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Received new DATA packet from " + state + ": " + packet);
                    }
                    if (state != null) {
                        UDPPacketReader.DataReader dr = reader.getDataReader();
                        if (PacketHandler.this._log.shouldLog(20)) {
                            StringBuilder msg = new StringBuilder();
                            msg.append("Receive ").append(System.identityHashCode(packet));
                            msg.append(" from ").append(state.getRemotePeer().toBase64()).append(" ").append(state.getRemoteHostId());
                            for (int i = 0; i < dr.readFragmentCount(); ++i) {
                                msg.append(" msg ").append(dr.readMessageId(i));
                                msg.append(":").append(dr.readMessageFragmentNum(i));
                                if (!dr.readMessageIsLast(i)) continue;
                                msg.append("*");
                            }
                            msg.append(": ").append(dr.toString());
                            PacketHandler.this._log.info(msg.toString());
                        }
                        packet.beforeReceiveFragments();
                        PacketHandler.this._inbound.receiveData(state, dr);
                        PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataKnown", (long)packet.getPacket().getLength(), packet.getLifetime());
                        if (dr.readFragmentCount() > 0) break;
                        PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataKnownAck", (long)packet.getPacket().getLength(), packet.getLifetime());
                        break;
                    }
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataUnknown", (long)packet.getPacket().getLength(), packet.getLifetime());
                    UDPPacketReader.DataReader dr = reader.getDataReader();
                    if (dr.readFragmentCount() > 0) break;
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataUnknownAck", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 7: {
                    this._state = 51;
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Received test packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._testManager.receiveTest(from, reader);
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.test", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 3: {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Received relay request packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._introManager.receiveRelayRequest(from, reader);
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.relayRequest", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 5: {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Received relay intro packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._introManager.receiveRelayIntro(from, reader);
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.relayIntro", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 4: {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Received relay response packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._establisher.receiveRelayResponse(from, reader);
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.relayResponse", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 8: {
                    this._state = 53;
                    if (outState != null) {
                        PacketHandler.this._establisher.receiveSessionDestroy(from, outState);
                        break;
                    }
                    if (state != null) {
                        PacketHandler.this._establisher.receiveSessionDestroy(from, state);
                        break;
                    }
                    PacketHandler.this._establisher.receiveSessionDestroy(from);
                    break;
                }
                default: {
                    this._state = 52;
                    if (PacketHandler.this._log.shouldLog(30)) {
                        PacketHandler.this._log.warn("Unknown payload type: " + reader.readPayloadType());
                    }
                    PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidUnknown", packet.getLifetime(), packet.getExpiration());
                    return;
                }
            }
        }
    }
}

