/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.util.ArrayList;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class Writer {
    private final Log _log;
    private final List<NTCPConnection> _pendingConnections;
    private final List<NTCPConnection> _liveWrites;
    private final List<NTCPConnection> _writeAfterLive;
    private final List<Runner> _runners;

    public Writer(RouterContext ctx) {
        this._log = ctx.logManager().getLog(this.getClass());
        this._pendingConnections = new ArrayList<NTCPConnection>(16);
        this._runners = new ArrayList<Runner>(5);
        this._liveWrites = new ArrayList<NTCPConnection>(5);
        this._writeAfterLive = new ArrayList<NTCPConnection>(5);
    }

    public void startWriting(int numWriters) {
        for (int i = 1; i <= numWriters; ++i) {
            Runner r = new Runner();
            I2PThread t = new I2PThread((Runnable)r, "NTCP writer " + i + '/' + numWriters, true);
            this._runners.add(r);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWriting() {
        while (!this._runners.isEmpty()) {
            Runner r = this._runners.remove(0);
            r.stop();
        }
        List<NTCPConnection> list = this._pendingConnections;
        synchronized (list) {
            this._writeAfterLive.clear();
            this._pendingConnections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsWrite(NTCPConnection con, String source) {
        boolean already = false;
        boolean pending = false;
        List<NTCPConnection> list = this._pendingConnections;
        synchronized (list) {
            if (this._liveWrites.contains(con)) {
                if (!this._writeAfterLive.contains(con)) {
                    this._writeAfterLive.add(con);
                }
                already = true;
            } else if (!this._pendingConnections.contains(con)) {
                this._pendingConnections.add(con);
                pending = true;
            }
            this._pendingConnections.notifyAll();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("wantsWrite: " + con + " already live? " + already + " added to pending? " + pending + ": " + source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(NTCPConnection con) {
        List<NTCPConnection> list = this._pendingConnections;
        synchronized (list) {
            this._writeAfterLive.remove(con);
            this._pendingConnections.remove(con);
            this._pendingConnections.notifyAll();
        }
    }

    private class Runner
    implements Runnable {
        private boolean _stop = false;

        public void stop() {
            this._stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Writer.this._log.shouldLog(20)) {
                Writer.this._log.info("Starting writer");
            }
            NTCPConnection con = null;
            while (!this._stop) {
                try {
                    List list = Writer.this._pendingConnections;
                    synchronized (list) {
                        boolean keepWriting;
                        boolean bl = keepWriting = con != null && Writer.this._writeAfterLive.remove(con);
                        if (keepWriting) {
                            if (Writer.this._log.shouldLog(10)) {
                                Writer.this._log.debug("Keep writing on the same connection: " + con);
                            }
                        } else {
                            Writer.this._liveWrites.remove(con);
                            con = null;
                            if (Writer.this._pendingConnections.isEmpty()) {
                                if (Writer.this._log.shouldLog(10)) {
                                    Writer.this._log.debug("Done writing, but nothing pending, so wait");
                                }
                                Writer.this._pendingConnections.wait();
                            } else {
                                con = (NTCPConnection)Writer.this._pendingConnections.remove(0);
                                Writer.this._liveWrites.add(con);
                                if (Writer.this._log.shouldLog(10)) {
                                    Writer.this._log.debug("Switch to writing on: " + con);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this._stop || con == null) continue;
                try {
                    if (Writer.this._log.shouldLog(10)) {
                        Writer.this._log.debug("Prepare next write on: " + con);
                    }
                    con.prepareNextWrite();
                }
                catch (RuntimeException re) {
                    Writer.this._log.log(50, "Error in the ntcp writer", (Throwable)re);
                }
            }
            if (Writer.this._log.shouldLog(20)) {
                Writer.this._log.info("Stopping writer");
            }
        }
    }
}

