/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.router.Router;
import net.i2p.router.RouterClock;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class Restarter
implements Runnable {
    private final RouterContext _context;

    public Restarter(RouterContext ctx) {
        this._context = ctx;
    }

    public void run() {
        Log log = this._context.logManager().getLog(Router.class);
        log.error("Stopping the router for a restart...");
        log.logAlways(30, "Stopping the client manager");
        try {
            this._context.clientManager().shutdown("Router restart");
        }
        catch (Throwable t) {
            log.log(50, "Error stopping the client manager", t);
        }
        log.logAlways(30, "Stopping the comm system");
        this._context.bandwidthLimiter().reinitialize();
        try {
            this._context.messageRegistry().restart();
        }
        catch (Throwable t) {
            log.log(50, "Error restarting the message registry", t);
        }
        try {
            this._context.commSystem().restart();
        }
        catch (Throwable t) {
            log.log(50, "Error restarting the comm system", t);
        }
        log.logAlways(30, "Stopping the tunnel manager");
        try {
            this._context.tunnelManager().restart();
        }
        catch (Throwable t) {
            log.log(50, "Error restarting the tunnel manager", t);
        }
        log.logAlways(30, "Router teardown complete, restarting the router...");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        log.logAlways(30, "Restarting the comm system");
        log.logAlways(30, "Restarting the tunnel manager");
        log.logAlways(30, "Restarting the client manager");
        try {
            this._context.clientMessagePool().restart();
        }
        catch (Throwable t) {
            log.log(50, "Error restarting the CMP", t);
        }
        try {
            this._context.clientManager().startup();
        }
        catch (Throwable t) {
            log.log(50, "Error starting the client manager", t);
        }
        this._context.router().setIsAlive();
        this._context.router().rebuildRouterInfo();
        log.logAlways(30, "Restart complete");
        ((RouterClock)this._context.clock()).addShiftListener(this._context.router());
    }
}

