/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class OOMListener
implements I2PThread.OOMEventListener {
    private final RouterContext _context;

    public OOMListener(RouterContext ctx) {
        this._context = ctx;
    }

    public void outOfMemory(OutOfMemoryError oom) {
        Router.clearCaches();
        Log log = this._context.logManager().getLog(Router.class);
        log.log(50, "Thread ran out of memory, shutting down I2P", (Throwable)oom);
        if (this._context.router().isFinalShutdownInProgress()) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            try {
                log.log(50, "free mem: " + Runtime.getRuntime().freeMemory() + " total mem: " + Runtime.getRuntime().totalMemory());
                break;
            }
            catch (OutOfMemoryError oome) {
                continue;
            }
        }
        log.log(50, "To prevent future shutdowns, increase wrapper.java.maxmemory in $I2P/wrapper.config");
        this._context.router().shutdown(10);
    }
}

