/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.reseed;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.reseed.ReseedChecker;
import net.i2p.router.util.RFC822Date;
import net.i2p.util.EepGet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SSLEepGet;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.Translate;

public class Reseeder {
    private final RouterContext _context;
    private final Log _log;
    private final ReseedChecker _checker;
    private static final long MAX_RESEED_RESPONSE_SIZE = 0x200000L;
    private static final int MAX_TIME_PER_HOST = 420000;
    public static final String DEFAULT_SEED_URL = "http://netdb.i2p2.de/,http://reseed.i2p-projekt.de/,http://forum.i2p2.de/netdb/,http://euve5653.vserver.de/netDb/,http://cowpuncher.drollette.com/netdb/,http://75.145.125.59/netDb/,http://i2p.mooo.com/netDb/";
    public static final String DEFAULT_SSL_SEED_URL = "https://netdb.i2p2.de/,https://forum.i2p2.de/netdb/,https://euve5653.vserver.de/netDb/,https://reseed.i2p-projekt.de/,https://cowpuncher.drollette.com/netdb/,https://75.145.125.59/netDb/,https://i2p.mooo.com/netDb/";
    public static final String PROP_PROXY_HOST = "router.reseedProxyHost";
    public static final String PROP_PROXY_PORT = "router.reseedProxyPort";
    public static final String PROP_PROXY_ENABLE = "router.reseedProxyEnable";
    public static final String PROP_SSL_DISABLE = "router.reseedSSLDisable";
    public static final String PROP_SSL_REQUIRED = "router.reseedSSLRequired";
    public static final String PROP_RESEED_URL = "i2p.reseedURL";
    public static final String PROP_PROXY_USERNAME = "router.reseedProxy.username";
    public static final String PROP_PROXY_PASSWORD = "router.reseedProxy.password";
    public static final String PROP_PROXY_AUTH_ENABLE = "router.reseedProxy.authEnable";
    public static final String PROP_SPROXY_HOST = "router.reseedSSLProxyHost";
    public static final String PROP_SPROXY_PORT = "router.reseedSSLProxyPort";
    public static final String PROP_SPROXY_ENABLE = "router.reseedSSLProxyEnable";
    public static final String PROP_SPROXY_USERNAME = "router.reseedSSLProxy.username";
    public static final String PROP_SPROXY_PASSWORD = "router.reseedSSLProxy.password";
    public static final String PROP_SPROXY_AUTH_ENABLE = "router.reseedSSLProxy.authEnable";
    public static final String PROP_DISABLE = "router.reseedDisable";
    private static final String ROUTERINFO_PREFIX = "routerInfo-";
    private static final String ROUTERINFO_SUFFIX = ".dat";
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    Reseeder(RouterContext ctx, ReseedChecker rc) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(Reseeder.class);
        this._checker = rc;
    }

    void requestReseed() {
        ReseedRunner reseedRunner = new ReseedRunner();
        I2PAppThread reseed = new I2PAppThread((Runnable)reseedRunner, "Reseed", true);
        reseed.start();
    }

    private String _(String key) {
        return Translate.getString((String)key, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private String _(String s, Object o) {
        return Translate.getString((String)s, (Object)o, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private String _(String s, Object o, Object o2) {
        return Translate.getString((String)s, (Object)o, (Object)o2, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private String ngettext(String s, String p, int n) {
        return Translate.getString((int)n, (String)s, (String)p, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private class ReseedRunner
    implements Runnable,
    EepGet.StatusListener {
        private boolean _isRunning;
        private String _proxyHost;
        private int _proxyPort;
        private SSLEepGet.SSLState _sslState;
        private int _gotDate;
        private long _attemptStarted;
        private static final int MAX_DATE_SETS = 2;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.run2();
            }
            finally {
                Reseeder.this._checker.done();
            }
        }

        private void run2() {
            this._isRunning = true;
            Reseeder.this._checker.setError("");
            Reseeder.this._checker.setStatus(Reseeder.this._("Reseeding"));
            if (Reseeder.this._context.getBooleanProperty(Reseeder.PROP_PROXY_ENABLE)) {
                this._proxyHost = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_HOST);
                this._proxyPort = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_PORT, -1);
            }
            System.out.println("Reseed start");
            int total = this.reseed(false);
            if (total >= 50) {
                System.out.println("Reseed complete, " + total + " received");
                Reseeder.this._checker.setError("");
            } else if (total > 0) {
                System.out.println("Reseed complete, only " + total + " received");
                Reseeder.this._checker.setError(Reseeder.this.ngettext("Reseed fetched only 1 router.", "Reseed fetched only {0} routers.", total));
            } else {
                System.out.println("Reseed failed, check network connection");
                System.out.println("Ensure that nothing blocks outbound HTTP, check the logs, and if nothing helps, read the FAQ about reseeding manually.");
                Reseeder.this._checker.setError(Reseeder.this._("Reseed failed.") + ' ' + Reseeder.this._("See {0} for help.", "<a target=\"_top\" href=\"/configreseed\">" + Reseeder.this._("reseed configuration page") + "</a>"));
            }
            this._isRunning = false;
            Reseeder.this._checker.setStatus("");
        }

        public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
            if (Reseeder.this._log.shouldLog(40)) {
                Reseeder.this._log.error("EepGet failed on " + url, (Throwable)cause);
            }
        }

        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        }

        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        }

        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        }

        public void headerReceived(String url, int attemptNum, String key, String val) {
            if (this._gotDate < 2 && "date".equals(key.toLowerCase(Locale.US)) && this._attemptStarted > 0L) {
                long timeRcvd = System.currentTimeMillis();
                long serverTime = RFC822Date.parse822Date(val);
                if (serverTime > 0L) {
                    long now = serverTime + 500L + (timeRcvd - this._attemptStarted) / 2L;
                    long offset = now - Reseeder.this._context.clock().now();
                    if (Reseeder.this._context.clock().getUpdatedSuccessfully()) {
                        if (this._gotDate > 0) {
                            Reseeder.this._context.clock().setNow(now, 6);
                        } else {
                            Reseeder.this._context.clock().setNow(now, 7);
                        }
                        if (Reseeder.this._log.shouldLog(30)) {
                            Reseeder.this._log.warn("Reseed adjusting clock by " + DataHelper.formatDuration((long)Math.abs(offset)));
                        }
                    } else {
                        Reseeder.this._context.clock().setNow(now, 7);
                        Reseeder.this._log.logAlways(30, "NTP failure, Reseed adjusting clock by " + DataHelper.formatDuration((long)Math.abs(offset)));
                    }
                    ++this._gotDate;
                }
            }
        }

        public void attempting(String url) {
            if (this._gotDate < 2) {
                this._attemptStarted = System.currentTimeMillis();
            }
        }

        private int reseed(boolean echoStatus) {
            ArrayList<String> URLList = new ArrayList<String>();
            String URLs = Reseeder.this._context.getProperty(Reseeder.PROP_RESEED_URL);
            boolean defaulted = URLs == null;
            boolean SSLDisable = Reseeder.this._context.getBooleanProperty(Reseeder.PROP_SSL_DISABLE);
            if (defaulted) {
                URLs = SSLDisable ? Reseeder.DEFAULT_SEED_URL : Reseeder.DEFAULT_SSL_SEED_URL;
            }
            StringTokenizer tok = new StringTokenizer(URLs, " ,");
            while (tok.hasMoreTokens()) {
                URLList.add(tok.nextToken().trim());
            }
            Collections.shuffle(URLList, (Random)Reseeder.this._context.random());
            if (defaulted && !SSLDisable) {
                ArrayList<String> URLList2 = new ArrayList<String>();
                tok = new StringTokenizer(Reseeder.DEFAULT_SEED_URL, " ,");
                while (tok.hasMoreTokens()) {
                    URLList2.add(tok.nextToken().trim());
                }
                Collections.shuffle(URLList2, (Random)Reseeder.this._context.random());
                URLList.addAll(URLList2);
            }
            int total = 0;
            for (int i = 0; i < URLList.size() && this._isRunning; ++i) {
                String url = (String)URLList.get(i);
                int dl = this.reseedOne(url, echoStatus);
                if (dl <= 0) continue;
                total += dl;
                String alt = url.startsWith("http://") ? url.replace("http://", "https://") : url.replace("https://", "http://");
                int idx = URLList.indexOf(alt);
                if (idx <= i) continue;
                URLList.remove(i);
            }
            return total;
        }

        private int reseedOne(String seedURL, boolean echoStatus) {
            try {
                int end;
                int start;
                long timeLimit = System.currentTimeMillis() + 420000L;
                Reseeder.this._checker.setStatus(Reseeder.this._("Reseeding: fetching seed URL."));
                System.err.println("Reseeding from " + seedURL);
                URL dir = new URL(seedURL);
                byte[] contentRaw = this.readURL(dir);
                if (contentRaw == null) {
                    Reseeder.this._log.warn("Failed reading seed URL: " + seedURL);
                    System.err.println("Reseed got no router infos from " + seedURL);
                    return 0;
                }
                String content = new String(contentRaw);
                HashSet<String> urls = new HashSet<String>(1024);
                Hash ourHash = Reseeder.this._context.routerHash();
                String ourB64 = ourHash != null ? ourHash.toBase64() : null;
                int cur = 0;
                int total = 0;
                while (total++ < 1000 && ((start = content.indexOf("href=\"routerInfo-", cur)) >= 0 || (start = content.indexOf("HREF=\"routerInfo-", cur)) >= 0) && (end = content.indexOf(".dat\">", start)) >= 0) {
                    if (start - end > 200) {
                        cur = end + 1;
                        continue;
                    }
                    String name = content.substring(start + "href=\"routerInfo-".length(), end);
                    if (ourB64 == null || !name.contains(ourB64)) {
                        urls.add(name);
                    } else if (Reseeder.this._log.shouldLog(20)) {
                        Reseeder.this._log.info("Skipping our own RI");
                    }
                    cur = end + 1;
                }
                if (total <= 0) {
                    Reseeder.this._log.warn("Read " + contentRaw.length + " bytes from seed " + seedURL + ", but found no routerInfo URLs.");
                    System.err.println("Reseed got no router infos from " + seedURL);
                    return 0;
                }
                ArrayList urlList = new ArrayList(urls);
                Collections.shuffle(urlList, (Random)Reseeder.this._context.random());
                int fetched = 0;
                int errors = 0;
                Iterator iter = urlList.iterator();
                while (iter.hasNext() && fetched < 200 && System.currentTimeMillis() < timeLimit) {
                    try {
                        Reseeder.this._checker.setStatus(Reseeder.this._("Reseeding: fetching router info from seed URL ({0} successful, {1} errors).", fetched, errors));
                        if (!this.fetchSeed(seedURL, (String)iter.next())) continue;
                        ++fetched;
                        if (echoStatus) {
                            System.out.print(".");
                            if (fetched % 60 == 0) {
                                System.out.println();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (Reseeder.this._log.shouldLog(20)) {
                            Reseeder.this._log.info("Failed fetch", (Throwable)e);
                        }
                        ++errors;
                    }
                    if (errors < 50 && (errors < 10 || fetched > 1)) continue;
                }
                System.err.println("Reseed got " + fetched + " router infos from " + seedURL + " with " + errors + " errors");
                if (fetched > 0) {
                    Reseeder.this._context.netDb().rescan();
                }
                if (fetched >= 100) {
                    this._isRunning = false;
                }
                return fetched;
            }
            catch (Throwable t) {
                Reseeder.this._log.warn("Error reseeding", t);
                System.err.println("Reseed got no router infos from " + seedURL);
                return 0;
            }
        }

        private boolean fetchSeed(String seedURL, String peer) throws IOException, URISyntaxException {
            URI uri = new URI(peer);
            String b64 = uri.getPath();
            if (b64 == null) {
                throw new IOException("bad hash " + peer);
            }
            byte[] hash = Base64.decode((String)b64);
            if (hash == null || hash.length != 32) {
                throw new IOException("bad hash " + peer);
            }
            Hash ourHash = Reseeder.this._context.routerHash();
            if (ourHash != null && DataHelper.eq((byte[])hash, (byte[])ourHash.getData())) {
                return false;
            }
            URL url = new URL(seedURL + (seedURL.endsWith("/") ? "" : "/") + Reseeder.ROUTERINFO_PREFIX + peer + Reseeder.ROUTERINFO_SUFFIX);
            byte[] data = this.readURL(url);
            if (data == null || data.length <= 0) {
                throw new IOException("Failed fetch of " + url);
            }
            return this.writeSeed(b64, data);
        }

        private byte[] readURL(URL url) throws IOException {
            SSLEepGet get;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            boolean ssl = url.toString().startsWith("https");
            if (ssl) {
                SSLEepGet sslget;
                if (this._sslState == null) {
                    sslget = new SSLEepGet(I2PAppContext.getGlobalContext(), (OutputStream)baos, url.toString());
                    this._sslState = sslget.getSSLState();
                } else {
                    sslget = new SSLEepGet(I2PAppContext.getGlobalContext(), (OutputStream)baos, url.toString(), this._sslState);
                }
                get = sslget;
            } else {
                boolean shouldProxy = this._proxyHost != null && this._proxyHost.length() > 0 && this._proxyPort > 0;
                get = new EepGet(I2PAppContext.getGlobalContext(), shouldProxy, this._proxyHost, this._proxyPort, 0, 0L, 0x200000L, null, (OutputStream)baos, url.toString(), false, null, null);
                if (shouldProxy && Reseeder.this._context.getBooleanProperty(Reseeder.PROP_PROXY_AUTH_ENABLE)) {
                    String user = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_USERNAME);
                    String pass = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_PASSWORD);
                    if (user != null && user.length() > 0 && pass != null && pass.length() > 0) {
                        get.addAuthorization(user, pass);
                    }
                }
            }
            get.addStatusListener((EepGet.StatusListener)this);
            if (get.fetch()) {
                return baos.toByteArray();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean writeSeed(String name, byte[] data) throws IOException {
            File file;
            String dirName = "netDb";
            SecureDirectory netDbDir = new SecureDirectory(Reseeder.this._context.getRouterDir(), dirName);
            if (!netDbDir.exists()) {
                netDbDir.mkdirs();
            }
            if ((file = new File((File)netDbDir, Reseeder.ROUTERINFO_PREFIX + name + Reseeder.ROUTERINFO_SUFFIX)).exists() && file.lastModified() > Reseeder.this._context.clock().now() - 3600000L) {
                if (Reseeder.this._log.shouldLog(20)) {
                    Reseeder.this._log.info("Skipping RI, ours is recent: " + file);
                }
                return false;
            }
            SecureFileOutputStream fos = null;
            try {
                fos = new SecureFileOutputStream(file);
                fos.write(data);
                if (Reseeder.this._log.shouldLog(20)) {
                    Reseeder.this._log.info("Saved RI (" + data.length + " bytes) to " + file);
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ioe) {}
            }
            return true;
        }
    }
}

