/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.reseed;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.reseed.Reseeder;
import net.i2p.util.Log;

public class ReseedChecker {
    private final RouterContext _context;
    private final Log _log;
    private final AtomicBoolean _inProgress = new AtomicBoolean();
    private String _lastStatus = "";
    private String _lastError = "";
    private static final int MINIMUM = 15;

    public ReseedChecker(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(ReseedChecker.class);
    }

    public boolean checkReseed(int count) {
        String s;
        if (count >= 15) {
            return false;
        }
        if (this._context.getBooleanProperty("router.reseedDisable")) {
            String s2;
            this._lastError = s2 = "Only " + count + " peers remaining but reseed disabled by configuration";
            this._log.logAlways(30, s2);
            return false;
        }
        File noReseedFile = new File(new File(System.getProperty("user.home")), ".i2pnoreseed");
        File noReseedFileAlt1 = new File(new File(System.getProperty("user.home")), "noreseed.i2p");
        File noReseedFileAlt2 = new File(this._context.getConfigDir(), ".i2pnoreseed");
        File noReseedFileAlt3 = new File(this._context.getConfigDir(), "noreseed.i2p");
        if (!(noReseedFile.exists() || noReseedFileAlt1.exists() || noReseedFileAlt2.exists() || noReseedFileAlt3.exists())) {
            if (count <= 1) {
                this._log.logAlways(20, "Downloading peer router information for a new I2P installation");
            } else {
                this._log.logAlways(30, "Very few known peers remaining - reseeding now");
            }
            return this.requestReseed();
        }
        this._lastError = s = "Only " + count + " peers remaining but reseed disabled by config file";
        this._log.logAlways(30, s);
        return false;
    }

    public boolean requestReseed() {
        if (this._inProgress.compareAndSet(false, true)) {
            try {
                Reseeder reseeder = new Reseeder(this._context, this);
                reseeder.requestReseed();
                return true;
            }
            catch (Throwable t) {
                this._log.error("Reseed failed to start", t);
                this.done();
                return false;
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Reseed already in prgress");
        }
        return false;
    }

    public boolean inProgress() {
        return this._inProgress.get();
    }

    void done() {
        this._inProgress.set(false);
    }

    public String getStatus() {
        return this._lastStatus;
    }

    void setStatus(String s) {
        this._lastStatus = s;
    }

    public String getError() {
        return this._lastError;
    }

    void setError(String s) {
        this._lastError = s;
    }
}

