/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.SearchState;
import net.i2p.util.Log;

class SearchMessageSelector
implements MessageSelector {
    private Log _log;
    private RouterContext _context;
    private static int __searchSelectorId = 0;
    private Hash _peer;
    private boolean _found;
    private int _id;
    private long _exp;
    private SearchState _state;

    public SearchMessageSelector(RouterContext context, RouterInfo peer, long expiration, SearchState state) {
        this._context = context;
        this._log = context.logManager().getLog(SearchMessageSelector.class);
        this._peer = peer.getIdentity().getHash();
        this._found = false;
        this._exp = expiration;
        this._state = state;
        this._id = ++__searchSelectorId;
        if (this._log.shouldLog(10)) {
            this._log.debug("[" + this._id + "] Created: " + this.toString());
        }
    }

    public String toString() {
        return "Search selector [" + this._id + "] looking for a reply from " + this._peer + " with regards to " + this._state.getTarget();
    }

    public boolean continueMatching() {
        boolean expired;
        boolean bl = expired = this._context.clock().now() > this._exp;
        if (expired) {
            return false;
        }
        if (this._state.getPending().size() > 1) {
            return true;
        }
        if (this._found) {
            if (this._log.shouldLog(10)) {
                this._log.debug("[" + this._id + "] Dont continue matching! looking for a reply from " + this._peer + " with regards to " + this._state.getTarget());
            }
            return false;
        }
        return true;
    }

    public long getExpiration() {
        return this._exp;
    }

    public boolean isMatch(I2NPMessage message) {
        if (this._log.shouldLog(10)) {
            this._log.debug("[" + this._id + "] isMatch(" + message.getClass().getName() + ") [want dbStore or dbSearchReply from " + this._peer + " for " + this._state.getTarget() + "]");
        }
        if (message instanceof DatabaseStoreMessage) {
            DatabaseStoreMessage msg = (DatabaseStoreMessage)message;
            if (msg.getKey().equals((Object)this._state.getTarget())) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("[" + this._id + "] Was a DBStore of the key we're looking for.  " + "May not have been from who we're checking against though, " + "but DBStore doesn't include that info");
                }
                this._found = true;
                return true;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("[" + this._id + "] DBStore of a key we're not looking for");
            }
            return false;
        }
        if (message instanceof DatabaseSearchReplyMessage) {
            DatabaseSearchReplyMessage msg = (DatabaseSearchReplyMessage)message;
            if (this._peer.equals((Object)msg.getFromHash())) {
                if (msg.getSearchKey().equals((Object)this._state.getTarget())) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("[" + this._id + "] Was a DBSearchReply from who we're " + "checking with for a key we're looking for");
                    }
                    this._found = true;
                    return true;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("[" + this._id + "] Was a DBSearchReply from who we're checking " + "with but NOT for the key we're looking for");
                }
                return false;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("[" + this._id + "] DBSearchReply from someone we are not checking with [" + msg.getFromHash() + ", not " + this._state.getTarget() + "]");
            }
            return false;
        }
        return false;
    }
}

