/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.Job;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.DatabaseLookupMessageHandler;
import net.i2p.router.networkdb.DatabaseStoreMessageHandler;
import net.i2p.router.networkdb.PublishLocalRouterInfoJob;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.networkdb.kademlia.ExpireLeasesJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.HarvesterJob;
import net.i2p.router.networkdb.kademlia.KBucketSet;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.PersistentDataStore;
import net.i2p.router.networkdb.kademlia.RepublishLeaseSetJob;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.SelectionCollector;
import net.i2p.router.networkdb.kademlia.StartExplorersJob;
import net.i2p.router.networkdb.kademlia.StoreJob;
import net.i2p.router.networkdb.reseed.ReseedChecker;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KademliaNetworkDatabaseFacade
extends NetworkDatabaseFacade {
    protected final Log _log;
    private KBucketSet _kb;
    private DataStore _ds;
    private String _dbDir;
    private final Set<Hash> _exploreKeys = new ConcurrentHashSet(64);
    private boolean _initialized;
    private long _started;
    private StartExplorersJob _exploreJob;
    private HarvesterJob _harvestJob;
    private long _lastExploreNew;
    protected final PeerSelector _peerSelector;
    protected final RouterContext _context;
    private final ReseedChecker _reseedChecker;
    private final Map<Hash, RepublishLeaseSetJob> _publishingLeaseSets;
    private final Map<Hash, SearchJob> _activeRequests;
    protected static final long DONT_FAIL_PERIOD = 600000L;
    private static final boolean QUIET = false;
    public static final String PROP_ENFORCE_NETID = "router.networkDatabase.enforceNetId";
    private static final boolean DEFAULT_ENFORCE_NETID = false;
    private boolean _enforceNetId = false;
    public static final String PROP_DB_DIR = "router.networkDatabase.dbDir";
    public static final String DEFAULT_DB_DIR = "netDb";
    protected static final int MIN_REMAINING_ROUTERS = 25;
    private static final long ROUTER_INFO_EXPIRATION = 97200000L;
    private static final long ROUTER_INFO_EXPIRATION_MIN = 5400000L;
    private static final long ROUTER_INFO_EXPIRATION_SHORT = 4500000L;
    private static final long ROUTER_INFO_EXPIRATION_FLOODFILL = 3600000L;
    private static final long EXPLORE_JOB_DELAY = 600000L;
    protected static final long PUBLISH_JOB_DELAY = 300000L;
    private static final int MAX_EXPLORE_QUEUE = 128;
    private static final long PUBLISH_DELAY = 3000L;
    static final long MAX_LEASE_FUTURE = 1200000L;
    private static final int MIN_ROUTERS = 90;
    private static final int MIN_PER_PEER_TIMEOUT = 2000;
    private static final int MAX_PER_PEER_TIMEOUT = 7000;
    private static final int TIMEOUT_MULTIPLIER = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchComplete(Hash key) {
        if (this._log.shouldLog(10)) {
            this._log.debug("search Complete: " + key);
        }
        Map<Hash, SearchJob> map = this._activeRequests;
        synchronized (map) {
            this._activeRequests.remove(key);
        }
    }

    public KademliaNetworkDatabaseFacade(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(this.getClass());
        this._peerSelector = this.createPeerSelector();
        this._publishingLeaseSets = new HashMap<Hash, RepublishLeaseSetJob>(8);
        this._activeRequests = new HashMap<Hash, SearchJob>(8);
        this._enforceNetId = false;
        this._reseedChecker = new ReseedChecker(context);
        context.statManager().createRateStat("netDb.lookupDeferred", "how many lookups are deferred?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.exploreKeySet", "how many keys are queued for exploration?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeRouterInfoSent", "How many routerInfo store messages have we sent?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeLeaseSetSent", "How many leaseSet store messages have we sent?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storePeers", "How many peers each netDb must be sent to before success?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeFailedPeers", "How many peers each netDb must be sent to before failing completely?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.ackTime", "How long does it take for a peer to ack a netDb store?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.replyTimeout", "How long after a netDb send does the timeout expire (when the peer doesn't reply in time)?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.republishLeaseSetCount", "How often we republish a leaseSet?", "NetworkDatabase", new long[]{3600000L});
    }

    @Override
    public boolean isInitialized() {
        return this._initialized && this._ds != null && this._ds.isInitialized();
    }

    protected PeerSelector createPeerSelector() {
        return new PeerSelector(this._context);
    }

    public PeerSelector getPeerSelector() {
        return this._peerSelector;
    }

    @Override
    public ReseedChecker reseedChecker() {
        return this._reseedChecker;
    }

    KBucketSet getKBuckets() {
        return this._kb;
    }

    DataStore getDataStore() {
        return this._ds;
    }

    long getLastExploreNewDate() {
        return this._lastExploreNew;
    }

    void setLastExploreNewDate(long when) {
        this._lastExploreNew = when;
        if (this._exploreJob != null) {
            this._exploreJob.updateExploreSchedule();
        }
    }

    public Set<Hash> getExploreKeys() {
        if (!this._initialized) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(this._exploreKeys);
    }

    public void removeFromExploreKeys(Set<Hash> toRemove) {
        if (!this._initialized) {
            return;
        }
        this._exploreKeys.removeAll(toRemove);
        this._context.statManager().addRateData("netDb.exploreKeySet", (long)this._exploreKeys.size(), 0L);
    }

    public void queueForExploration(Set<Hash> keys) {
        if (!this._initialized) {
            return;
        }
        Iterator<Hash> iter = keys.iterator();
        while (iter.hasNext() && this._exploreKeys.size() < 128) {
            this._exploreKeys.add(iter.next());
        }
        this._context.statManager().addRateData("netDb.exploreKeySet", (long)this._exploreKeys.size(), 0L);
    }

    @Override
    public void shutdown() {
        this._initialized = false;
        if (this._kb != null) {
            this._kb.clear();
        }
        if (this._ds != null) {
            this._ds.stop();
        }
        this._exploreKeys.clear();
    }

    @Override
    public void restart() {
        String enforce;
        this._dbDir = this._context.router().getConfigSetting(PROP_DB_DIR);
        if (this._dbDir == null) {
            this._log.info("No DB dir specified [router.networkDatabase.dbDir], using [netDb]");
            this._dbDir = DEFAULT_DB_DIR;
        }
        this._enforceNetId = (enforce = this._context.getProperty(PROP_ENFORCE_NETID)) != null ? Boolean.valueOf(enforce) : false;
        this._ds.restart();
        this._exploreKeys.clear();
        this._initialized = true;
        RouterInfo ri = this._context.router().getRouterInfo();
        this.publish(ri);
    }

    @Override
    public void rescan() {
        if (this.isInitialized()) {
            this._ds.rescan();
        }
    }

    String getDbDir() {
        return this._dbDir;
    }

    @Override
    public void startup() {
        this._log.info("Starting up the kademlia network database");
        RouterInfo ri = this._context.router().getRouterInfo();
        String dbDir = this._context.getProperty(PROP_DB_DIR, DEFAULT_DB_DIR);
        String enforce = this._context.getProperty(PROP_ENFORCE_NETID);
        this._enforceNetId = enforce != null ? Boolean.valueOf(enforce) : false;
        this._kb = new KBucketSet(this._context, ri.getIdentity().getHash());
        try {
            this._ds = new PersistentDataStore(this._context, dbDir, this);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to initialize netdb storage", ioe);
        }
        this._dbDir = dbDir;
        this.createHandlers();
        this._initialized = true;
        this._started = System.currentTimeMillis();
        ExpireLeasesJob elj = new ExpireLeasesJob(this._context, this);
        elj.getTiming().setStartAfter(this._context.clock().now() + 120000L);
        this._context.jobQueue().addJob(elj);
        if (this._exploreJob == null) {
            this._exploreJob = new StartExplorersJob(this._context, this);
        }
        this._exploreJob.getTiming().setStartAfter(this._context.clock().now() + 600000L);
        this._context.jobQueue().addJob(this._exploreJob);
        if (this._harvestJob == null && this._context.getBooleanProperty("netDb.shouldHarvest")) {
            this._harvestJob = new HarvesterJob(this._context, this);
        }
        this._context.jobQueue().addJob(this._harvestJob);
        PublishLocalRouterInfoJob plrij = new PublishLocalRouterInfoJob(this._context);
        this._context.jobQueue().addJob(plrij);
    }

    protected void createHandlers() {
        this._context.inNetMessagePool().registerHandlerJobBuilder(2, new DatabaseLookupMessageHandler(this._context));
        this._context.inNetMessagePool().registerHandlerJobBuilder(1, new DatabaseStoreMessageHandler(this._context));
    }

    @Override
    public Set<Hash> findNearestRouters(Hash key, int maxNumRouters, Set<Hash> peersToIgnore) {
        if (!this._initialized) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<Hash>(this._peerSelector.selectNearest(key, maxNumRouters, peersToIgnore, this._kb));
    }

    @Override
    public Set<Hash> getAllRouters() {
        if (!this._initialized) {
            return Collections.EMPTY_SET;
        }
        Set<Map.Entry<Hash, DatabaseEntry>> entries = this._ds.getMapEntries();
        HashSet<Hash> rv = new HashSet<Hash>(entries.size());
        for (Map.Entry<Hash, DatabaseEntry> entry : entries) {
            if (entry.getValue().getType() != 0) continue;
            rv.add(entry.getKey());
        }
        return rv;
    }

    @Override
    public int getKnownRouters() {
        if (this._kb == null) {
            return 0;
        }
        CountRouters count = new CountRouters();
        this._kb.getAll(count);
        return count.size();
    }

    @Override
    public int getKnownLeaseSets() {
        if (this._ds == null) {
            return 0;
        }
        int rv = 0;
        for (DatabaseEntry ds : this._ds.getEntries()) {
            if (ds.getType() != 1 || !((LeaseSet)ds).getReceivedAsPublished()) continue;
            ++rv;
        }
        return rv;
    }

    protected int getKBucketSetSize() {
        if (this._kb == null) {
            return 0;
        }
        return this._kb.size();
    }

    @Override
    public DatabaseEntry lookupLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry rv = this._ds.get(key);
        if (rv == null) {
            return null;
        }
        if (rv.getType() == 1) {
            LeaseSet ls = (LeaseSet)rv;
            if (ls.isCurrent(60000L)) {
                return rv;
            }
            this.fail(key);
        } else if (rv.getType() == 0) {
            try {
                if (this.validate(key, (RouterInfo)rv) == null) {
                    return rv;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.fail(key);
        }
        return null;
    }

    @Override
    public void lookupLeaseSet(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        if (!this._initialized) {
            return;
        }
        LeaseSet ls = this.lookupLeaseSetLocally(key);
        if (ls != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("leaseSet found locally, firing " + onFindJob);
            }
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("leaseSet not found locally, running search");
            }
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, true);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("after lookupLeaseSet");
        }
    }

    @Override
    public LeaseSet lookupLeaseSetLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.getType() == 1) {
                LeaseSet ls = (LeaseSet)ds;
                if (ls.isCurrent(60000L)) {
                    return ls;
                }
                this.fail(key);
                this._exploreKeys.add(key);
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void lookupRouterInfo(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        if (!this._initialized) {
            return;
        }
        RouterInfo ri = this.lookupRouterInfoLocally(key);
        if (ri != null) {
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else {
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, false);
        }
    }

    @Override
    public RouterInfo lookupRouterInfoLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.getType() == 0) {
                boolean valid = true;
                try {
                    valid = null == this.validate(key, (RouterInfo)ds);
                }
                catch (IllegalArgumentException iae) {
                    valid = false;
                }
                if (!valid) {
                    this.fail(key);
                    return null;
                }
                return (RouterInfo)ds;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LeaseSet localLeaseSet) {
        int code;
        if (!this._initialized) {
            return;
        }
        Hash h = localLeaseSet.getDestination().calculateHash();
        try {
            this.store(h, localLeaseSet);
        }
        catch (IllegalArgumentException iae) {
            this._log.error("wtf, locally published leaseSet is not valid?", (Throwable)iae);
            return;
        }
        if (!this._context.clientManager().shouldPublishLeaseSet(h)) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress() && ((code = this._context.router().scheduledGracefulExitCode()) == 2 || code == 3)) {
            return;
        }
        RepublishLeaseSetJob j = null;
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            j = this._publishingLeaseSets.get(h);
            if (j == null) {
                j = new RepublishLeaseSetJob(this._context, this, h);
                this._publishingLeaseSets.put(h, j);
            }
        }
        long nextTime = Math.max(j.lastPublished() + 60000L, this._context.clock().now() + 3000L);
        this._context.jobQueue().removeJob(j);
        j.getTiming().setStartAfter(nextTime);
        this._context.jobQueue().addJob(j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPublishing(Hash target) {
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            this._publishingLeaseSets.remove(target);
        }
    }

    @Override
    public void publish(RouterInfo localRouterInfo) throws IllegalArgumentException {
        if (!this._initialized) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress()) {
            return;
        }
        if (this._context.router().isHidden()) {
            return;
        }
        Hash h = localRouterInfo.getIdentity().getHash();
        this.store(h, localRouterInfo);
    }

    String validate(Hash key, LeaseSet leaseSet) {
        if (!key.equals((Object)leaseSet.getDestination().calculateHash())) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid store attempt! key does not match leaseSet.destination!  key = " + key + ", leaseSet = " + leaseSet);
            }
            return "Key does not match leaseSet.destination - " + key.toBase64();
        }
        if (!leaseSet.verifySignature()) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid leaseSet signature!  leaseSet = " + leaseSet);
            }
            return "Invalid leaseSet signature on " + leaseSet.getDestination().calculateHash().toBase64();
        }
        if (leaseSet.getEarliestLeaseDate() <= this._context.clock().now() - 120000L) {
            long age = this._context.clock().now() - leaseSet.getEarliestLeaseDate();
            if (this._log.shouldLog(30)) {
                this._log.warn("Old leaseSet!  not storing it: " + leaseSet.getDestination().calculateHash().toBase64() + " expires on " + new Date(leaseSet.getEarliestLeaseDate()), (Throwable)new Exception("Rejecting store"));
            }
            return "Expired leaseSet for " + leaseSet.getDestination().calculateHash().toBase64() + " expired " + DataHelper.formatDuration((long)age) + " ago";
        }
        if (leaseSet.getEarliestLeaseDate() > this._context.clock().now() + 1260000L) {
            long age = leaseSet.getEarliestLeaseDate() - this._context.clock().now();
            if (this._log.shouldLog(30)) {
                this._log.warn("LeaseSet expires too far in the future: " + leaseSet.getDestination().calculateHash().toBase64() + " expires " + DataHelper.formatDuration((long)age) + " from now");
            }
            return "Future expiring leaseSet for " + leaseSet.getDestination().calculateHash() + " expiring in " + DataHelper.formatDuration((long)age);
        }
        return null;
    }

    @Override
    public LeaseSet store(Hash key, LeaseSet leaseSet) throws IllegalArgumentException {
        if (!this._initialized) {
            return null;
        }
        LeaseSet rv = null;
        try {
            rv = (LeaseSet)this._ds.get(key);
            if (rv != null && rv.equals((Object)leaseSet)) {
                return rv;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Attempt to replace RI with " + leaseSet);
        }
        String err = this.validate(key, leaseSet);
        if (err != null) {
            throw new IllegalArgumentException("Invalid store attempt - " + err);
        }
        this._ds.put(key, (DatabaseEntry)leaseSet);
        return rv;
    }

    String validate(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        long now = this._context.clock().now();
        boolean upLongEnough = this._context.router().getUptime() > 3600000L;
        long adjustedExpiration = FloodfillNetworkDatabaseFacade.floodfillEnabled(this._context) ? 3600000L : Math.min(97200000L, 5400000L + 8262000000L / (long)(this._kb.size() + 1));
        if (!key.equals((Object)routerInfo.getIdentity().getHash())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid store attempt! key does not match routerInfo.identity!  key = " + key + ", router = " + routerInfo);
            }
            return "Key does not match routerInfo.identity - " + key.toBase64();
        }
        if (!routerInfo.isValid()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid routerInfo signature!  forged router structure!  router = " + routerInfo);
            }
            return "Invalid routerInfo signature on " + key.toBase64();
        }
        if (upLongEnough && !routerInfo.isCurrent(adjustedExpiration)) {
            if (routerInfo.getNetworkId() != 2) {
                this._context.shitlist().shitlistRouter(key, "Peer is not in our network");
                return "Peer is not in our network (" + routerInfo.getNetworkId() + ", wants " + 2 + "): " + routerInfo.calculateHash().toBase64();
            }
            long age = this._context.clock().now() - routerInfo.getPublished();
            int existing = this._kb.size();
            if (existing >= 25) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Not storing expired router for " + key.toBase64(), (Throwable)new Exception("Rejecting store"));
                }
                return "Peer " + key.toBase64() + " expired " + DataHelper.formatDuration((long)age) + " ago";
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Even though the peer is old, we have only " + existing + " peers left (curPeer: " + key.toBase64() + " published on " + new Date(routerInfo.getPublished()));
            }
        } else {
            if (routerInfo.getPublished() > now + 120000L) {
                long age = routerInfo.getPublished() - this._context.clock().now();
                if (this._log.shouldLog(20)) {
                    this._log.info("Peer " + key.toBase64() + " published their routerInfo in the future?! [" + new Date(routerInfo.getPublished()) + "]", (Throwable)new Exception("Rejecting store"));
                }
                return "Peer " + key.toBase64() + " published " + DataHelper.formatDuration((long)age) + " in the future?!";
            }
            if (this._enforceNetId && routerInfo.getNetworkId() != 2) {
                String rv = "Peer " + key.toBase64() + " is from another network, not accepting it (id=" + routerInfo.getNetworkId() + ", want " + 2 + ")";
                return rv;
            }
            if (upLongEnough && routerInfo.getPublished() < now - 172800000L) {
                long age = this._context.clock().now() - routerInfo.getPublished();
                return "Peer " + key.toBase64() + " published " + DataHelper.formatDuration((long)age) + " ago";
            }
            if (upLongEnough && !routerInfo.isCurrent(4500000L)) {
                if (routerInfo.getAddresses().isEmpty()) {
                    return "Peer " + key.toBase64() + " published > 75m ago with no addresses";
                }
                if (routerInfo.getCapabilities().indexOf(85) >= 0) {
                    return "Peer " + key.toBase64() + " published > 75m ago and thinks it is unreachable";
                }
                RouterAddress ra = routerInfo.getTargetAddress("SSU");
                if (ra != null) {
                    if (ra.getOption("ihost0") != null) {
                        return "Peer " + key.toBase64() + " published > 75m ago with SSU Introducers";
                    }
                    if (routerInfo.getTargetAddress("NTCP") == null) {
                        return "Peer " + key.toBase64() + " published > 75m ago, SSU only without introducers";
                    }
                }
            }
        }
        return null;
    }

    @Override
    public RouterInfo store(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        return this.store(key, routerInfo, true);
    }

    RouterInfo store(Hash key, RouterInfo routerInfo, boolean persist) throws IllegalArgumentException {
        if (!this._initialized) {
            return null;
        }
        RouterInfo rv = null;
        try {
            rv = (RouterInfo)this._ds.get(key, persist);
            if (rv != null && rv.equals((Object)routerInfo)) {
                return rv;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Attempt to replace LS with " + routerInfo);
        }
        String err = this.validate(key, routerInfo);
        if (err != null) {
            throw new IllegalArgumentException("Invalid store attempt - " + err);
        }
        this._context.peerManager().setCapabilities(key, routerInfo.getCapabilities());
        this._ds.put(key, (DatabaseEntry)routerInfo, persist);
        if (rv == null) {
            this._kb.add(key);
        }
        return rv;
    }

    @Override
    public void fail(Hash dbEntry) {
        if (!this._initialized) {
            return;
        }
        DatabaseEntry o = this._ds.get(dbEntry);
        if (o == null) {
            this._kb.remove(dbEntry);
            this._context.peerManager().removeCapabilities(dbEntry);
            return;
        }
        if (o.getType() == 0) {
            this.lookupBeforeDropping(dbEntry, (RouterInfo)o);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Dropping a lease: " + dbEntry);
        }
        this._ds.remove(dbEntry, false);
    }

    protected void lookupBeforeDropping(Hash peer, RouterInfo info) {
        this.dropAfterLookupFailed(peer, info);
    }

    protected void dropAfterLookupFailed(Hash peer, RouterInfo info) {
        this._context.peerManager().removeCapabilities(peer);
        boolean removed = this._kb.remove(peer);
        if (removed && this._log.shouldLog(20)) {
            this._log.info("Removed kbucket entry for " + peer);
        }
        this._ds.remove(peer);
    }

    @Override
    public void unpublish(LeaseSet localLeaseSet) {
        if (!this._initialized) {
            return;
        }
        Hash h = localLeaseSet.getDestination().calculateHash();
        DatabaseEntry data = this._ds.remove(h);
        if (data == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unpublished a lease we don't know...: " + localLeaseSet);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Unpublished a lease: " + h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease) {
        if (!this._initialized) {
            return null;
        }
        boolean isNew = true;
        SearchJob searchJob = null;
        Map<Hash, SearchJob> map = this._activeRequests;
        synchronized (map) {
            searchJob = this._activeRequests.get(key);
            if (searchJob == null) {
                searchJob = new SearchJob(this._context, this, key, onFindJob, onFailedLookupJob, timeoutMs, true, isLease);
                this._activeRequests.put(key, searchJob);
            } else {
                isNew = false;
            }
        }
        if (isNew) {
            if (this._log.shouldLog(10)) {
                this._log.debug("this is the first search for that key, fire off the SearchJob");
            }
            this._context.jobQueue().addJob(searchJob);
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Deferring search for " + key.toBase64() + " with " + onFindJob);
            }
            int deferred = searchJob.addDeferred(onFindJob, onFailedLookupJob, timeoutMs, isLease);
            this._context.statManager().addRateData("netDb.lookupDeferred", (long)deferred, searchJob.getExpiration() - this._context.clock().now());
        }
        return searchJob;
    }

    @Override
    public Set<LeaseSet> getLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<LeaseSet> leases = new HashSet<LeaseSet>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (o.getType() != 1) continue;
            leases.add((LeaseSet)o);
        }
        return leases;
    }

    @Override
    public Set<RouterInfo> getRouters() {
        if (!this._initialized) {
            return null;
        }
        HashSet<RouterInfo> routers = new HashSet<RouterInfo>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (o.getType() != 0) continue;
            routers.add((RouterInfo)o);
        }
        return routers;
    }

    public int getPeerTimeout(Hash peer) {
        PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
        double responseTime = 7000.0;
        if (prof != null && prof.getIsExpandedDB()) {
            responseTime = prof.getDbResponseTime().getRate(86400000L).getAverageValue();
            if (responseTime <= 0.0 || responseTime > 7000.0) {
                responseTime = 7000.0;
            } else if (responseTime < 2000.0) {
                responseTime = 2000.0;
            }
        }
        return 3 * (int)responseTime;
    }

    public void sendStore(Hash key, DatabaseEntry ds, Job onSuccess, Job onFailure, long sendTimeout, Set toIgnore) {
        if (ds == null || key == null) {
            if (onFailure != null) {
                this._context.jobQueue().addJob(onFailure);
            }
            return;
        }
        this._context.jobQueue().addJob(new StoreJob(this._context, this, key, ds, onSuccess, onFailure, sendTimeout, toIgnore));
    }

    private class CountRouters
    implements SelectionCollector {
        private int _count;

        private CountRouters() {
        }

        public int size() {
            return this._count;
        }

        public void add(Hash entry) {
            if (KademliaNetworkDatabaseFacade.this._ds == null) {
                return;
            }
            DatabaseEntry o = KademliaNetworkDatabaseFacade.this._ds.get(entry);
            if (o != null && o.getType() == 0) {
                ++this._count;
            }
        }
    }
}

