/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataFormatException;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodThrottler;
import net.i2p.router.networkdb.kademlia.FloodfillDatabaseLookupMessageHandler;
import net.i2p.router.networkdb.kademlia.FloodfillDatabaseStoreMessageHandler;
import net.i2p.router.networkdb.kademlia.FloodfillMonitorJob;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.FloodfillStoreJob;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.LookupThrottler;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.RefreshRoutersJob;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.util.ConcurrentHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloodfillNetworkDatabaseFacade
extends KademliaNetworkDatabaseFacade {
    public static final char CAPABILITY_FLOODFILL = 'f';
    private final Map<Hash, FloodSearchJob> _activeFloodQueries = new HashMap<Hash, FloodSearchJob>();
    private boolean _floodfillEnabled;
    private static String _alwaysQuery;
    private final Set<Hash> _verifiesInProgress = new ConcurrentHashSet(8);
    private FloodThrottler _floodThrottler;
    private LookupThrottler _lookupThrottler;
    static final long PUBLISH_TIMEOUT = 90000L;
    private static final int MAX_TO_FLOOD = 5;
    private static final int FLOOD_PRIORITY = 200;
    private static final int FLOOD_TIMEOUT = 30000;
    protected static final int MIN_ACTIVE_PEERS = 5;
    private static final int MAX_DB_BEFORE_SKIPPING_SEARCH;

    public FloodfillNetworkDatabaseFacade(RouterContext context) {
        super(context);
        _alwaysQuery = this._context.getProperty("netDb.alwaysQuery");
        this._context.statManager().createRequiredRateStat("netDb.successTime", "Time for successful lookup (ms)", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.failedTime", "How long a failed search takes", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.retries", "How many additional queries for an iterative search", "NetworkDatabase", new long[]{3600000L});
        this._context.statManager().createRateStat("netDb.failedAttemptedPeers", "How many peers we sent a search to when the search fails", "NetworkDatabase", new long[]{600000L});
        this._context.statManager().createRateStat("netDb.successPeers", "How many peers are contacted in a successful search", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.failedPeers", "How many peers fail to respond to a lookup?", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchCount", "Overall number of searches sent", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchMessageCount", "Overall number of mesages for all searches sent", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchReplyValidated", "How many search replies we get that we are able to validate (fetch)", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchReplyNotValidated", "How many search replies we get that we are NOT able to validate (fetch)", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.searchReplyValidationSkipped", "How many search replies we get from unreliable peers that we skip?", "NetworkDatabase", new long[]{300000L, 600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("netDb.republishQuantity", "How many peers do we need to send a found leaseSet to?", "NetworkDatabase", new long[]{600000L, 3600000L, 10800000L, 86400000L});
    }

    @Override
    public void startup() {
        super.startup();
        this._context.jobQueue().addJob(new FloodfillMonitorJob(this._context, this));
        this._lookupThrottler = new LookupThrottler();
        RefreshRoutersJob rrj = new RefreshRoutersJob(this._context, this);
        rrj.getTiming().setStartAfter(this._context.clock().now() + 300000L);
        this._context.jobQueue().addJob(rrj);
    }

    @Override
    protected void createHandlers() {
        this._context.inNetMessagePool().registerHandlerJobBuilder(2, new FloodfillDatabaseLookupMessageHandler(this._context, this));
        this._context.inNetMessagePool().registerHandlerJobBuilder(1, new FloodfillDatabaseStoreMessageHandler(this._context, this));
    }

    @Override
    public void shutdown() {
        if (this._floodfillEnabled) {
            this._floodfillEnabled = false;
            this._context.router().rebuildRouterInfo(true);
            RouterInfo local = this._context.router().getRouterInfo();
            if (local != null && this._context.router().getUptime() > 300000L) {
                this.flood((DatabaseEntry)local);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        super.shutdown();
    }

    @Override
    public void publish(RouterInfo localRouterInfo) throws IllegalArgumentException {
        if (localRouterInfo == null) {
            throw new IllegalArgumentException("wtf, null localRouterInfo?");
        }
        if (this._context.router().isHidden()) {
            return;
        }
        super.publish(localRouterInfo);
        if (!this.isInitialized()) {
            return;
        }
        if (localRouterInfo.getAddresses().isEmpty()) {
            return;
        }
        this._log.info("Publishing our RI");
        this.sendStore(localRouterInfo.getIdentity().calculateHash(), (DatabaseEntry)localRouterInfo, null, null, 90000L, null);
    }

    @Override
    public void sendStore(Hash key, DatabaseEntry ds, Job onSuccess, Job onFailure, long sendTimeout, Set toIgnore) {
        if (this.floodfillEnabled() && ds.getType() == 0) {
            this.flood(ds);
            if (onSuccess != null) {
                this._context.jobQueue().addJob(onSuccess);
            }
        } else {
            this._context.jobQueue().addJob(new FloodfillStoreJob(this._context, this, key, ds, onSuccess, onFailure, sendTimeout, (Set<Hash>)toIgnore));
        }
    }

    boolean shouldThrottleFlood(Hash key) {
        return this._floodThrottler != null && this._floodThrottler.shouldThrottle(key);
    }

    boolean shouldThrottleLookup(Hash from, TunnelId id) {
        return this._lookupThrottler.shouldThrottle(from, id);
    }

    public void flood(DatabaseEntry ds) {
        Hash key = ds.getHash();
        Hash rkey = this._context.routingKeyGenerator().getRoutingKey(key);
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this.getPeerSelector();
        List<Hash> peers = sel.selectFloodfillParticipants(rkey, 5, this.getKBuckets());
        int flooded = 0;
        for (int i = 0; i < peers.size(); ++i) {
            Hash peer = peers.get(i);
            RouterInfo target = this.lookupRouterInfoLocally(peer);
            if (target == null || this._context.shitlist().isShitlisted(peer) || peer.equals((Object)this._context.routerHash())) continue;
            DatabaseStoreMessage msg = new DatabaseStoreMessage(this._context);
            msg.setEntry(ds);
            msg.setReplyGateway(null);
            msg.setReplyToken(0L);
            msg.setReplyTunnel(null);
            OutNetMessage m = new OutNetMessage(this._context);
            m.setMessage(msg);
            m.setOnFailedReplyJob(null);
            m.setPriority(200);
            m.setTarget(target);
            m.setExpiration(this._context.clock().now() + 30000L);
            FloodFailedJob floodFail = new FloodFailedJob(this._context, peer);
            m.setOnFailedSendJob(floodFail);
            this._context.commSystem().processMessage(m);
            ++flooded;
            if (!this._log.shouldLog(20)) continue;
            this._log.info("Flooding the entry for " + key.toBase64() + " to " + peer.toBase64());
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Flooded the data to " + flooded + " of " + peers.size() + " peers");
        }
    }

    @Override
    protected PeerSelector createPeerSelector() {
        return new FloodfillPeerSelector(this._context);
    }

    synchronized void setFloodfillEnabled(boolean yes) {
        this._floodfillEnabled = yes;
        if (yes && this._floodThrottler == null) {
            this._floodThrottler = new FloodThrottler();
            this._context.statManager().createRateStat("netDb.floodThrottled", "How often do we decline to flood?", "NetworkDatabase", new long[]{3600000L});
            this._context.statManager().createRateStat("netDb.storeFloodNew", "How long it takes to flood out a newly received entry?", "NetworkDatabase", new long[]{3600000L});
            this._context.statManager().createRateStat("netDb.storeFloodOld", "How often we receive an old entry?", "NetworkDatabase", new long[]{3600000L});
        }
    }

    public boolean floodfillEnabled() {
        return this._floodfillEnabled;
    }

    public static boolean floodfillEnabled(RouterContext ctx) {
        return ((FloodfillNetworkDatabaseFacade)ctx.netDb()).floodfillEnabled();
    }

    public static boolean isFloodfill(RouterInfo peer) {
        String caps;
        if (peer == null) {
            return false;
        }
        if (_alwaysQuery != null) {
            Hash aq = new Hash();
            try {
                aq.fromBase64(_alwaysQuery);
                if (aq.equals((Object)peer.getIdentity().getHash())) {
                    return true;
                }
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return (caps = peer.getCapabilities()).indexOf(102) >= 0;
    }

    public List<RouterInfo> getKnownRouterData() {
        ArrayList<RouterInfo> rv = new ArrayList<RouterInfo>();
        DataStore ds = this.getDataStore();
        if (ds != null) {
            for (DatabaseEntry o : ds.getEntries()) {
                if (o.getType() != 0) continue;
                rv.add((RouterInfo)o);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease) {
        if (key == null) {
            throw new IllegalArgumentException("searchin for nothin, eh?");
        }
        boolean isNew = false;
        FloodSearchJob searchJob = null;
        Map<Hash, FloodSearchJob> map = this._activeFloodQueries;
        synchronized (map) {
            searchJob = this._activeFloodQueries.get(key);
            if (searchJob == null) {
                searchJob = new IterativeSearchJob(this._context, this, key, onFindJob, onFailedLookupJob, (int)timeoutMs, isLease);
                this._activeFloodQueries.put(key, searchJob);
                isNew = true;
            }
        }
        if (isNew) {
            if (this._log.shouldLog(10)) {
                this._log.debug("this is the first search for that key, fire off the FloodSearchJob");
            }
            this._context.jobQueue().addJob(searchJob);
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Deferring flood search for " + key.toBase64() + " with " + this._activeFloodQueries.size() + " in progress");
            }
            searchJob.addDeferred(onFindJob, onFailedLookupJob, timeoutMs, isLease);
            this._context.statManager().addRateData("netDb.lookupDeferred", 1L, searchJob.getExpiration() - this._context.clock().now());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete(Hash key) {
        Map<Hash, FloodSearchJob> map = this._activeFloodQueries;
        synchronized (map) {
            this._activeFloodQueries.remove(key);
        }
    }

    public List<Hash> getFloodfillPeers() {
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this.getPeerSelector();
        return sel.selectFloodfillParticipants(this.getKBuckets());
    }

    boolean isVerifyInProgress(Hash h) {
        return this._verifiesInProgress.contains(h);
    }

    void verifyStarted(Hash h) {
        this._verifiesInProgress.add(h);
    }

    void verifyFinished(Hash h) {
        this._verifiesInProgress.remove(h);
    }

    @Override
    protected void lookupBeforeDropping(Hash peer, RouterInfo info) {
        if (info.getNetworkId() == 2 && (this.getKBucketSetSize() < 25 || this._context.router().getUptime() < 600000L || this._context.commSystem().countActivePeers() <= 5)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not failing " + peer.toBase64() + " as we are just starting up or have problems");
            }
            return;
        }
        if (this._floodfillEnabled || this._context.jobQueue().getMaxLag() > 500L || this.getKBucketSetSize() > MAX_DB_BEFORE_SKIPPING_SEARCH) {
            super.lookupBeforeDropping(peer, info);
            return;
        }
        this.search(peer, new DropLookupFoundJob(this._context, peer, info), new DropLookupFailedJob(this._context, peer, info), 10000L, false);
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x8000000L;
        }
        MAX_DB_BEFORE_SKIPPING_SEARCH = (int)Math.max(250L, Math.min(1250L, maxMemory / 134217L));
    }

    private class DropLookupFailedJob
    extends JobImpl {
        private final Hash _peer;
        private final RouterInfo _info;

        public DropLookupFailedJob(RouterContext ctx, Hash peer, RouterInfo info) {
            super(ctx);
            this._peer = peer;
            this._info = info;
        }

        public String getName() {
            return "Lookup on failure of netDb peer timed out";
        }

        public void runJob() {
            FloodfillNetworkDatabaseFacade.this.dropAfterLookupFailed(this._peer, this._info);
        }
    }

    private class DropLookupFoundJob
    extends JobImpl {
        private final Hash _peer;
        private final RouterInfo _info;

        public DropLookupFoundJob(RouterContext ctx, Hash peer, RouterInfo info) {
            super(ctx);
            this._peer = peer;
            this._info = info;
        }

        public String getName() {
            return "Lookup on failure of netDb peer matched";
        }

        public void runJob() {
            RouterInfo updated = FloodfillNetworkDatabaseFacade.this.lookupRouterInfoLocally(this._peer);
            if (updated == null || updated.getPublished() <= this._info.getPublished()) {
                FloodfillNetworkDatabaseFacade.this.dropAfterLookupFailed(this._peer, this._info);
            }
        }
    }

    private static class FloodFailedJob
    extends JobImpl {
        private Hash _peer;

        public FloodFailedJob(RouterContext ctx, Hash peer) {
            super(ctx);
            this._peer = peer;
        }

        public String getName() {
            return "Flood failed";
        }

        public void runJob() {
            this.getContext().profileManager().dbStoreFailed(this._peer);
        }
    }
}

