/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

class FloodThrottler {
    private ObjectCounter<Hash> counter = new ObjectCounter();
    private static final int MAX_FLOODS = 3;
    private static final long CLEAN_TIME = 60000L;

    FloodThrottler() {
        SimpleScheduler.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Cleaner(), 60000L);
    }

    boolean shouldThrottle(Hash h) {
        return this.counter.increment((Object)h) > 3;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            FloodThrottler.this.counter.clear();
        }
    }
}

