/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.KBucketSet;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.SearchJob;

class ExploreJob
extends SearchJob {
    private FloodfillPeerSelector _peerSelector;
    private static final long MAX_EXPLORE_TIME = 15000L;
    private static final int EXPLORE_BREDTH = 1;
    static final int MAX_CLOSEST = 20;
    static final int PER_FLOODFILL_PEER_TIMEOUT = 5000;

    public ExploreJob(RouterContext context, KademliaNetworkDatabaseFacade facade, Hash key) {
        super(context, facade, key, null, null, 15000L, false, false);
        this._peerSelector = (FloodfillPeerSelector)this._facade.getPeerSelector();
    }

    protected DatabaseLookupMessage buildMessage(TunnelId replyTunnelId, Hash replyGateway, long expiration) {
        DatabaseLookupMessage msg = new DatabaseLookupMessage(this.getContext(), true);
        msg.setSearchKey(this.getState().getTarget());
        msg.setFrom(replyGateway);
        Set<Hash> dontIncludePeers = this.getState().getClosestAttempted(20);
        msg.setMessageExpiration(expiration);
        msg.setReplyTunnel(replyTunnelId);
        int available = 20 - dontIncludePeers.size();
        if (available > 0 && dontIncludePeers.add(Hash.FAKE_HASH)) {
            --available;
        }
        KBucketSet ks = this._facade.getKBuckets();
        Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(this.getState().getTarget());
        available = 20 - dontIncludePeers.size();
        if (available > 0) {
            HashSet<Hash> dontInclude = new HashSet<Hash>(dontIncludePeers);
            List<Hash> peers = this._peerSelector.selectNearestExplicit(rkey, available, dontInclude, ks);
            dontIncludePeers.addAll(peers);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Peers we don't want to hear about: " + dontIncludePeers);
        }
        msg.setDontIncludePeers(dontIncludePeers);
        return msg;
    }

    protected int getBredth() {
        return 1;
    }

    protected void newPeersFound(int numNewPeers) {
        this._facade.setLastExploreNewDate(this.getContext().clock().now());
    }

    public String getName() {
        return "Kademlia NetDb Explore";
    }
}

