/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.Set;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Certificate;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutboundClientMessageJobHelper {
    OutboundClientMessageJobHelper() {
    }

    static GarlicMessage createGarlicMessage(RouterContext ctx, long replyToken, long expiration, PublicKey recipientPK, Payload data, Hash from, Destination dest, TunnelInfo replyTunnel, SessionKey wrappedKey, Set<SessionTag> wrappedTags, boolean requireAck, LeaseSet bundledReplyLeaseSet) {
        PayloadGarlicConfig dataClove = OutboundClientMessageJobHelper.buildDataClove(ctx, data, dest, expiration);
        return OutboundClientMessageJobHelper.createGarlicMessage(ctx, replyToken, expiration, recipientPK, dataClove, from, dest, replyTunnel, wrappedKey, wrappedTags, requireAck, bundledReplyLeaseSet);
    }

    static GarlicMessage createGarlicMessage(RouterContext ctx, long replyToken, long expiration, PublicKey recipientPK, PayloadGarlicConfig dataClove, Hash from, Destination dest, TunnelInfo replyTunnel, SessionKey wrappedKey, Set<SessionTag> wrappedTags, boolean requireAck, LeaseSet bundledReplyLeaseSet) {
        GarlicConfig config = OutboundClientMessageJobHelper.createGarlicConfig(ctx, replyToken, expiration, recipientPK, dataClove, from, dest, replyTunnel, requireAck, bundledReplyLeaseSet);
        if (config == null) {
            return null;
        }
        SessionKeyManager skm = ctx.clientManager().getClientSessionKeyManager(from);
        if (skm == null) {
            return null;
        }
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, skm);
        return msg;
    }

    private static GarlicConfig createGarlicConfig(RouterContext ctx, long replyToken, long expiration, PublicKey recipientPK, PayloadGarlicConfig dataClove, Hash from, Destination dest, TunnelInfo replyTunnel, boolean requireAck, LeaseSet bundledReplyLeaseSet) {
        Log log = ctx.logManager().getLog(OutboundClientMessageJobHelper.class);
        if (replyToken >= 0L && log.shouldLog(10)) {
            log.debug("Reply token: " + replyToken);
        }
        GarlicConfig config = new GarlicConfig();
        config.addClove(dataClove);
        if (requireAck) {
            PayloadGarlicConfig ackClove = OutboundClientMessageJobHelper.buildAckClove(ctx, from, replyTunnel, replyToken, expiration);
            if (ackClove == null) {
                return null;
            }
            config.addClove(ackClove);
        }
        if (bundledReplyLeaseSet != null) {
            PayloadGarlicConfig leaseSetClove = OutboundClientMessageJobHelper.buildLeaseSetClove(ctx, expiration, bundledReplyLeaseSet);
            config.addClove(leaseSetClove);
        }
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(0);
        config.setCertificate(Certificate.NULL_CERT);
        config.setDeliveryInstructions(instructions);
        config.setId(ctx.random().nextLong(0xFFFFFFFFL));
        config.setExpiration(expiration);
        config.setRecipientPublicKey(recipientPK);
        if (log.shouldLog(20)) {
            log.info("Creating garlic config to be encrypted to " + recipientPK + " for destination " + dest.calculateHash().toBase64());
        }
        return config;
    }

    private static PayloadGarlicConfig buildAckClove(RouterContext ctx, Hash from, TunnelInfo replyToTunnel, long replyToken, long expiration) {
        Log log = ctx.logManager().getLog(OutboundClientMessageJobHelper.class);
        PayloadGarlicConfig ackClove = new PayloadGarlicConfig();
        if (replyToTunnel == null) {
            if (log.shouldLog(30)) {
                log.warn("Unable to send client message from " + from.toBase64() + ", as there are no inbound tunnels available");
            }
            return null;
        }
        TunnelId replyToTunnelId = replyToTunnel.getReceiveTunnelId(0);
        Hash replyToTunnelRouter = replyToTunnel.getPeer(0);
        if (log.shouldLog(10)) {
            log.debug("Ack for the data message will come back along tunnel " + replyToTunnelId + ": " + replyToTunnel);
        }
        DeliveryInstructions ackInstructions = new DeliveryInstructions();
        ackInstructions.setDeliveryMode(3);
        ackInstructions.setRouter(replyToTunnelRouter);
        ackInstructions.setTunnelId(replyToTunnelId);
        DeliveryStatusMessage msg = new DeliveryStatusMessage(ctx);
        msg.setArrival(ctx.clock().now());
        msg.setMessageId(replyToken);
        ackClove.setCertificate(Certificate.NULL_CERT);
        ackClove.setDeliveryInstructions(ackInstructions);
        ackClove.setExpiration(expiration);
        ackClove.setId(ctx.random().nextLong(0xFFFFFFFFL));
        ackClove.setPayload(msg);
        ackClove.setRecipient(ctx.router().getRouterInfo());
        return ackClove;
    }

    static PayloadGarlicConfig buildDataClove(RouterContext ctx, Payload data, Destination dest, long expiration) {
        PayloadGarlicConfig clove = new PayloadGarlicConfig();
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(1);
        instructions.setDestination(dest.calculateHash());
        clove.setCertificate(Certificate.NULL_CERT);
        clove.setDeliveryInstructions(instructions);
        clove.setExpiration(expiration);
        clove.setId(ctx.random().nextLong(0xFFFFFFFFL));
        DataMessage msg = new DataMessage(ctx);
        msg.setData(data.getEncryptedData());
        clove.setPayload(msg);
        return clove;
    }

    static PayloadGarlicConfig buildLeaseSetClove(RouterContext ctx, long expiration, LeaseSet replyLeaseSet) {
        PayloadGarlicConfig clove = new PayloadGarlicConfig();
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(0);
        clove.setCertificate(Certificate.NULL_CERT);
        clove.setDeliveryInstructions(instructions);
        clove.setExpiration(expiration);
        clove.setId(ctx.random().nextLong(0xFFFFFFFFL));
        DatabaseStoreMessage msg = new DatabaseStoreMessage(ctx);
        msg.setEntry((DatabaseEntry)replyLeaseSet);
        msg.setMessageExpiration(expiration);
        clove.setPayload(msg);
        return clove;
    }
}

