/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.internal.PoisonI2CPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class ClientWriterRunner
implements Runnable {
    private BlockingQueue<I2CPMessage> _messagesToWrite;
    private ClientConnectionRunner _runner;
    private Log _log;
    private long _id;
    private static long __id = 0L;

    public ClientWriterRunner(RouterContext context, ClientConnectionRunner runner) {
        this._log = context.logManager().getLog(ClientWriterRunner.class);
        this._messagesToWrite = new LinkedBlockingQueue<I2CPMessage>();
        this._runner = runner;
        this._id = ++__id;
    }

    public void addMessage(I2CPMessage msg) {
        try {
            this._messagesToWrite.put(msg);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("[" + this._id + "] addMessage completed for " + msg.getClass().getName());
        }
    }

    public void stopWriting() {
        this._messagesToWrite.clear();
        try {
            this._messagesToWrite.put((I2CPMessage)new PoisonI2CPMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this._runner.getIsDead()) {
            I2CPMessage msg;
            try {
                msg = this._messagesToWrite.take();
            }
            catch (InterruptedException ie) {
                continue;
            }
            if (msg.getType() == 999999) break;
            this._runner.writeMessage(msg);
        }
    }
}

