/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.internal.InternalClientManager;
import net.i2p.router.Blocklist;
import net.i2p.router.ClientManagerFacade;
import net.i2p.router.ClientMessagePool;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.InNetMessagePool;
import net.i2p.router.JobQueue;
import net.i2p.router.KeyManager;
import net.i2p.router.MessageHistory;
import net.i2p.router.MessageValidator;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.OutNetMessagePool;
import net.i2p.router.PeerManagerFacade;
import net.i2p.router.PersistentKeyRing;
import net.i2p.router.ProfileManager;
import net.i2p.router.Router;
import net.i2p.router.RouterClock;
import net.i2p.router.RouterThrottle;
import net.i2p.router.RouterThrottleImpl;
import net.i2p.router.Shitlist;
import net.i2p.router.StatisticsManager;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.client.ClientManagerFacadeImpl;
import net.i2p.router.dummy.DummyNetworkDatabaseFacade;
import net.i2p.router.dummy.DummyPeerManagerFacade;
import net.i2p.router.dummy.DummyTunnelManagerFacade;
import net.i2p.router.dummy.VMCommSystem;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.peermanager.PeerManagerFacadeImpl;
import net.i2p.router.peermanager.ProfileManagerImpl;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.transport.CommSystemFacadeImpl;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.OutboundMessageRegistry;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.util.I2PProperties;
import net.i2p.util.KeyRing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterContext
extends I2PAppContext {
    private final Router _router;
    private ClientManagerFacadeImpl _clientManagerFacade;
    private ClientMessagePool _clientMessagePool;
    private JobQueue _jobQueue;
    private InNetMessagePool _inNetMessagePool;
    private OutNetMessagePool _outNetMessagePool;
    private MessageHistory _messageHistory;
    private OutboundMessageRegistry _messageRegistry;
    private NetworkDatabaseFacade _netDb;
    private KeyManager _keyManager;
    private CommSystemFacade _commSystem;
    private ProfileOrganizer _profileOrganizer;
    private PeerManagerFacade _peerManagerFacade;
    private ProfileManager _profileManager;
    private FIFOBandwidthLimiter _bandwidthLimiter;
    private TunnelManagerFacade _tunnelManager;
    private TunnelDispatcher _tunnelDispatcher;
    private StatisticsManager _statPublisher;
    private Shitlist _shitlist;
    private Blocklist _blocklist;
    private MessageValidator _messageValidator;
    private RouterThrottle _throttle;
    private final Set<Runnable> _finalShutdownTasks;
    private final Object _lock1 = new Object();
    private final Object _lock2 = new Object();
    private static List<RouterContext> _contexts = new ArrayList<RouterContext>(1);

    public RouterContext(Router router) {
        this(router, null);
    }

    public RouterContext(Router router, Properties envProps) {
        super(RouterContext.filterProps(envProps));
        this._router = router;
        if (!_contexts.isEmpty()) {
            System.err.println("Warning - More than one router in this JVM");
        }
        _contexts.add(this);
        this._finalShutdownTasks = new CopyOnWriteArraySet<Runnable>();
    }

    private static final Properties filterProps(Properties envProps) {
        if (envProps == null) {
            envProps = new Properties();
        }
        if (envProps.getProperty("time.disabled") == null) {
            envProps.setProperty("time.disabled", "false");
        }
        if (envProps.getProperty("prng.buffers") == null) {
            long maxMemory = Runtime.getRuntime().maxMemory();
            if (maxMemory == Long.MAX_VALUE) {
                maxMemory = 0x6000000L;
            }
            long buffs = Math.min(16L, Math.max(2L, maxMemory / 0xE00000L));
            envProps.setProperty("prng.buffers", "" + buffs);
        }
        return envProps;
    }

    public void setProperty(String propName, String value) {
        this._overrideProps.setProperty(propName, value);
    }

    void removeProperty(String propName) {
        this._overrideProps.remove((Object)propName);
    }

    public void addPropertyCallback(I2PProperties.I2PPropertyCallback callback) {
        this._overrideProps.addCallBack(callback);
    }

    public void initAll() {
        if (this.getBooleanProperty("i2p.dummyClientFacade")) {
            System.err.println("i2p.dummyClientFacade currently unsupported");
        }
        this._clientManagerFacade = new ClientManagerFacadeImpl(this);
        this._clientMessagePool = new ClientMessagePool(this);
        this._jobQueue = new JobQueue(this);
        this._inNetMessagePool = new InNetMessagePool(this);
        this._outNetMessagePool = new OutNetMessagePool(this);
        this._messageHistory = new MessageHistory(this);
        this._messageRegistry = new OutboundMessageRegistry(this);
        this._netDb = "false".equals(this.getProperty("i2p.dummyNetDb", "false")) ? new FloodfillNetworkDatabaseFacade(this) : new DummyNetworkDatabaseFacade(this);
        this._keyManager = new KeyManager(this);
        this._commSystem = "false".equals(this.getProperty("i2p.vmCommSystem", "false")) ? new CommSystemFacadeImpl(this) : new VMCommSystem(this);
        this._profileOrganizer = new ProfileOrganizer(this);
        this._peerManagerFacade = "false".equals(this.getProperty("i2p.dummyPeerManager", "false")) ? new PeerManagerFacadeImpl(this) : new DummyPeerManagerFacade();
        this._profileManager = new ProfileManagerImpl(this);
        this._bandwidthLimiter = new FIFOBandwidthLimiter(this);
        this._tunnelManager = "false".equals(this.getProperty("i2p.dummyTunnelManager", "false")) ? new TunnelPoolManager(this) : new DummyTunnelManagerFacade();
        this._tunnelDispatcher = new TunnelDispatcher(this);
        this._statPublisher = new StatisticsManager(this);
        this._shitlist = new Shitlist(this);
        this._blocklist = new Blocklist(this);
        this._messageValidator = new MessageValidator(this);
        this._throttle = new RouterThrottleImpl(this);
    }

    public static List<RouterContext> listContexts() {
        return Collections.unmodifiableList(_contexts);
    }

    static List<RouterContext> getContexts() {
        return _contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void killGlobalContext() {
        Class<I2PAppContext> clazz = I2PAppContext.class;
        synchronized (I2PAppContext.class) {
            _globalAppContext = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public Router router() {
        return this._router;
    }

    public Hash routerHash() {
        if (this._router == null) {
            return null;
        }
        RouterInfo ri = this._router.getRouterInfo();
        if (ri == null) {
            return null;
        }
        return ri.getIdentity().getHash();
    }

    public ClientManagerFacade clientManager() {
        return this._clientManagerFacade;
    }

    public ClientMessagePool clientMessagePool() {
        return this._clientMessagePool;
    }

    public InNetMessagePool inNetMessagePool() {
        return this._inNetMessagePool;
    }

    public OutNetMessagePool outNetMessagePool() {
        return this._outNetMessagePool;
    }

    public MessageHistory messageHistory() {
        return this._messageHistory;
    }

    public OutboundMessageRegistry messageRegistry() {
        return this._messageRegistry;
    }

    public NetworkDatabaseFacade netDb() {
        return this._netDb;
    }

    public JobQueue jobQueue() {
        return this._jobQueue;
    }

    public KeyManager keyManager() {
        return this._keyManager;
    }

    public CommSystemFacade commSystem() {
        return this._commSystem;
    }

    public ProfileOrganizer profileOrganizer() {
        return this._profileOrganizer;
    }

    public PeerManagerFacade peerManager() {
        return this._peerManagerFacade;
    }

    public ProfileManager profileManager() {
        return this._profileManager;
    }

    public FIFOBandwidthLimiter bandwidthLimiter() {
        return this._bandwidthLimiter;
    }

    public TunnelManagerFacade tunnelManager() {
        return this._tunnelManager;
    }

    public TunnelDispatcher tunnelDispatcher() {
        return this._tunnelDispatcher;
    }

    public StatisticsManager statPublisher() {
        return this._statPublisher;
    }

    public Shitlist shitlist() {
        return this._shitlist;
    }

    public Blocklist blocklist() {
        return this._blocklist;
    }

    public MessageValidator messageValidator() {
        return this._messageValidator;
    }

    public RouterThrottle throttle() {
        return this._throttle;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("RouterContext: ").append(super.toString()).append('\n');
        buf.append(this._router).append('\n');
        buf.append(this._clientManagerFacade).append('\n');
        buf.append(this._clientMessagePool).append('\n');
        buf.append(this._jobQueue).append('\n');
        buf.append(this._inNetMessagePool).append('\n');
        buf.append(this._outNetMessagePool).append('\n');
        buf.append(this._messageHistory).append('\n');
        buf.append(this._messageRegistry).append('\n');
        buf.append(this._netDb).append('\n');
        buf.append(this._keyManager).append('\n');
        buf.append(this._commSystem).append('\n');
        buf.append(this._profileOrganizer).append('\n');
        buf.append(this._peerManagerFacade).append('\n');
        buf.append(this._profileManager).append('\n');
        buf.append(this._bandwidthLimiter).append('\n');
        buf.append(this._tunnelManager).append('\n');
        buf.append(this._statPublisher).append('\n');
        buf.append(this._shitlist).append('\n');
        buf.append(this._messageValidator).append('\n');
        return buf.toString();
    }

    public String getProperty(String propName) {
        String val;
        if (this._router != null && (val = this._router.getConfigSetting(propName)) != null) {
            return val;
        }
        return super.getProperty(propName);
    }

    public String getProperty(String propName, String defaultVal) {
        String val;
        if (this._router != null && (val = this._router.getConfigSetting(propName)) != null) {
            return val;
        }
        return super.getProperty(propName, defaultVal);
    }

    public int getProperty(String propName, int defaultVal) {
        String val;
        if (this._router != null && (val = this._router.getConfigSetting(propName)) != null) {
            int ival = defaultVal;
            try {
                ival = Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            return ival;
        }
        return super.getProperty(propName, defaultVal);
    }

    public Properties getProperties() {
        Properties rv = super.getProperties();
        if (this._router != null) {
            rv.putAll(this._router.getConfigMap());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeClock() {
        Object object = this._lock1;
        synchronized (object) {
            if (this._clock == null) {
                this._clock = new RouterClock(this);
            }
            this._clockInitialized = true;
        }
    }

    public KeyRing keyRing() {
        if (!this._keyRingInitialized) {
            this.initializeKeyRing();
        }
        return this._keyRing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeKeyRing() {
        Object object = this._lock2;
        synchronized (object) {
            if (this._keyRing == null) {
                this._keyRing = new PersistentKeyRing(this);
            }
            this._keyRingInitialized = true;
        }
    }

    void removeShutdownTasks() {
        this._shutdownTasks.clear();
    }

    public void addFinalShutdownTask(Runnable task) {
        this._finalShutdownTasks.add(task);
    }

    Set<Runnable> getFinalShutdownTasks() {
        return this._finalShutdownTasks;
    }

    public boolean isRouterContext() {
        return true;
    }

    public InternalClientManager internalClientManager() {
        return this._clientManagerFacade;
    }
}

