/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutNetMessage {
    private final Log _log;
    private final RouterContext _context;
    private RouterInfo _target;
    private I2NPMessage _message;
    private String _messageType;
    private int _messageTypeId;
    private long _messageId;
    private long _messageSize;
    private int _priority;
    private long _expiration;
    private Job _onSend;
    private Job _onFailedSend;
    private ReplyJob _onReply;
    private Job _onFailedReply;
    private MessageSelector _replySelector;
    private Set<String> _failedTransports;
    private long _sendBegin;
    private final long _created;
    private HashMap<String, Long> _timestamps;
    private List<String> _timestampOrder;
    private Object _preparationBuf;
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("HH:mm:ss.SSS");

    public OutNetMessage(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(OutNetMessage.class);
        this._priority = -1;
        this._expiration = -1L;
        this._created = context.clock().now();
        if (this._log.shouldLog(20)) {
            this.timestamp("Created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long timestamp(String eventName) {
        long now = this._context.clock().now();
        if (this._log.shouldLog(20)) {
            OutNetMessage outNetMessage = this;
            synchronized (outNetMessage) {
                this.locked_initTimestamps();
                this._timestamps.put(eventName, now);
                this._timestampOrder.add(eventName);
            }
        }
        return now - this._created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getTimestamps() {
        if (this._log.shouldLog(20)) {
            OutNetMessage outNetMessage = this;
            synchronized (outNetMessage) {
                this.locked_initTimestamps();
                return (Map)this._timestamps.clone();
            }
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTimestamp(String eventName) {
        if (this._log.shouldLog(20)) {
            OutNetMessage outNetMessage = this;
            synchronized (outNetMessage) {
                this.locked_initTimestamps();
                return this._timestamps.get(eventName);
            }
        }
        return 0L;
    }

    private void locked_initTimestamps() {
        if (this._timestamps == null) {
            this._timestamps = new HashMap(8);
            this._timestampOrder = new ArrayList<String>(8);
        }
    }

    public Exception getCreatedBy() {
        return null;
    }

    public RouterInfo getTarget() {
        return this._target;
    }

    public void setTarget(RouterInfo target) {
        this._target = target;
    }

    public I2NPMessage getMessage() {
        return this._message;
    }

    public void setMessage(I2NPMessage msg) {
        this._message = msg;
        if (msg != null) {
            this._messageType = msg.getClass().getSimpleName();
            this._messageTypeId = msg.getType();
            this._messageId = msg.getUniqueId();
            this._messageSize = this._message.getMessageSize();
        }
    }

    public String getMessageType() {
        return this._messageType;
    }

    public int getMessageTypeId() {
        return this._messageTypeId;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public long getMessageSize() {
        if (this._messageSize <= 0L) {
            this._messageSize = this._message.getMessageSize();
        }
        return this._messageSize;
    }

    public int getMessageData(byte[] outBuffer) {
        if (this._message == null) {
            return -1;
        }
        int len = this._message.toByteArray(outBuffer);
        this._messageSize = len;
        return len;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long expiration) {
        this._expiration = expiration;
    }

    public Job getOnSendJob() {
        return this._onSend;
    }

    public void setOnSendJob(Job job) {
        this._onSend = job;
    }

    public Job getOnFailedSendJob() {
        return this._onFailedSend;
    }

    public void setOnFailedSendJob(Job job) {
        this._onFailedSend = job;
    }

    public ReplyJob getOnReplyJob() {
        return this._onReply;
    }

    public void setOnReplyJob(ReplyJob job) {
        this._onReply = job;
    }

    public Job getOnFailedReplyJob() {
        return this._onFailedReply;
    }

    public void setOnFailedReplyJob(Job job) {
        this._onFailedReply = job;
    }

    public MessageSelector getReplySelector() {
        return this._replySelector;
    }

    public void setReplySelector(MessageSelector selector) {
        this._replySelector = selector;
    }

    public void transportFailed(String transportStyle) {
        if (this._failedTransports == null) {
            this._failedTransports = new HashSet<String>(2);
        }
        this._failedTransports.add(transportStyle);
    }

    public Set getFailedTransports() {
        return this._failedTransports == null ? Collections.EMPTY_SET : this._failedTransports;
    }

    public long getSendBegin() {
        return this._sendBegin;
    }

    public void beginSend() {
        this._sendBegin = this._context.clock().now();
    }

    public void prepared(Object buf) {
        this._preparationBuf = buf;
    }

    public Object releasePreparationBuffer() {
        Object rv = this._preparationBuf;
        this._preparationBuf = null;
        return rv;
    }

    public long getCreated() {
        return this._created;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._created;
    }

    public long getSendTime() {
        return this._context.clock().now() - this._sendBegin;
    }

    public void discardData() {
        if (this._message != null && this._messageSize <= 0L) {
            this._messageSize = this._message.getMessageSize();
        }
        if (this._log.shouldLog(10)) {
            long timeToDiscard = this._context.clock().now() - this._created;
            this._log.debug("Discard " + this._messageSize + "byte " + this._messageType + " message after " + timeToDiscard);
        }
        this._message = null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("[OutNetMessage containing ");
        if (this._message == null) {
            buf.append("*no message*");
        } else {
            buf.append("a ").append(this._messageSize).append(" byte ");
            buf.append(this._messageType);
        }
        buf.append(" expiring on ").append(new Date(this._expiration));
        if (this._failedTransports != null) {
            buf.append(" failed delivery on transports ").append(this._failedTransports);
        }
        if (this._target == null) {
            buf.append(" targetting no one in particular...");
        } else {
            buf.append(" targetting ").append(this._target.getIdentity().getHash().toBase64());
        }
        if (this._onReply != null) {
            buf.append(" with onReply job: ").append(this._onReply);
        }
        if (this._onSend != null) {
            buf.append(" with onSend job: ").append(this._onSend);
        }
        if (this._onFailedReply != null) {
            buf.append(" with onFailedReply job: ").append(this._onFailedReply);
        }
        if (this._onFailedSend != null) {
            buf.append(" with onFailedSend job: ").append(this._onFailedSend);
        }
        if (this._log.shouldLog(20)) {
            buf.append(" {timestamps: \n");
            this.renderTimestamps(buf);
            buf.append("}");
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTimestamps(StringBuilder buf) {
        OutNetMessage outNetMessage = this;
        synchronized (outNetMessage) {
            long lastWhen = -1L;
            for (int i = 0; i < this._timestampOrder.size(); ++i) {
                String name = this._timestampOrder.get(i);
                Long when = this._timestamps.get(name);
                buf.append("\t[");
                long diff = when - lastWhen;
                if (lastWhen > 0L && diff > 500L) {
                    buf.append("**");
                }
                if (lastWhen > 0L) {
                    buf.append(diff);
                } else {
                    buf.append(0);
                }
                buf.append("ms: \t").append(name);
                buf.append('=').append(OutNetMessage.formatDate(when));
                buf.append("]\n");
                lastWhen = when;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatDate(long when) {
        Date d = new Date(when);
        SimpleDateFormat simpleDateFormat = _fmt;
        synchronized (simpleDateFormat) {
            return _fmt.format(d);
        }
    }
}

