/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.router.Router;
import net.i2p.util.Log;

public class MultiRouter {
    private static Log _log;
    private static ArrayList _routers;
    private static I2PAppContext _defaultContext;

    public static void main(String[] args) {
        int i;
        if (args == null || args.length <= 1) {
            MultiRouter.usage();
            return;
        }
        _defaultContext = new I2PAppContext(MultiRouter.getEnv(args[0]));
        _log = _defaultContext.logManager().getLog(MultiRouter.class);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        _defaultContext.clock().setOffset(0L);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Thread.currentThread().setName("Router* Shutdown");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(-1);
            }
        });
        for (i = 1; i < args.length; ++i) {
            Router router = new Router(MultiRouter.getEnv(args[i]));
            router.setKillVMOnEnd(false);
            _routers.add(router);
            _log.info("Router " + i + " created from " + args[i]);
        }
        for (i = 0; i < _routers.size(); ++i) {
            Router r = (Router)_routers.get(i);
            long offset = r.getContext().random().nextLong(30000L);
            if (r.getContext().random().nextBoolean()) {
                offset = 0L - offset;
            }
            r.getContext().clock().setOffset(offset, true);
            r.runRouter();
            _log.info("Router " + i + " started with clock offset " + offset);
            try {
                Thread.sleep(2000 + new Random().nextInt(2) * 1000);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        _log.info("All " + _routers.size() + " routers started up");
        MultiRouter.waitForCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getEnv(String filename) {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            props.load(in);
            props.setProperty("time.disabled", "true");
            Properties properties = props;
            return properties;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Properties properties = null;
            return properties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static void waitForCompletion() {
        while (true) {
            int alive = 0;
            for (int i = 0; i < _routers.size(); ++i) {
                Router r = (Router)_routers.get(i);
                if (!r.isAlive()) {
                    if (!_log.shouldLog(20)) continue;
                    _log.info("Router " + i + " is dead");
                    continue;
                }
                ++alive;
            }
            if (alive <= 0) break;
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        _log.info("All routers shut down");
    }

    private static void usage() {
        System.err.println("Usage: MultiRouter globalContextFile routerContextFile[ routerContextFile]*");
        System.err.println("       The context files contain key=value entries specifying properties");
        System.err.println("       to load into the given context.  In addition, each routerContextFile");
        System.err.println("       in turn is used to boot a router");
    }

    static {
        _routers = new ArrayList(8);
    }
}

