/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.util.DecayingBloomFilter;
import net.i2p.util.DecayingHashSet;
import net.i2p.util.Log;

public class MessageValidator {
    private final Log _log;
    private final RouterContext _context;
    private DecayingBloomFilter _filter;
    private static final long TIME_MASK = -1024L;

    public MessageValidator(RouterContext context) {
        this._log = context.logManager().getLog(MessageValidator.class);
        this._context = context;
        context.statManager().createRateStat("router.duplicateMessageId", "Note that a duplicate messageId was received", "Router", new long[]{600000L, 3600000L, 10800000L, 86400000L});
        context.statManager().createRateStat("router.invalidMessageTime", "Note that a message outside the valid range was received", "Router", new long[]{600000L, 3600000L, 10800000L, 86400000L});
    }

    public String validateMessage(long messageId, long expiration) {
        String msg = this.validateMessage(expiration);
        if (msg != null) {
            return msg;
        }
        boolean isDuplicate = this.noteReception(messageId, expiration);
        if (isDuplicate) {
            if (this._log.shouldLog(20)) {
                this._log.info("Rejecting message " + messageId + " because it is a duplicate", (Throwable)new Exception("Duplicate origin"));
            }
            this._context.statManager().addRateData("router.duplicateMessageId", 1L, 0L);
            return "duplicate";
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Accepting message " + messageId + " because it is NOT a duplicate", (Throwable)new Exception("Original origin"));
        }
        return null;
    }

    public String validateMessage(long expiration) {
        long now = this._context.clock().now();
        if (now - 60000L >= expiration) {
            if (this._log.shouldLog(20)) {
                this._log.info("Rejecting message because it expired " + (now - expiration) + "ms ago");
            }
            this._context.statManager().addRateData("router.invalidMessageTime", now - expiration, 0L);
            return "expired " + (now - expiration) + "ms ago";
        }
        if (now + 240000L < expiration) {
            if (this._log.shouldLog(20)) {
                this._log.info("Rejecting message because it will expire too far in the future (" + (expiration - now) + "ms)");
            }
            this._context.statManager().addRateData("router.invalidMessageTime", now - expiration, 0L);
            return "expire too far in the future (" + (expiration - now) + "ms)";
        }
        return null;
    }

    private boolean noteReception(long messageId, long messageExpiration) {
        long val = messageId;
        boolean dup = this._filter.add(val ^= messageExpiration & 0xFFFFFFFFFFFFFC00L);
        if (dup && this._log.shouldLog(30)) {
            this._log.warn("Duplicate with " + this._filter.getCurrentDuplicateCount() + " other dups, " + this._filter.getInsertedCount() + " other entries, and a false positive rate of " + this._filter.getFalsePositiveRate());
        }
        return dup;
    }

    public void startup() {
        this._filter = new DecayingHashSet((I2PAppContext)this._context, 120000, 8, "RouterMV");
    }

    void shutdown() {
        this._filter.stopDecaying();
    }
}

