/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSServerFactory;
import net.i2p.util.EventDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2PSOCKSTunnel
extends I2PTunnelClientBase {
    private HashMap<String, List<String>> proxies = null;
    protected Destination outProxyDest = null;
    public static final String PROP_PROXY_PREFIX = "i2ptunnel.socks.proxy.";
    public static final String DEFAULT = "default";
    public static final String PROP_PROXY_DEFAULT = "i2ptunnel.socks.proxy.default";

    public I2PSOCKSTunnel(int localPort, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) {
        super(localPort, ownDest, l, notifyThis, "SOCKS Proxy on " + tunnel.listenHost + ':' + localPort, tunnel, pkf);
        if (this.waitEventValue("openBaseClientResult").equals("error")) {
            this.notifyEvent("openSOCKSTunnelResult", "error");
            return;
        }
        this.setName("SOCKS Proxy on " + tunnel.listenHost + ':' + localPort);
        this.parseOptions();
        this.startRunning();
        this.notifyEvent("openSOCKSTunnelResult", "ok");
    }

    @Override
    protected void clientConnectionRun(Socket s) {
        try {
            SOCKSServer serv = SOCKSServerFactory.createSOCKSServer(s, this.getTunnel().getClientOptions());
            Socket clientSock = serv.getClientSocket();
            I2PSocket destSock = serv.getDestinationI2PSocket(this);
            new I2PTunnelRunner(clientSock, destSock, this.sockLock, null, this.mySockets);
        }
        catch (SOCKSException e) {
            this._log.error("Error from SOCKS connection", e);
            I2PSOCKSTunnel.closeSocket(s);
        }
    }

    private void parseOptions() {
        Properties opts = this.getTunnel().getClientOptions();
        this.proxies = new HashMap(1);
        for (Map.Entry<Object, Object> e : opts.entrySet()) {
            String prop = (String)e.getKey();
            if (!prop.startsWith(PROP_PROXY_PREFIX) || prop.length() <= PROP_PROXY_PREFIX.length()) continue;
            String port = prop.substring(PROP_PROXY_PREFIX.length());
            ArrayList<String> proxyList = new ArrayList<String>(1);
            StringTokenizer tok = new StringTokenizer((String)e.getValue(), ", \t");
            while (tok.hasMoreTokens()) {
                String proxy = tok.nextToken().trim();
                if (proxy.endsWith(".i2p")) {
                    proxyList.add(proxy);
                    continue;
                }
                this._log.error("Non-i2p SOCKS outproxy: " + proxy);
            }
            this.proxies.put(port, proxyList);
        }
    }

    public HashMap<String, List<String>> getProxyMap() {
        return this.proxies;
    }

    public List<String> getProxies(int port) {
        List<String> rv = this.proxies.get(port + "");
        if (rv == null) {
            rv = this.getDefaultProxies();
        }
        return rv;
    }

    public List<String> getDefaultProxies() {
        return this.proxies.get(DEFAULT);
    }

    public I2PSocketOptions buildOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }
}

