/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.localServer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.NamingService;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnelHTTPClient;
import net.i2p.util.FileUtil;
import net.i2p.util.Translate;

public abstract class LocalHTTPServer {
    private static final byte[] ERR_404 = "HTTP/1.1 404 Not Found\r\nContent-Type: text/plain\r\n\r\nHTTP Proxy local file not found".getBytes();
    private static final byte[] ERR_ADD = "HTTP/1.1 409 Bad\r\nContent-Type: text/plain\r\n\r\nAdd to addressbook failed - bad parameters".getBytes();
    private static final String BUNDLE_NAME = "net.i2p.i2ptunnel.web.messages";

    public static void serveLocalFile(OutputStream out, String method, String targetRequest, String query, String proxyNonce) {
        if (targetRequest.equals("/")) {
            try {
                out.write("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nCache-Control: max-age=86400\r\n\r\nI2P HTTP proxy OK".getBytes());
                out.flush();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        if ((method.equals("GET") || method.equals("HEAD")) && targetRequest.startsWith("/themes/") && !targetRequest.contains("..")) {
            File themesDir;
            File file;
            String filename = null;
            try {
                filename = targetRequest.substring(8);
            }
            catch (IndexOutOfBoundsException ioobe) {
                return;
            }
            if (filename.startsWith("console/default/")) {
                filename = filename.replaceFirst("default", I2PAppContext.getGlobalContext().getProperty("routerconsole.theme", "light"));
            }
            if ((file = new File(themesDir = new File(I2PAppContext.getGlobalContext().getBaseDir(), "docs/themes"), filename)).exists() && !file.isDirectory()) {
                String type = filename.endsWith(".css") ? "text/css" : (filename.endsWith(".ico") ? "image/x-icon" : (filename.endsWith(".png") ? "image/png" : (filename.endsWith(".jpg") ? "image/jpeg" : "text/html")));
                try {
                    out.write("HTTP/1.1 200 OK\r\nContent-Type: ".getBytes());
                    out.write(type.getBytes());
                    out.write("\r\nCache-Control: max-age=86400\r\n\r\n".getBytes());
                    FileUtil.readFile(filename, themesDir.getAbsolutePath(), out);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
        }
        if (targetRequest.equals("/add")) {
            HashMap<String, String> opts = new HashMap<String, String>(8);
            StringTokenizer tok = new StringTokenizer(query, "=&;");
            while (tok.hasMoreTokens()) {
                String k = tok.nextToken();
                if (!tok.hasMoreTokens()) break;
                String v = tok.nextToken();
                opts.put(LocalHTTPServer.decode(k), LocalHTTPServer.decode(v));
            }
            String url = (String)opts.get("url");
            String host = (String)opts.get("host");
            String b64Dest = (String)opts.get("dest");
            String nonce = (String)opts.get("nonce");
            String book = "privatehosts.txt";
            if (opts.get("master") != null) {
                book = "userhosts.txt";
            } else if (opts.get("router") != null) {
                book = "hosts.txt";
            }
            Destination dest = null;
            if (b64Dest != null) {
                try {
                    dest = new Destination(b64Dest);
                }
                catch (DataFormatException dfe) {
                    System.err.println("Bad dest to save?" + b64Dest);
                }
            }
            if (proxyNonce.equals(nonce) && url != null && host != null && dest != null) {
                try {
                    NamingService ns = I2PAppContext.getGlobalContext().namingService();
                    Properties nsOptions = new Properties();
                    nsOptions.setProperty("list", book);
                    nsOptions.setProperty("s", LocalHTTPServer._("Added via address helper"));
                    boolean success = ns.put(host, dest, nsOptions);
                    LocalHTTPServer.writeRedirectPage(out, success, host, book, url);
                    return;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            try {
                out.write(ERR_ADD);
                out.flush();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        try {
            out.write(ERR_404);
            out.flush();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private static void writeRedirectPage(OutputStream out, boolean success, String host, String book, String url) throws IOException {
        out.write(("HTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\n\r\n<html><head><title>" + LocalHTTPServer._("Redirecting to {0}", host) + "</title>\n" + "<link rel=\"shortcut icon\" href=\"http://proxy.i2p/themes/console/images/favicon.ico\" >\n" + "<link href=\"http://proxy.i2p/themes/console/default/console.css\" rel=\"stylesheet\" type=\"text/css\" >\n" + "<meta http-equiv=\"Refresh\" content=\"1; url=" + url + "\">\n" + "</head><body>\n" + "<div class=logo>\n" + "<a href=\"http://127.0.0.1:7657/\" title=\"" + LocalHTTPServer._("Router Console") + "\"><img src=\"http://proxy.i2p/themes/console/images/i2plogo.png\" alt=\"I2P Router Console\" border=\"0\"></a><hr>\n" + "<a href=\"http://127.0.0.1:7657/config\">" + LocalHTTPServer._("Configuration") + "</a> <a href=\"http://127.0.0.1:7657/help.jsp\">" + LocalHTTPServer._("Help") + "</a> <a href=\"http://127.0.0.1:7657/susidns/index\">" + LocalHTTPServer._("Addressbook") + "</a>\n" + "</div>" + "<div class=warning id=warning>\n" + "<h3>" + (success ? LocalHTTPServer._("Saved {0} to the {1} addressbook, redirecting now.", host, book) : LocalHTTPServer._("Failed to save {0} to the {1} addressbook, redirecting now.", host, book)) + "</h3>\n<p><a href=\"" + url + "\">" + LocalHTTPServer._("Click here if you are not redirected automatically.") + "</a></p></div>").getBytes("UTF-8"));
        I2PTunnelHTTPClient.writeFooter(out);
        out.flush();
    }

    public static String decode(String s) {
        if (!s.contains("%")) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '%') {
                buf.append(c);
                continue;
            }
            try {
                buf.append((char)Integer.parseInt(s.substring(++i, ++i + 1), 16));
                continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                break;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        return buf.toString();
    }

    protected static String _(String key) {
        return Translate.getString(key, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    protected static String _(String key, Object o) {
        return Translate.getString(key, o, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    protected static String _(String key, Object o, Object o2) {
        return Translate.getString(key, o, o2, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }
}

