/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Base32;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.HTTPResponseOutputStream;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.I2PTunnelServer;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2PTunnelHTTPServer
extends I2PTunnelServer {
    private String _spoofHost;
    private static final String HASH_HEADER = "X-I2P-DestHash";
    private static final String DEST64_HEADER = "X-I2P-DestB64";
    private static final String DEST32_HEADER = "X-I2P-DestB32";
    private static final String[] CLIENT_SKIPHEADERS = new String[]{"X-I2P-DestHash", "X-I2P-DestB64", "X-I2P-DestB32"};
    private static final String SERVER_HEADER = "Server";
    private static final String[] SERVER_SKIPHEADERS = new String[]{"Server"};
    private static final long HEADER_TIMEOUT = 60000L;
    private static final long START_INTERVAL = 180000L;
    private long _startedOn = 0L;
    private static final byte[] ERR_UNAVAILABLE = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>503 Service Unavailable</title></head>\n<body><h2>503 Service Unavailable</h2>\n<p>This I2P eepsite is unavailable. It may be down or undergoing maintenance.</p>\n</body></html>".getBytes();
    private static final int MIN_TO_COMPRESS = 1300;
    private static final int MAX_HEADERS = 60;

    public I2PTunnelHTTPServer(InetAddress host, int port, String privData, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privData, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    public I2PTunnelHTTPServer(InetAddress host, int port, File privkey, String privkeyname, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privkey, privkeyname, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    public I2PTunnelHTTPServer(InetAddress host, int port, InputStream privData, String privkeyname, String spoofHost, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super(host, port, privData, privkeyname, l, notifyThis, tunnel);
        this.setupI2PTunnelHTTPServer(spoofHost);
    }

    private void setupI2PTunnelHTTPServer(String spoofHost) {
        this._spoofHost = spoofHost != null && spoofHost.trim().length() > 0 ? spoofHost.trim() : null;
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpserver.blockingHandleTime", "how long the blocking handle takes to complete", "I2PTunnel.HTTPServer", new long[]{60000L, 600000L, 10800000L});
        this.getTunnel().getContext().statManager().createRateStat("i2ptunnel.httpNullWorkaround", "How often an http server works around a streaming lib or i2ptunnel bug", "I2PTunnel.HTTPServer", new long[]{60000L, 600000L});
    }

    @Override
    public void startRunning() {
        super.startRunning();
        this._startedOn = this.getTunnel().getContext().clock().now();
    }

    @Override
    protected void blockingHandle(I2PSocket socket) {
        block23: {
            if (this._log.shouldLog(20)) {
                this._log.info("Incoming connection to '" + this.toString() + "' port " + socket.getLocalPort() + " from: " + socket.getPeerDestination().calculateHash() + " port " + socket.getPort());
            }
            long afterAccept = this.getTunnel().getContext().clock().now();
            long afterSocket = -1L;
            try {
                boolean useGZIP;
                String val;
                String portSpoof;
                socket.setReadTimeout(60000L);
                InputStream in = socket.getInputStream();
                StringBuilder command = new StringBuilder(128);
                Map<String, List<String>> headers = I2PTunnelHTTPServer.readHeaders(in, command, CLIENT_SKIPHEADERS, this.getTunnel().getContext());
                I2PTunnelHTTPServer.addEntry(headers, HASH_HEADER, socket.getPeerDestination().calculateHash().toBase64());
                I2PTunnelHTTPServer.addEntry(headers, DEST32_HEADER, Base32.encode(socket.getPeerDestination().calculateHash().getData()) + ".b32.i2p");
                I2PTunnelHTTPServer.addEntry(headers, DEST64_HEADER, socket.getPeerDestination().toBase64());
                Properties opts = this.getTunnel().getClientOptions();
                int ourPort = socket.getLocalPort();
                String spoofHost = ourPort != 80 && ourPort > 0 && ourPort <= 65535 && opts != null ? ((portSpoof = opts.getProperty("spoofedHost." + ourPort)) != null ? portSpoof.trim() : this._spoofHost) : this._spoofHost;
                if (spoofHost != null) {
                    I2PTunnelHTTPServer.setEntry(headers, "Host", spoofHost);
                }
                I2PTunnelHTTPServer.setEntry(headers, "Connection", "close");
                String enc = I2PTunnelHTTPServer.getEntryOrNull(headers, "Accept-encoding");
                String altEnc = I2PTunnelHTTPServer.getEntryOrNull(headers, "X-Accept-encoding");
                I2PTunnelHTTPServer.setEntry(headers, "Accept-encoding", "");
                socket.setReadTimeout(this.readTimeout);
                Socket s = new Socket(this.remoteHost, this.remotePort);
                afterSocket = this.getTunnel().getContext().clock().now();
                boolean allowGZIP = true;
                if (opts != null && (val = opts.getProperty("i2ptunnel.gzip")) != null && !Boolean.valueOf(val).booleanValue()) {
                    allowGZIP = false;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("HTTP server encoding header: " + enc + "/" + altEnc);
                }
                boolean alt = altEnc != null && altEnc.indexOf("x-i2p-gzip") >= 0;
                boolean bl = useGZIP = alt || enc != null && enc.indexOf("x-i2p-gzip") >= 0;
                if (alt) {
                    headers.remove("X-Accept-encoding");
                }
                String modifiedHeader = I2PTunnelHTTPServer.formatHeaders(headers, command);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Modified header: [" + modifiedHeader + "]");
                }
                if (allowGZIP && useGZIP) {
                    I2PAppThread req = new I2PAppThread(new CompressedRequestor(s, socket, modifiedHeader, this.getTunnel().getContext(), this._log), Thread.currentThread().getName() + ".hc");
                    req.start();
                } else {
                    new I2PTunnelRunner(s, socket, this.slock, null, modifiedHeader.getBytes(), null);
                }
                long afterHandle = this.getTunnel().getContext().clock().now();
                long timeToHandle = afterHandle - afterAccept;
                this.getTunnel().getContext().statManager().addRateData("i2ptunnel.httpserver.blockingHandleTime", timeToHandle, 0L);
                if (timeToHandle > 1000L && this._log.shouldLog(30)) {
                    this._log.warn("Took a while to handle the request for " + this.remoteHost + ':' + this.remotePort + " [" + timeToHandle + ", socket create: " + (afterSocket - afterAccept) + "]");
                }
            }
            catch (SocketException ex) {
                int level;
                try {
                    socket.getOutputStream().write(ERR_UNAVAILABLE);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                int n = level = this.getTunnel().getContext().clock().now() - this._startedOn > 180000L ? 40 : 30;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "Error connecting to HTTP server " + this.remoteHost + ':' + this.remotePort, ex);
                }
            }
            catch (IOException ex) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error while receiving the new HTTP request", ex);
                }
            }
            catch (OutOfMemoryError oom) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (!this._log.shouldLog(40)) break block23;
                this._log.error("OOM in HTTP server", oom);
            }
        }
    }

    protected static String formatHeaders(Map<String, List<String>> headers, StringBuilder command) {
        StringBuilder buf = new StringBuilder(command.length() + headers.size() * 64);
        buf.append(command.toString().trim()).append("\r\n");
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            String name = e.getKey();
            for (String val : e.getValue()) {
                buf.append(name.trim()).append(": ").append(val.trim()).append("\r\n");
            }
        }
        buf.append("\r\n");
        return buf.toString();
    }

    private static void addEntry(Map<String, List<String>> headers, String key, String value) {
        List<String> entry = headers.get(key);
        if (entry == null) {
            entry = new ArrayList<String>();
            headers.put(key, entry);
        }
        entry.add(value);
    }

    private static void setEntry(Map<String, List<String>> headers, String key, String value) {
        List<String> entry = headers.get(key);
        if (entry == null) {
            entry = new ArrayList<String>();
            headers.put(key, entry);
        }
        entry.clear();
        entry.add(value);
    }

    private static String getEntryOrNull(Map<String, List<String>> headers, String key) {
        List<String> entries = headers.get(key);
        if (entries == null || entries.size() < 1) {
            return null;
        }
        return entries.get(0);
    }

    protected static Map<String, List<String>> readHeaders(InputStream in, StringBuilder command, String[] skipHeaders, I2PAppContext ctx) throws IOException {
        int i;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        StringBuilder buf = new StringBuilder(128);
        boolean ok = DataHelper.readLine(in, command);
        if (!ok) {
            throw new IOException("EOF reached while reading the HTTP command [" + command.toString() + "]");
        }
        int trimmed = 0;
        if (command.length() > 0) {
            for (i = 0; i < command.length(); ++i) {
                if (command.charAt(i) != '\u0000') continue;
                command = command.deleteCharAt(i);
                --i;
                ++trimmed;
            }
        }
        if (trimmed > 0) {
            ctx.statManager().addRateData("i2ptunnel.httpNullWorkaround", trimmed, 0L);
        }
        i = 0;
        while (true) {
            if (++i > 60) {
                throw new IOException("Too many header lines - max 60");
            }
            buf.setLength(0);
            ok = DataHelper.readLine(in, buf);
            if (!ok) {
                throw new IOException("EOF reached before the end of the headers [" + buf.toString() + "]");
            }
            if (buf.length() == 0 || buf.charAt(0) == '\n' || buf.charAt(0) == '\r') {
                return headers;
            }
            int split = buf.indexOf(":");
            if (split <= 0) {
                throw new IOException("Invalid HTTP header, missing colon [" + buf.toString() + "]");
            }
            String name = buf.substring(0, split).trim();
            String value = null;
            value = buf.length() > split + 1 ? buf.substring(split + 1).trim() : "";
            if ("accept-encoding".equals(name.toLowerCase(Locale.US))) {
                name = "Accept-encoding";
            } else if ("x-accept-encoding".equals(name.toLowerCase(Locale.US))) {
                name = "X-Accept-encoding";
            }
            boolean skip = false;
            String lcName = name.toLowerCase(Locale.US);
            for (String skipHeader : skipHeaders) {
                if (!skipHeader.toLowerCase(Locale.US).equals(lcName)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            I2PTunnelHTTPServer.addEntry(headers, name, value);
        }
    }

    private static class CompressedRequestor
    implements Runnable {
        private final Socket _webserver;
        private final I2PSocket _browser;
        private final String _headers;
        private final I2PAppContext _ctx;
        private final Log _log;

        public CompressedRequestor(Socket webserver, I2PSocket browser, String headers, I2PAppContext ctx, Log log) {
            this._webserver = webserver;
            this._browser = browser;
            this._headers = headers;
            this._ctx = ctx;
            this._log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block44: {
                IOException ioe222222;
                InputStream serverin;
                InputStream browserin;
                OutputStream browserout;
                OutputStream serverout;
                block38: {
                    block37: {
                        if (this._log.shouldLog(20)) {
                            this._log.info("Compressed requestor running");
                        }
                        serverout = null;
                        browserout = null;
                        browserin = null;
                        serverin = null;
                        serverout = this._webserver.getOutputStream();
                        if (this._log.shouldLog(20)) {
                            this._log.info("request headers: " + this._headers);
                        }
                        serverout.write(this._headers.getBytes());
                        browserin = this._browser.getInputStream();
                        I2PAppThread sender = new I2PAppThread(new Sender(serverout, browserin, "server: browser to server", this._log), Thread.currentThread().getName() + "hcs");
                        sender.start();
                        browserout = this._browser.getOutputStream();
                        try {
                            serverin = this._webserver.getInputStream();
                        }
                        catch (NullPointerException npe) {
                            throw new IOException("getInputStream NPE");
                        }
                        CompressedResponseOutputStream compressedOut = new CompressedResponseOutputStream(browserout);
                        StringBuilder command = new StringBuilder(128);
                        Map<String, List<String>> headers = I2PTunnelHTTPServer.readHeaders(serverin, command, SERVER_SKIPHEADERS, this._ctx);
                        String modifiedHeaders = I2PTunnelHTTPServer.formatHeaders(headers, command);
                        compressedOut.write(modifiedHeaders.getBytes());
                        Sender s = new Sender(compressedOut, serverin, "server: server to browser", this._log);
                        if (this._log.shouldLog(20)) {
                            this._log.info("Before pumping the compressed response");
                        }
                        s.run();
                        if (!this._log.shouldLog(20)) break block37;
                        this._log.info("After pumping the compressed response: " + compressedOut.getTotalRead() + "/" + compressedOut.getTotalCompressed());
                    }
                    Object var12_13 = null;
                    if (browserout == null) break block38;
                    try {
                        browserout.close();
                    }
                    catch (IOException ioe222222) {
                        // empty catch block
                    }
                }
                if (serverout != null) {
                    try {
                        serverout.close();
                    }
                    catch (IOException ioe222222) {
                        // empty catch block
                    }
                }
                if (browserin != null) {
                    try {
                        browserin.close();
                    }
                    catch (IOException ioe222222) {
                        // empty catch block
                    }
                }
                if (serverin != null) {
                    try {
                        serverin.close();
                    }
                    catch (IOException ioe222222) {}
                }
                break block44;
                {
                    catch (IOException ioe3) {
                        IOException ioe222222;
                        if (this._log.shouldLog(30)) {
                            this._log.warn("error compressing", ioe3);
                        }
                        Object var12_14 = null;
                        if (browserout != null) {
                            try {
                                browserout.close();
                            }
                            catch (IOException ioe222222) {
                                // empty catch block
                            }
                        }
                        if (serverout != null) {
                            try {
                                serverout.close();
                            }
                            catch (IOException ioe222222) {
                                // empty catch block
                            }
                        }
                        if (browserin != null) {
                            try {
                                browserin.close();
                            }
                            catch (IOException ioe222222) {
                                // empty catch block
                            }
                        }
                        if (serverin != null) {
                            try {
                                serverin.close();
                            }
                            catch (IOException ioe222222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe222222;
                    Object var12_15 = null;
                    if (browserout != null) {
                        try {
                            browserout.close();
                        }
                        catch (IOException ioe222222) {
                            // empty catch block
                        }
                    }
                    if (serverout != null) {
                        try {
                            serverout.close();
                        }
                        catch (IOException ioe222222) {
                            // empty catch block
                        }
                    }
                    if (browserin != null) {
                        try {
                            browserin.close();
                        }
                        catch (IOException ioe222222) {
                            // empty catch block
                        }
                    }
                    if (serverin != null) {
                        try {
                            serverin.close();
                        }
                        catch (IOException ioe222222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private static class CompressedResponseOutputStream
    extends HTTPResponseOutputStream {
        private InternalGZIPOutputStream _gzipOut;

        public CompressedResponseOutputStream(OutputStream o) {
            super(o);
            this._dataExpected = -1L;
        }

        protected String filterResponseLine(String line) {
            String[] s = line.split(" ", 3);
            if (s.length > 1 && (s[1].startsWith("3") || s[1].startsWith("5"))) {
                this._dataExpected = 0L;
            }
            return line;
        }

        protected boolean shouldCompress() {
            return (this._dataExpected < 0L || this._dataExpected >= 1300L) && (this._contentType == null || !this._contentType.startsWith("audio/") && !this._contentType.startsWith("image/") && !this._contentType.startsWith("video/") && !this._contentType.equals("application/compress") && !this._contentType.equals("application/bzip2") && !this._contentType.equals("application/gzip") && !this._contentType.equals("application/x-bzip") && !this._contentType.equals("application/x-bzip2") && !this._contentType.equals("application/x-gzip") && !this._contentType.equals("application/zip"));
        }

        protected void finishHeaders() throws IOException {
            if (this.shouldCompress()) {
                this.out.write("Content-encoding: x-i2p-gzip\r\n".getBytes());
            }
            super.finishHeaders();
        }

        protected void beginProcessing() throws IOException {
            if (this.shouldCompress()) {
                this._gzipOut = new InternalGZIPOutputStream(this.out);
                this.out = this._gzipOut;
            }
        }

        public long getTotalRead() {
            InternalGZIPOutputStream gzipOut = this._gzipOut;
            if (gzipOut != null) {
                return gzipOut.getTotalRead();
            }
            return 0L;
        }

        public long getTotalCompressed() {
            InternalGZIPOutputStream gzipOut = this._gzipOut;
            if (gzipOut != null) {
                return gzipOut.getTotalCompressed();
            }
            return 0L;
        }
    }

    private static class InternalGZIPOutputStream
    extends GZIPOutputStream {
        public InternalGZIPOutputStream(OutputStream target) throws IOException {
            super(target);
        }

        public long getTotalRead() {
            try {
                return this.def.getTotalIn();
            }
            catch (Exception e) {
                return 0L;
            }
        }

        public long getTotalCompressed() {
            try {
                return this.def.getTotalOut();
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    private static class Sender
    implements Runnable {
        private final OutputStream _out;
        private final InputStream _in;
        private final String _name;
        private final Log _log;

        public Sender(OutputStream out, InputStream in, String name, Log log) {
            this._out = out;
            this._in = in;
            this._name = name;
            this._log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block24: {
                IOException ioe222;
                block22: {
                    block21: {
                        if (this._log.shouldLog(20)) {
                            this._log.info(this._name + ": Begin sending");
                        }
                        byte[] buf = new byte[16384];
                        int read = 0;
                        int total = 0;
                        while ((read = this._in.read(buf)) != -1) {
                            if (this._log.shouldLog(20)) {
                                this._log.info(this._name + ": read " + read + " and sending through the stream");
                            }
                            this._out.write(buf, 0, read);
                            total += read;
                        }
                        if (!this._log.shouldLog(20)) break block21;
                        this._log.info(this._name + ": Done sending: " + total);
                    }
                    Object var5_5 = null;
                    if (this._out == null) break block22;
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (this._in != null) {
                    try {
                        this._in.close();
                    }
                    catch (IOException ioe222) {}
                }
                break block24;
                {
                    catch (IOException ioe3) {
                        IOException ioe222;
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Error sending", ioe3);
                        }
                        Object var5_6 = null;
                        if (this._out != null) {
                            try {
                                this._out.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        if (this._in != null) {
                            try {
                                this._in.close();
                            }
                            catch (IOException ioe222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe222;
                    Object var5_7 = null;
                    if (this._out != null) {
                        try {
                            this._out.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (this._in != null) {
                        try {
                            this._in.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

