/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientBase;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientRunner;
import net.i2p.i2ptunnel.InternalSocketRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.localServer.LocalHTTPServer;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Translate;

public class I2PTunnelHTTPClient
extends I2PTunnelHTTPClientBase
implements Runnable {
    private final ConcurrentHashMap<String, String> addressHelpers = new ConcurrentHashMap(8);
    private final String _proxyNonce = Long.toString(this._context.random().nextLong());
    private static final byte[] ERR_REQUEST_DENIED = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>You attempted to connect to a non-I2P website or location.<BR>".getBytes();
    private static final byte[] ERR_DESTINATION_UNKNOWN = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>".getBytes();
    private static final byte[] _ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel".getBytes();
    private static final byte[] ERR_AHELPER_CONFLICT = "HTTP/1.1 409 Conflict\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: Destination key conflict</H1>The addresshelper link you followed specifies a different destination key than a host entry in your host database. Someone could be trying to impersonate another eepsite, or people have given two eepsites identical names.<p>You can resolve the conflict by considering which key you trust, and either discarding the addresshelper link, discarding the host entry from your host database, or naming one of them differently.<p>".getBytes();
    private static final byte[] ERR_AHELPER_NOTFOUND = "HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: Helper key not resolvable.</H1>The helper key you put for i2paddresshelper= is not resolvable. It seems to be garbage data, or a mistyped b32. Check your URL to try and fix the helper key to be either a b32 or a base64.".getBytes();
    private static final byte[] ERR_AHELPER_NEW = "HTTP/1.1 409 New Address\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>New Host Name with Address Helper</H1>The address helper link you followed is for a new host name that is not in your address book. You may either save the destination for this host name to your address book, or remember it only until your router restarts. If you save it to your address book, you will not see this message again. If you do not wish to visit this host, click the \"back\" button on your browser.".getBytes();
    private static final byte[] ERR_BAD_PROTOCOL = "HTTP/1.1 403 Bad Protocol\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: NON-HTTP PROTOCOL</H1>The request uses a bad protocol. The I2P HTTP Proxy supports http:// requests ONLY. Other protocols such as https:// and ftp:// are not allowed.<BR>".getBytes();
    private static final byte[] ERR_LOCALHOST = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>Your browser is misconfigured. Do not use the proxy to access the router console or other localhost destinations.<BR>".getBytes();
    private static final byte[] ERR_AUTH = "HTTP/1.1 407 Proxy Authentication Required\r\nContent-Type: text/html; charset=UTF-8\r\nCache-control: no-cache\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.5\r\nProxy-Authenticate: Basic realm=\"I2P HTTP Proxy\"\r\n\r\n<html><body><H1>I2P ERROR: PROXY AUTHENTICATION REQUIRED</H1>This proxy is configured to require authentication.<BR>".getBytes();
    private InternalSocketRunner isr;
    private static final String HELPER_PARAM = "i2paddresshelper";
    public static final String LOCAL_SERVER = "proxy.i2p";
    private static final boolean DEFAULT_GZIP = true;
    public static final String PROP_REFERER = "i2ptunnel.httpclient.sendReferer";
    public static final String PROP_USER_AGENT = "i2ptunnel.httpclient.sendUserAgent";
    public static final String PROP_VIA = "i2ptunnel.httpclient.sendVia";
    public static final String PROP_JUMP_SERVERS = "i2ptunnel.httpclient.jumpServers";
    public static final String PROP_DISABLE_HELPER = "i2ptunnel.httpclient.disableAddressHelper";
    public static final String DEFAULT_JUMP_SERVERS = "http://i2host.i2p/cgi-bin/i2hostjump?,http://stats.i2p/cgi-bin/jump.cgi?a=";
    private static final byte[] ERR_HELPER_DISABLED = "HTTP/1.1 403 Disabled\r\nContent-Type: text/plain\r\n\r\nAddress helpers disabled".getBytes();
    private static final String BUNDLE_NAME = "net.i2p.i2ptunnel.web.messages";

    public I2PTunnelHTTPClient(int localPort, Logging l, I2PSocketManager sockMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) {
        super(localPort, l, sockMgr, tunnel, notifyThis, clientId);
        this.setName("HTTP Proxy on " + this.getTunnel().listenHost + ':' + localPort);
        this.startRunning();
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    public I2PTunnelHTTPClient(int localPort, Logging l, boolean ownDest, String wwwProxy, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "HTTP Proxy on " + tunnel.listenHost + ':' + localPort + " #" + ++__clientId, tunnel);
        if (this.waitEventValue("openBaseClientResult").equals("error")) {
            this.notifyEvent("openHTTPClientResult", "error");
            return;
        }
        if (wwwProxy != null) {
            StringTokenizer tok = new StringTokenizer(wwwProxy, ", ");
            while (tok.hasMoreTokens()) {
                this._proxyList.add(tok.nextToken().trim());
            }
        }
        this.setName("HTTP Proxy on " + tunnel.listenHost + ':' + localPort);
        this.startRunning();
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "300000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "300000");
        }
        if (!defaultOpts.contains("i2p.streaming.inactivityTimeout")) {
            defaultOpts.setProperty("i2p.streaming.inactivityTimeout", "300000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    public void startRunning() {
        super.startRunning();
        this.isr = new InternalSocketRunner(this);
        this._context.portMapper().register("HTTP", this.getLocalPort());
    }

    public boolean close(boolean forced) {
        int reg = this._context.portMapper().getPort("HTTP");
        if (reg == this.getLocalPort()) {
            this._context.portMapper().unregister("HTTP");
        }
        boolean rv = super.close(forced);
        if (this.isr != null) {
            this.isr.stopRunning();
        }
        return rv;
    }

    protected void clientConnectionRun(Socket s) {
        OutputStream out = null;
        String targetRequest = null;
        boolean usingWWWProxy = false;
        boolean usingInternalServer = false;
        String internalPath = null;
        String internalRawQuery = null;
        String currentProxy = null;
        long requestId = ++__requestId;
        boolean shout = false;
        try {
            String line;
            out = s.getOutputStream();
            InputReader reader = new InputReader(s.getInputStream());
            String method = null;
            String protocol = null;
            String host = null;
            String destination = null;
            StringBuilder newRequest = new StringBuilder();
            boolean ahelperPresent = false;
            boolean ahelperNew = false;
            String ahelperKey = null;
            String userAgent = null;
            String authorization = null;
            int remotePort = 0;
            while ((line = reader.readLine(method)) != null) {
                String lowercaseLine;
                line = line.trim();
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix(requestId) + "Line=[" + line + "]");
                }
                if ((lowercaseLine = line.toLowerCase(Locale.US)).startsWith("connection: ") || lowercaseLine.startsWith("keep-alive: ") || lowercaseLine.startsWith("proxy-connection: ")) continue;
                if (method == null) {
                    boolean isValid;
                    String protocolVersion;
                    URI requestURI;
                    block135: {
                        String request;
                        String[] params;
                        block134: {
                            if (this._log.shouldLog(10)) {
                                this._log.debug(this.getPrefix(requestId) + "First line [" + line + "]");
                            }
                            if ((params = line.split(" ", 3)).length != 3) break;
                            request = params[1];
                            if (request.startsWith("/") && this.getTunnel().getClientOptions().getProperty("i2ptunnel.noproxy") != null) {
                                request = "http://i2p" + request;
                            } else if (request.startsWith("/eepproxy/")) {
                                String subRequest = request.substring("/eepproxy/".length());
                                if (subRequest.indexOf("/") == -1) {
                                    subRequest = subRequest + "/";
                                }
                                request = "http://" + subRequest;
                            }
                            try {
                                requestURI = new URI(request);
                                if (requestURI.getRawUserInfo() != null || requestURI.getRawFragment() != null) {
                                    if (this._log.shouldLog(30)) {
                                        this._log.warn(this.getPrefix(requestId) + "Removing userinfo or fragment [" + request + "]");
                                    }
                                    requestURI = I2PTunnelHTTPClient.changeURI(requestURI, null, 0, null);
                                }
                                if (requestURI.getPath() != null && requestURI.getPath().length() > 0) break block134;
                                if (this._log.shouldLog(30)) {
                                    this._log.warn(this.getPrefix(requestId) + "Adding / path to [" + request + "]");
                                }
                                requestURI = I2PTunnelHTTPClient.changeURI(requestURI, null, 0, "/");
                            }
                            catch (URISyntaxException use) {
                                if (!this._log.shouldLog(30)) break;
                                this._log.warn(this.getPrefix(requestId) + "Bad request [" + request + "]", use);
                                break;
                            }
                        }
                        method = params[0];
                        protocolVersion = params[2];
                        protocol = requestURI.getScheme();
                        host = requestURI.getHost();
                        if (protocol == null || host == null) {
                            this._log.warn("Null protocol or host: " + request);
                            method = null;
                            break;
                        }
                        int port = requestURI.getPort();
                        String hostLowerCase = host.toLowerCase(Locale.US);
                        if (hostLowerCase.equals(LOCAL_SERVER)) {
                            destination = host;
                            usingInternalServer = true;
                            internalPath = requestURI.getPath();
                            internalRawQuery = requestURI.getRawQuery();
                        } else {
                            String newURI;
                            if (hostLowerCase.equals("i2p")) {
                                String oldPath = requestURI.getPath().substring(1);
                                int slash = oldPath.indexOf("/");
                                if (slash < 0) {
                                    slash = oldPath.length();
                                    oldPath = oldPath + "/";
                                }
                                String _dest = oldPath.substring(0, slash);
                                if (slash >= 516 && !_dest.contains(".")) {
                                    destination = _dest;
                                    host = this.getHostName(destination);
                                    targetRequest = requestURI.toASCIIString();
                                    newURI = oldPath.substring(slash);
                                    String query = requestURI.getRawQuery();
                                    if (query != null) {
                                        newURI = newURI + '?' + query;
                                    }
                                    try {
                                        requestURI = new URI(newURI);
                                        break block135;
                                    }
                                    catch (URISyntaxException use) {
                                        this._log.warn(request, use);
                                        method = null;
                                        break;
                                    }
                                }
                                this._log.warn("Bad http://i2p/b64dest " + request);
                                host = null;
                                break;
                            }
                            if (hostLowerCase.endsWith(".i2p")) {
                                String addressHelper;
                                destination = host;
                                host = this.getHostName(destination);
                                int rPort = requestURI.getPort();
                                remotePort = rPort > 0 ? rPort : 80;
                                String query = requestURI.getRawQuery();
                                if (query != null) {
                                    byte[] header;
                                    boolean ahelperConflict = false;
                                    String[] helperStrings = I2PTunnelHTTPClient.removeHelper(query);
                                    if (helperStrings != null && !Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER)).booleanValue()) {
                                        query = helperStrings[0];
                                        if (query.equals("")) {
                                            query = null;
                                        }
                                        try {
                                            requestURI = I2PTunnelHTTPClient.replaceQuery(requestURI, query);
                                        }
                                        catch (URISyntaxException use) {
                                            this._log.warn(request, use);
                                            method = null;
                                            break;
                                        }
                                        ahelperKey = helperStrings[1];
                                        if (ahelperKey.length() > 0) {
                                            if (ahelperKey.endsWith(".i2p")) {
                                                Destination _dest = this._context.namingService().lookup(ahelperKey);
                                                if (_dest == null) {
                                                    if (this._log.shouldLog(30)) {
                                                        this._log.warn(this.getPrefix(requestId) + "Could not find destination for " + ahelperKey);
                                                    }
                                                    header = this.getErrorPage("ahelper-notfound", ERR_AHELPER_NOTFOUND);
                                                    out.write(header);
                                                    out.write(("<p>" + I2PTunnelHTTPClient._("This seems to be a bad destination:") + " " + ahelperKey + " " + I2PTunnelHTTPClient._("i2paddresshelper cannot help you with a destination like that!") + "</p>").getBytes("UTF-8"));
                                                    I2PTunnelHTTPClient.writeFooter(out);
                                                    I2PTunnelHTTPClient.closeSocket(s);
                                                    return;
                                                }
                                                ahelperKey = _dest.toBase64();
                                            }
                                            ahelperPresent = true;
                                            if (host == null || "i2p".equals(host)) {
                                                String old = this.addressHelpers.putIfAbsent(destination.toLowerCase(Locale.US), ahelperKey);
                                                boolean bl = ahelperNew = old == null;
                                                if (!ahelperNew && !old.equals(ahelperKey)) {
                                                    ahelperConflict = true;
                                                    if (this._log.shouldLog(30)) {
                                                        this._log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "], trusted key [" + old + "], specified key [" + ahelperKey + "].");
                                                    }
                                                }
                                            } else {
                                                String destB64;
                                                Destination hostDest = this._context.namingService().lookup(destination);
                                                if (hostDest != null && (destB64 = hostDest.toBase64()) != null && !destB64.equals(ahelperKey)) {
                                                    ahelperConflict = true;
                                                    if (this._log.shouldLog(30)) {
                                                        this._log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "], trusted key [" + destB64 + "], specified key [" + ahelperKey + "].");
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    if (ahelperConflict) {
                                        if (out != null) {
                                            String alias = this.getHostName(ahelperKey);
                                            if (alias.equals("i2p")) {
                                                header = this.getErrorPage("dnfb", ERR_DESTINATION_UNKNOWN);
                                                I2PTunnelHTTPClient.writeErrorMessage(header, out, targetRequest, false, destination, null);
                                            } else {
                                                URI conflictURI;
                                                String trustedURL = requestURI.toASCIIString();
                                                try {
                                                    conflictURI = I2PTunnelHTTPClient.changeURI(requestURI, alias, 0, null);
                                                }
                                                catch (URISyntaxException use) {
                                                    this._log.warn(request, use);
                                                    method = null;
                                                    break;
                                                }
                                                String conflictURL = conflictURI.toASCIIString();
                                                byte[] header2 = this.getErrorPage("ahelper-conflict", ERR_AHELPER_CONFLICT);
                                                out.write(header2);
                                                out.write(I2PTunnelHTTPClient._("To visit the destination in your host database, click <a href=\"{0}\">here</a>. To visit the conflicting addresshelper destination, click <a href=\"{1}\">here</a>.", trustedURL, conflictURL).getBytes("UTF-8"));
                                                out.write("</p></div>".getBytes());
                                                I2PTunnelHTTPClient.writeFooter(out);
                                            }
                                        }
                                        s.close();
                                        return;
                                    }
                                }
                                if ((addressHelper = this.addressHelpers.get(destination)) != null) {
                                    host = this.getHostName(addressHelper);
                                }
                                targetRequest = requestURI.toASCIIString();
                                newURI = requestURI.getRawPath();
                                if (query != null) {
                                    newURI = newURI + '?' + query;
                                }
                                try {
                                    requestURI = new URI(newURI);
                                    break block135;
                                }
                                catch (URISyntaxException use) {
                                    this._log.warn(request, use);
                                    method = null;
                                    break;
                                }
                            }
                            if (hostLowerCase.equals("localhost") || host.equals("127.0.0.1") || host.startsWith("192.168.") || host.equals("[::1]")) {
                                if (out != null) {
                                    out.write(this.getErrorPage("localhost", ERR_LOCALHOST));
                                    I2PTunnelHTTPClient.writeFooter(out);
                                }
                                s.close();
                                return;
                            }
                            if (host.contains(".") || host.startsWith("[")) {
                                if (port >= 0) {
                                    host = host + ':' + port;
                                }
                                if (this._log.shouldLog(10)) {
                                    this._log.debug("Before selecting outproxy for " + host);
                                }
                                currentProxy = this.selectProxy();
                                if (this._log.shouldLog(10)) {
                                    this._log.debug("After selecting outproxy for " + host + ": " + currentProxy);
                                }
                                if (currentProxy == null) {
                                    if (this._log.shouldLog(30)) {
                                        this._log.warn(this.getPrefix(requestId) + "Host wants to be outproxied, but we dont have any!");
                                    }
                                    this.l.log("No HTTP outproxy found for the request.");
                                    if (out != null) {
                                        out.write(this.getErrorPage("noproxy", _ERR_NO_OUTPROXY));
                                        I2PTunnelHTTPClient.writeFooter(out);
                                    }
                                    s.close();
                                    return;
                                }
                                destination = currentProxy;
                                usingWWWProxy = true;
                                targetRequest = requestURI.toASCIIString();
                                if (this._log.shouldLog(10)) {
                                    this._log.debug(this.getPrefix(requestId) + " [" + host + "]: wwwProxy!");
                                }
                            } else {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("NODOTS, NOI2P: " + request);
                                }
                                if (out != null) {
                                    out.write(this.getErrorPage("denied", ERR_REQUEST_DENIED));
                                    I2PTunnelHTTPClient.writeFooter(out);
                                }
                                s.close();
                                return;
                            }
                        }
                    }
                    boolean bl = isValid = usingWWWProxy || usingInternalServer || I2PTunnelHTTPClient.isSupportedAddress(host, protocol);
                    if (!isValid) {
                        if (this._log.shouldLog(20)) {
                            this._log.info(this.getPrefix(requestId) + "notValid(" + host + ")");
                        }
                        method = null;
                        destination = null;
                        break;
                    }
                    line = method + ' ' + requestURI.toASCIIString() + ' ' + protocolVersion;
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.getPrefix(requestId) + "NEWREQ: \"" + line + "\"");
                        this._log.debug(this.getPrefix(requestId) + "HOST  : \"" + host + "\"");
                        this._log.debug(this.getPrefix(requestId) + "DEST  : \"" + destination + "\"");
                    }
                } else if (lowercaseLine.startsWith("host: ") && !usingWWWProxy) {
                    line = "Host: " + host;
                    if (this._log.shouldLog(20)) {
                        this._log.info(this.getPrefix(requestId) + "Setting host = " + host);
                    }
                } else if (lowercaseLine.startsWith("user-agent: ")) {
                    userAgent = lowercaseLine.substring(12);
                    if (!Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_USER_AGENT)).booleanValue()) {
                        line = null;
                        continue;
                    }
                } else {
                    if (lowercaseLine.startsWith("accept")) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("referer: ") && !Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_REFERER)).booleanValue()) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("via: ") && !Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_VIA)).booleanValue()) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("from: ")) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("authorization: ntlm ")) {
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("proxy-authorization: ")) {
                        if (lowercaseLine.startsWith("proxy-authorization: basic ")) {
                            authorization = line.substring(27);
                        }
                        line = null;
                        continue;
                    }
                    if (lowercaseLine.startsWith("icy")) {
                        shout = true;
                    }
                }
                if (line.length() == 0) {
                    String ok = this.getTunnel().getClientOptions().getProperty("i2ptunnel.gzip");
                    boolean gzip = true;
                    if (ok != null) {
                        gzip = Boolean.valueOf(ok);
                    }
                    if (gzip && !usingInternalServer) {
                        newRequest.append("Accept-Encoding: \r\n");
                        newRequest.append("X-Accept-Encoding: x-i2p-gzip;q=1.0, identity;q=0.5, deflate;q=0, gzip;q=0, *;q=0\r\n");
                    }
                    if (!shout && !Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_USER_AGENT)).booleanValue()) {
                        if (usingWWWProxy) {
                            newRequest.append("User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.6) Gecko/20100625 Firefox/3.6.6\r\n");
                        } else {
                            newRequest.append("User-Agent: MYOB/6.66 (AN/ON)\r\n");
                        }
                    }
                    if (usingWWWProxy && Boolean.valueOf(this.getTunnel().getClientOptions().getProperty("outproxyAuth")).booleanValue()) {
                        String user = this.getTunnel().getClientOptions().getProperty("outproxyUsername." + currentProxy);
                        String pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword." + currentProxy);
                        if (user == null || pw == null) {
                            user = this.getTunnel().getClientOptions().getProperty("outproxyUsername");
                            pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword");
                        }
                        if (user != null && pw != null) {
                            newRequest.append("Proxy-Authorization: Basic ").append(Base64.encode((user + ':' + pw).getBytes(), true)).append("\r\n");
                        }
                    }
                    newRequest.append("Connection: close\r\n\r\n");
                    break;
                }
                newRequest.append(line).append("\r\n");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix(requestId) + "NewRequest header: [" + newRequest.toString() + "]");
            }
            if (method == null || destination == null) {
                if (out != null) {
                    if (protocol != null && "http".equals(protocol.toLowerCase(Locale.US))) {
                        out.write(this.getErrorPage("denied", ERR_REQUEST_DENIED));
                    } else {
                        out.write(this.getErrorPage("protocol", ERR_BAD_PROTOCOL));
                    }
                    I2PTunnelHTTPClient.writeFooter(out);
                }
                s.close();
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix(requestId) + "Destination: " + destination);
            }
            if (!this.authorize(s, requestId, authorization)) {
                if (this._log.shouldLog(30)) {
                    if (authorization != null) {
                        this._log.warn(this.getPrefix(requestId) + "Auth failed, sending 407 again");
                    } else {
                        this._log.warn(this.getPrefix(requestId) + "Auth required, sending 407");
                    }
                }
                out.write(this.getErrorPage("auth", ERR_AUTH));
                I2PTunnelHTTPClient.writeFooter(out);
                s.close();
                return;
            }
            if (usingInternalServer) {
                if (internalPath.equals("/add") && Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER)).booleanValue()) {
                    out.write(ERR_HELPER_DISABLED);
                } else {
                    LocalHTTPServer.serveLocalFile(out, method, internalPath, internalRawQuery, this._proxyNonce);
                }
                s.close();
                return;
            }
            Destination clientDest = null;
            String addressHelper = this.addressHelpers.get(destination.toLowerCase(Locale.US));
            if (addressHelper != null) {
                clientDest = this._context.namingService().lookup(addressHelper);
                if (clientDest == null) {
                    this.addressHelpers.remove(destination.toLowerCase(Locale.US));
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this.getPrefix(requestId) + "Could not find destination for " + addressHelper);
                    }
                    byte[] header = this.getErrorPage("ahelper-notfound", ERR_AHELPER_NOTFOUND);
                    I2PTunnelHTTPClient.writeErrorMessage(header, out, targetRequest, false, destination, null);
                    s.close();
                    return;
                }
            } else if ("i2p".equals(host)) {
                clientDest = null;
            } else if (destination.length() == 60 && destination.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                this.verifySocketManager();
                I2PSession sess = this.sockMgr.getSession();
                if (sess != null && !sess.isClosed()) {
                    byte[] hData = Base32.decode(destination.substring(0, 52));
                    if (hData != null) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("lookup in-session " + destination);
                        }
                        Hash hash = Hash.create(hData);
                        clientDest = sess.lookupDest(hash, 20000L);
                    }
                } else {
                    clientDest = this._context.namingService().lookup(destination);
                }
            } else {
                clientDest = this._context.namingService().lookup(destination);
            }
            if (clientDest == null) {
                byte[] header;
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to resolve " + destination + " (proxy? " + usingWWWProxy + ", request: " + targetRequest);
                }
                String jumpServers = null;
                if (usingWWWProxy) {
                    header = this.getErrorPage("dnfp", ERR_DESTINATION_UNKNOWN);
                } else if (ahelperPresent) {
                    header = this.getErrorPage("dnfb", ERR_DESTINATION_UNKNOWN);
                } else if (destination.length() == 60 && destination.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                    header = this.getErrorPage("dnf", ERR_DESTINATION_UNKNOWN);
                } else {
                    header = this.getErrorPage("dnfh", ERR_DESTINATION_UNKNOWN);
                    jumpServers = this.getTunnel().getClientOptions().getProperty(PROP_JUMP_SERVERS);
                    if (jumpServers == null) {
                        jumpServers = DEFAULT_JUMP_SERVERS;
                    }
                }
                I2PTunnelHTTPClient.writeErrorMessage(header, out, targetRequest, usingWWWProxy, destination, jumpServers);
                s.close();
                return;
            }
            if (ahelperNew && "GET".equals(method) && (userAgent == null || !userAgent.startsWith("Wget")) && !Boolean.valueOf(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER)).booleanValue()) {
                this.writeHelperSaveForm(out, destination, ahelperKey, targetRequest);
                s.close();
                return;
            }
            if (ahelperPresent && !"POST".equals(method)) {
                String uri = targetRequest;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Auto redirecting to " + uri);
                }
                out.write(("HTTP/1.1 301 Address Helper Accepted\r\nLocation: " + uri + "\r\n" + "\r\n").getBytes("UTF-8"));
                s.close();
                return;
            }
            Properties opts = new Properties();
            I2PSocketOptions sktOpts = this.getDefaultOptions(opts);
            if (remotePort > 0) {
                sktOpts.setPort(remotePort);
            }
            I2PSocket i2ps = this.createI2PSocket(clientDest, sktOpts);
            byte[] data = newRequest.toString().getBytes("ISO-8859-1");
            OnTimeout onTimeout = new OnTimeout(s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
            new I2PTunnelHTTPClientRunner(s, i2ps, this.sockLock, data, this.mySockets, onTimeout);
        }
        catch (SocketException ex) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            }
            I2PTunnelHTTPClient.handleHTTPClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
        catch (IOException ex) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            }
            I2PTunnelHTTPClient.handleHTTPClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
        catch (I2PException ex) {
            if (this._log.shouldLog(20)) {
                this._log.info("getPrefix(requestId) + Error trying to connect", ex);
            }
            I2PTunnelHTTPClient.handleHTTPClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
        catch (OutOfMemoryError oom) {
            IOException ex = new IOException("OOM");
            this._log.error("getPrefix(requestId) + Error trying to connect", oom);
            I2PTunnelHTTPClient.handleHTTPClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
    }

    private void writeHelperSaveForm(OutputStream out, String destination, String ahelperKey, String targetRequest) throws IOException {
        if (out == null) {
            return;
        }
        byte[] header = this.getErrorPage("ahelper-new", ERR_AHELPER_NEW);
        out.write(header);
        out.write(("<table><tr><td class=\"mediumtags\" align=\"right\">" + I2PTunnelHTTPClient._("Host") + "</td><td class=\"mediumtags\">" + destination + "</td></tr>\n").getBytes());
        try {
            String b32 = Base32.encode(SHA256Generator.getInstance().calculateHash(Base64.decode(ahelperKey)).getData());
            out.write(("<tr><td class=\"mediumtags\" align=\"right\">" + I2PTunnelHTTPClient._("Base 32") + "</td>" + "<td><a href=\"http://" + b32 + ".b32.i2p/\">" + b32 + ".b32.i2p</a></td></tr>").getBytes());
        }
        catch (Exception e) {
            // empty catch block
        }
        out.write(("<tr><td class=\"mediumtags\" align=\"right\">" + I2PTunnelHTTPClient._("Destination") + "</td><td>" + "<textarea rows=\"1\" style=\"height: 4em; min-width: 0; min-height: 0;\" cols=\"70\" wrap=\"off\" readonly=\"readonly\" >" + ahelperKey + "</textarea></td></tr></table>\n" + "<hr><div class=\"formaction\">" + "<form method=\"GET\" action=\"" + targetRequest + "\">" + "<button type=\"submit\" class=\"go\">" + I2PTunnelHTTPClient._("Continue to {0} without saving", destination) + "</button>" + "</form>\n<form method=\"GET\" action=\"http://" + LOCAL_SERVER + "/add\">" + "<input type=\"hidden\" name=\"host\" value=\"" + destination + "\">\n" + "<input type=\"hidden\" name=\"dest\" value=\"" + ahelperKey + "\">\n" + "<input type=\"hidden\" name=\"nonce\" value=\"" + this._proxyNonce + "\">\n" + "<button type=\"submit\" class=\"accept\" name=\"router\" value=\"router\">" + I2PTunnelHTTPClient._("Save {0} to router address book and continue to eepsite", destination) + "</button><br>\n").getBytes("UTF-8"));
        if (this._context.namingService().getName().equals("BlockfileNamingService")) {
            out.write(("<br><button type=\"submit\" name=\"master\" value=\"master\">" + I2PTunnelHTTPClient._("Save {0} to master address book and continue to eepsite", destination) + "</button><br>\n").getBytes("UTF-8"));
            out.write(("<button type=\"submit\" name=\"private\" value=\"private\">" + I2PTunnelHTTPClient._("Save {0} to private address book and continue to eepsite", destination) + "</button>\n").getBytes("UTF-8"));
        }
        out.write(("<input type=\"hidden\" name=\"url\" value=\"" + targetRequest + "\">\n" + "</form></div></div>").getBytes());
        I2PTunnelHTTPClient.writeFooter(out);
    }

    private final String getHostName(String host) {
        if (host == null) {
            return null;
        }
        if (host.length() == 60 && host.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
            return host;
        }
        Destination _dest = this._context.namingService().lookup(host);
        if (_dest == null) {
            return "i2p";
        }
        return Base32.encode(_dest.calculateHash().getData()) + ".b32.i2p";
    }

    private byte[] getErrorPage(String base, byte[] backup) {
        return I2PTunnelHTTPClient.getErrorPage(this._context, base, backup);
    }

    private static byte[] getErrorPage(I2PAppContext ctx, String base, byte[] backup) {
        File file;
        File errorDir = new File(ctx.getBaseDir(), "docs");
        String lang = ctx.getProperty("routerconsole.lang", Locale.getDefault().getLanguage());
        if (lang != null && lang.length() > 0 && !lang.equals("en")) {
            file = new File(errorDir, base + "-header_" + lang + ".ht");
            try {
                return I2PTunnelHTTPClient.readFile(file);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        file = new File(errorDir, base + "-header.ht");
        try {
            return I2PTunnelHTTPClient.readFile(file);
        }
        catch (IOException ioe) {
            return backup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = null;
        byte[] buf = new byte[512];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        try {
            int len = 0;
            fis = new FileInputStream(file);
            while ((len = fis.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byArray = baos.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException foo) {}
            throw throwable;
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException foo) {
            // empty catch block
        }
        return byArray;
    }

    public static void writeFooter(OutputStream out) throws IOException {
        out.write("<div class=\"proxyfooter\"><p><i>I2P HTTP Proxy Server<br>Generated on: ".getBytes());
        out.write(new Date().toString().getBytes());
        out.write("</i></div></body></html>\n".getBytes());
        out.flush();
    }

    private static void writeErrorMessage(byte[] errMessage, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy, String jumpServers) throws IOException {
        if (out != null) {
            out.write(errMessage);
            if (targetRequest != null) {
                String uri = targetRequest.replace("&", "&amp;");
                out.write("<a href=\"".getBytes());
                out.write(uri.getBytes());
                out.write("\">".getBytes());
                out.write(uri.getBytes());
                out.write("</a>".getBytes());
                if (usingWWWProxy) {
                    out.write("<br><br><b>".getBytes());
                    out.write(I2PTunnelHTTPClient._("HTTP Outproxy").getBytes("UTF-8"));
                    out.write((":</b> " + wwwProxy).getBytes());
                }
                if (jumpServers != null && jumpServers.length() > 0) {
                    out.write("<br><br>".getBytes());
                    out.write(I2PTunnelHTTPClient._("Click a link below to look for an address helper by using a \"jump\" service:").getBytes("UTF-8"));
                    out.write("<br>\n".getBytes());
                    if (uri.startsWith("http://")) {
                        uri = uri.substring(7);
                    }
                    StringTokenizer tok = new StringTokenizer(jumpServers, ", ");
                    while (tok.hasMoreTokens()) {
                        Destination dest;
                        String jumphost;
                        String jurl = tok.nextToken();
                        try {
                            URI jURI = new URI(jurl);
                            String proto = jURI.getScheme();
                            jumphost = jURI.getHost();
                            if (proto == null || jumphost == null || !proto.toLowerCase(Locale.US).equals("http")) continue;
                            if (!(jumphost = jumphost.toLowerCase(Locale.US)).endsWith(".i2p")) {
                            }
                        }
                        catch (URISyntaxException use) {}
                        continue;
                        if (!jumphost.endsWith(".b32.i2p") && (dest = I2PAppContext.getGlobalContext().namingService().lookup(jumphost)) == null) continue;
                        out.write("<br><a href=\"".getBytes());
                        out.write(jurl.getBytes());
                        out.write(uri.getBytes());
                        out.write("\">".getBytes());
                        out.write(I2PTunnelHTTPClient._("{0} jump service", jumphost).getBytes());
                        out.write("</a>\n".getBytes());
                    }
                }
            }
            out.write("</div>".getBytes());
            I2PTunnelHTTPClient.writeFooter(out);
        }
    }

    private static void handleHTTPClientException(Exception ex, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy, long requestId) {
        if (out != null) {
            try {
                byte[] header = usingWWWProxy ? I2PTunnelHTTPClient.getErrorPage(I2PAppContext.getGlobalContext(), "dnfp", ERR_DESTINATION_UNKNOWN) : I2PTunnelHTTPClient.getErrorPage(I2PAppContext.getGlobalContext(), "dnf", ERR_DESTINATION_UNKNOWN);
                I2PTunnelHTTPClient.writeErrorMessage(header, out, targetRequest, usingWWWProxy, wwwProxy, null);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private static boolean isSupportedAddress(String host, String protocol) {
        if (host == null || protocol == null) {
            return false;
        }
        return protocol.toLowerCase(Locale.US).equals("http");
    }

    private static URI changeURI(URI uri, String host, int port, String path) throws URISyntaxException {
        return new URI(uri.getScheme(), null, host != null ? host : uri.getHost(), port != 0 ? port : uri.getPort(), path != null ? path : uri.getPath(), uri.getQuery(), null);
    }

    private static URI replaceQuery(URI uri, String query) throws URISyntaxException {
        URI rv = uri;
        if (rv.getRawQuery() != null) {
            rv = new URI(rv.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
        }
        if (query != null) {
            String newURI = rv.toASCIIString() + '?' + query;
            rv = new URI(newURI);
        }
        return rv;
    }

    private static String[] removeHelper(String query) {
        int keystart = 0;
        int valstart = -1;
        String key = null;
        for (int i = 0; i <= query.length(); ++i) {
            int c;
            int n = c = i < query.length() ? (int)query.charAt(i) : 38;
            if (c == 59 || c == 38) {
                String decodedKey;
                if (valstart < 0) {
                    key = query.substring(keystart, i);
                }
                if ((decodedKey = LocalHTTPServer.decode(key)).equals(HELPER_PARAM)) {
                    String newQuery;
                    String string = newQuery = keystart > 0 ? query.substring(0, keystart - 1) : "";
                    if (i < query.length() - 1) {
                        newQuery = keystart > 0 ? newQuery + query.substring(i) : newQuery + query.substring(i + 1);
                    }
                    String value = valstart >= 0 ? query.substring(valstart, i) : "";
                    String helperValue = LocalHTTPServer.decode(value);
                    return new String[]{newQuery, helperValue};
                }
                keystart = i + 1;
                valstart = -1;
                continue;
            }
            if (c != 61) continue;
            key = query.substring(keystart, i);
            valstart = i + 1;
        }
        return null;
    }

    protected static String _(String key) {
        return Translate.getString(key, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    protected static String _(String key, Object o) {
        return Translate.getString(key, o, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    protected static String _(String key, Object o, Object o2) {
        return Translate.getString(key, o, o2, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    private static class InputReader {
        InputStream _s;

        public InputReader(InputStream s) {
            this._s = s;
        }

        String readLine(String method) throws IOException {
            return DataHelper.readLine(this._s);
        }
    }

    private static class OnTimeout
    implements Runnable {
        private Socket _socket;
        private OutputStream _out;
        private String _target;
        private boolean _usingProxy;
        private String _wwwProxy;
        private long _requestId;

        public OnTimeout(Socket s, OutputStream out, String target, boolean usingProxy, String wwwProxy, long id) {
            this._socket = s;
            this._out = out;
            this._target = target;
            this._usingProxy = usingProxy;
            this._wwwProxy = wwwProxy;
            this._requestId = id;
        }

        public void run() {
            I2PTunnelHTTPClient.handleHTTPClientException(new RuntimeException("Timeout"), this._out, this._target, this._usingProxy, this._wwwProxy, this._requestId);
            I2PTunnelClientBase.closeSocket(this._socket);
        }
    }
}

