/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.data.Base32;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;

public class ConvertToHash {
    public static Hash getHash(String peer) {
        byte[] b;
        Destination d;
        if (peer == null) {
            return null;
        }
        Hash h = new Hash();
        String peerLC = peer.toLowerCase(Locale.US);
        if (peer.length() == 44 && !peerLC.endsWith(".i2p")) {
            try {
                h.fromBase64(peer);
            }
            catch (DataFormatException dfe) {
                // empty catch block
            }
        }
        if (h.getData() == null && peer.length() >= 520 && peerLC.endsWith(".i2p")) {
            try {
                d = new Destination();
                d.fromBase64(peer.substring(0, peer.length() - 4));
                h = d.calculateHash();
            }
            catch (DataFormatException dfe) {
                // empty catch block
            }
        }
        if (h.getData() == null && peer.length() >= 516 && !peerLC.endsWith(".i2p")) {
            try {
                d = new Destination();
                d.fromBase64(peer);
                h = d.calculateHash();
            }
            catch (DataFormatException dfe) {
                // empty catch block
            }
        }
        if (h.getData() == null && peer.length() == 60 && peerLC.endsWith(".b32.i2p") && (b = Base32.decode(peer.substring(0, 52))) != null && b.length == 32) {
            h.setData(b);
        }
        if (h.getData() == null && peer.length() == 52 && !peerLC.endsWith(".i2p") && (b = Base32.decode(peer)) != null && b.length == 32) {
            h.setData(b);
        }
        if (h.getData() == null && (d = I2PAppContext.getGlobalContext().namingService().lookup(peer)) != null) {
            h = d.calculateHash();
        }
        if (h.getData() == null) {
            return null;
        }
        return h;
    }
}

