/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;

public abstract class SimpleDataStructure
extends DataStructureImpl {
    protected byte[] _data;
    protected final int _length = this.length();

    public SimpleDataStructure() {
    }

    public SimpleDataStructure(byte[] data) {
        this.setData(data);
    }

    public abstract int length();

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        if (this._data != null) {
            throw new RuntimeException("Data already set");
        }
        if (data != null && data.length != this._length) {
            throw new IllegalArgumentException("Bad data length");
        }
        this._data = data;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._data != null) {
            throw new RuntimeException("Data already set");
        }
        this._data = new byte[this._length];
        int read = this.read(in, this._data);
        if (read != this._length) {
            throw new DataFormatException("Not enough bytes to read the data");
        }
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._data == null) {
            throw new DataFormatException("No data to write out");
        }
        out.write(this._data);
    }

    public String toBase64() {
        if (this._data == null) {
            return null;
        }
        return Base64.encode(this._data);
    }

    public void fromBase64(String data) throws DataFormatException {
        if (data == null) {
            throw new DataFormatException("Null data passed in");
        }
        byte[] d = Base64.decode(data);
        if (d == null) {
            throw new DataFormatException("Bad Base64 encoded data");
        }
        if (d.length != this._length) {
            throw new DataFormatException("Bad decoded data length, expected " + this._length + " got " + d.length);
        }
        this.setData(d);
    }

    public Hash calculateHash() {
        if (this._data != null) {
            return SHA256Generator.getInstance().calculateHash(this._data);
        }
        return null;
    }

    public byte[] toByteArray() {
        return this._data;
    }

    public void fromByteArray(byte[] data) throws DataFormatException {
        if (data == null) {
            throw new DataFormatException("Null data passed in");
        }
        if (data.length != this._length) {
            throw new DataFormatException("Bad data length");
        }
        this.setData(data);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append('[').append(this.getClass().getSimpleName()).append(": ");
        if (this._data == null) {
            buf.append("null");
        } else if (this._length <= 32) {
            buf.append(this.toBase64());
        } else {
            buf.append("size: ").append(Integer.toString(this._length));
        }
        buf.append(']');
        return buf.toString();
    }

    public int hashCode() {
        if (this._data == null) {
            return 0;
        }
        int rv = this._data[0];
        for (int i = 1; i < 4; ++i) {
            rv ^= this._data[i] << i * 8;
        }
        return rv;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SimpleDataStructure)) {
            return false;
        }
        return DataHelper.eq(this._data, ((SimpleDataStructure)obj)._data);
    }
}

