/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import gnu.crypto.hash.Sha256Standalone;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataStructure;
import net.i2p.util.ByteCache;
import net.i2p.util.OrderedProperties;
import net.i2p.util.ReusableGZIPInputStream;
import net.i2p.util.ReusableGZIPOutputStream;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHelper {
    private static final byte[] EQUAL_BYTES = DataHelper.getUTF8("=");
    private static final byte[] SEMICOLON_BYTES = DataHelper.getUTF8(";");
    private static final Map<String, String> _propertiesKeyCache;
    private static final byte[] EMPTY_BUFFER;
    public static final int DATE_LENGTH = 8;
    public static final byte BOOLEAN_TRUE = 1;
    public static final byte BOOLEAN_FALSE = 0;
    @Deprecated
    public static final byte BOOLEAN_UNKNOWN = 2;
    @Deprecated
    public static final int BOOLEAN_LENGTH = 1;
    private static final int MAX_LINE_LENGTH = 8192;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";
    private static final String[] escapeChars;
    private static final String[] escapeCodes;
    public static final int MAX_UNCOMPRESSED = 40960;
    public static final int MAX_COMPRESSION = 9;
    public static final int NO_COMPRESSION = 0;

    public static Properties readProperties(InputStream rawStream) throws DataFormatException, IOException {
        OrderedProperties props = new OrderedProperties();
        DataHelper.readProperties(rawStream, props);
        return props;
    }

    public static Properties readProperties(InputStream rawStream, Properties props) throws DataFormatException, IOException {
        long size = DataHelper.readLong(rawStream, 2);
        byte[] data = new byte[(int)size];
        int read = DataHelper.read(rawStream, data);
        if ((long)read != size) {
            throw new DataFormatException("Not enough data to read the properties, expected " + size + " but got " + read);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        byte[] eqBuf = new byte[EQUAL_BYTES.length];
        byte[] semiBuf = new byte[SEMICOLON_BYTES.length];
        while (in.available() > 0) {
            String key = DataHelper.readString(in);
            String cached = _propertiesKeyCache.get(key);
            if (cached != null) {
                key = cached;
            }
            if ((read = DataHelper.read(in, eqBuf)) != eqBuf.length || !DataHelper.eq(eqBuf, EQUAL_BYTES)) {
                throw new DataFormatException("Bad key");
            }
            String val = DataHelper.readString(in);
            read = DataHelper.read(in, semiBuf);
            if (read != semiBuf.length || !DataHelper.eq(semiBuf, SEMICOLON_BYTES)) {
                throw new DataFormatException("Bad value");
            }
            props.put(key, val);
        }
        return props;
    }

    public static void writeProperties(OutputStream rawStream, Properties props) throws DataFormatException, IOException {
        DataHelper.writeProperties(rawStream, props, false);
    }

    public static void writeProperties(OutputStream rawStream, Properties props, boolean utf8) throws DataFormatException, IOException {
        DataHelper.writeProperties(rawStream, props, utf8, props != null && !(props instanceof OrderedProperties));
    }

    public static void writeProperties(OutputStream rawStream, Properties props, boolean utf8, boolean sort) throws DataFormatException, IOException {
        if (props != null) {
            Properties p;
            if (sort) {
                p = new OrderedProperties();
                p.putAll((Map<?, ?>)props);
            } else {
                p = props;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(p.size() * 64);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (utf8) {
                    DataHelper.writeStringUTF8(baos, key);
                } else {
                    DataHelper.writeString(baos, key);
                }
                baos.write(EQUAL_BYTES);
                if (utf8) {
                    DataHelper.writeStringUTF8(baos, val);
                } else {
                    DataHelper.writeString(baos, val);
                }
                baos.write(SEMICOLON_BYTES);
            }
            if (baos.size() > 65535) {
                throw new DataFormatException("Properties too big (65535 max): " + baos.size());
            }
            byte[] propBytes = baos.toByteArray();
            DataHelper.writeLong(rawStream, 2, propBytes.length);
            rawStream.write(propBytes);
        } else {
            DataHelper.writeLong(rawStream, 2, 0L);
        }
    }

    @Deprecated
    public static int toProperties(byte[] target, int offset, Properties props) throws DataFormatException, IOException {
        if (props != null) {
            OrderedProperties p = new OrderedProperties();
            p.putAll((Map<?, ?>)props);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(p.size() * 64);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                DataHelper.writeStringUTF8(baos, key);
                baos.write(EQUAL_BYTES);
                DataHelper.writeStringUTF8(baos, val);
                baos.write(SEMICOLON_BYTES);
            }
            if (baos.size() > 65535) {
                throw new DataFormatException("Properties too big (65535 max): " + baos.size());
            }
            byte[] propBytes = baos.toByteArray();
            DataHelper.toLong(target, offset, 2, propBytes.length);
            System.arraycopy(propBytes, 0, target, offset += 2, propBytes.length);
            return offset += propBytes.length;
        }
        DataHelper.toLong(target, offset, 2, 0L);
        return offset + 2;
    }

    public static int fromProperties(byte[] source, int offset, Properties target) throws DataFormatException {
        int size = (int)DataHelper.fromLong(source, offset, 2);
        ByteArrayInputStream in = new ByteArrayInputStream(source, offset += 2, size);
        byte[] eqBuf = new byte[EQUAL_BYTES.length];
        byte[] semiBuf = new byte[SEMICOLON_BYTES.length];
        while (in.available() > 0) {
            String val;
            int read;
            String key;
            try {
                key = DataHelper.readString(in);
                String cached = _propertiesKeyCache.get(key);
                if (cached != null) {
                    key = cached;
                }
                if ((read = DataHelper.read(in, eqBuf)) != eqBuf.length || !DataHelper.eq(eqBuf, EQUAL_BYTES)) {
                    throw new DataFormatException("Bad key");
                }
            }
            catch (IOException ioe) {
                throw new DataFormatException("Bad key", ioe);
            }
            try {
                val = DataHelper.readString(in);
                read = DataHelper.read(in, semiBuf);
                if (read != semiBuf.length || !DataHelper.eq(semiBuf, SEMICOLON_BYTES)) {
                    throw new DataFormatException("Bad value");
                }
            }
            catch (IOException ioe) {
                throw new DataFormatException("Bad value", ioe);
            }
            target.put(key, val);
        }
        return offset + size;
    }

    public static byte[] toProperties(Properties opts) throws DataFormatException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2 + 32 * opts.size());
            DataHelper.writeProperties(baos, opts, true, false);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO error writing to memory?! " + ioe.getMessage());
        }
    }

    public static String toString(Properties options) {
        StringBuilder buf = new StringBuilder();
        if (options != null) {
            for (Map.Entry<Object, Object> entry : options.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                buf.append("[").append(key).append("] = [").append(val).append("]");
            }
        } else {
            buf.append("(null properties map)");
        }
        return buf.toString();
    }

    public static void loadProps(Properties props, File file) throws IOException {
        DataHelper.loadProps(props, file, false);
    }

    public static void loadProps(Properties props, File file, boolean forceLowerCase) throws IOException {
        DataHelper.loadProps(props, new FileInputStream(file), forceLowerCase);
    }

    public static void loadProps(Properties props, InputStream inStr) throws IOException {
        DataHelper.loadProps(props, inStr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProps(Properties props, InputStream inStr, boolean forceLowerCase) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(inStr, "UTF-8"), 16384);
            String line = null;
            while ((line = in.readLine()) != null) {
                int split;
                if (line.trim().length() <= 0 || line.charAt(0) == '#' || line.charAt(0) == ';') continue;
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if ((split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                String val = line.substring(split + 1);
                if (key.length() <= 0 || val.length() <= 0) continue;
                if (forceLowerCase) {
                    props.setProperty(key.toLowerCase(Locale.US), val);
                    continue;
                }
                props.setProperty(key, val);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProps(Properties props, File file) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(file), "UTF-8")));
            out.println("# NOTE: This I2P config file must use UTF-8 encoding");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String name = (String)entry.getKey();
                String val = (String)entry.getValue();
                out.println(name + "=" + val);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String toString(Collection col) {
        StringBuilder buf = new StringBuilder();
        if (col != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                buf.append("[").append(o).append("]");
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    public static String toString(byte[] buf) {
        if (buf == null) {
            return "";
        }
        return DataHelper.toString(buf, buf.length);
    }

    public static String toString(byte[] buf, int len) {
        int i;
        if (buf == null) {
            buf = EMPTY_BUFFER;
        }
        StringBuilder out = new StringBuilder();
        if (len > buf.length) {
            for (i = 0; i < len - buf.length; ++i) {
                out.append("00");
            }
        }
        for (i = 0; i < buf.length && i < len; ++i) {
            StringBuilder temp = new StringBuilder(Integer.toHexString(buf[i]));
            while (temp.length() < 2) {
                temp.insert(0, '0');
            }
            temp = new StringBuilder(temp.substring(temp.length() - 2));
            out.append(temp.toString());
        }
        return out.toString();
    }

    public static String toDecimalString(byte[] buf, int len) {
        if (buf == null) {
            buf = EMPTY_BUFFER;
        }
        BigInteger val = new BigInteger(1, buf);
        return val.toString(10);
    }

    public static final String toHexString(byte[] data) {
        if (data == null || data.length <= 0) {
            return "00";
        }
        BigInteger bi = new BigInteger(1, data);
        return bi.toString(16);
    }

    public static final byte[] fromHexString(String val) {
        BigInteger bv = new BigInteger(val, 16);
        return bv.toByteArray();
    }

    public static long readLong(InputStream rawStream, int numBytes) throws DataFormatException, IOException {
        if (numBytes > 8) {
            throw new DataFormatException("readLong doesn't currently support reading numbers > 8 bytes [as thats bigger than java's long]");
        }
        long rv = 0L;
        for (int i = 0; i < numBytes; ++i) {
            int cur = rawStream.read();
            if (cur == -1) {
                throw new EOFException("EOF reading " + numBytes + " byte value");
            }
            if (cur == 0) continue;
            rv = cur & 0xFF;
            for (int j = i + 1; j < numBytes; ++j) {
                rv <<= 8;
                cur = rawStream.read();
                if (cur == -1) {
                    throw new EOFException("EOF reading " + numBytes + " byte value");
                }
                rv |= (long)(cur & 0xFF);
            }
            break;
        }
        if (rv < 0L) {
            throw new DataFormatException("wtf, fromLong got a negative? " + rv + " numBytes=" + numBytes);
        }
        return rv;
    }

    public static void writeLong(OutputStream rawStream, int numBytes, long value) throws DataFormatException, IOException {
        if (value < 0L) {
            throw new DataFormatException("Value is negative (" + value + ")");
        }
        for (int i = (numBytes - 1) * 8; i >= 0; i -= 8) {
            byte cur = (byte)(value >> i);
            rawStream.write(cur);
        }
    }

    public static byte[] toLong(int numBytes, long value) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value not allowed");
        }
        byte[] val = new byte[numBytes];
        DataHelper.toLong(val, 0, numBytes, value);
        return val;
    }

    public static void toLong(byte[] target, int offset, int numBytes, long value) throws IllegalArgumentException {
        if (numBytes <= 0) {
            throw new IllegalArgumentException("Invalid number of bytes");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value not allowed");
        }
        for (int i = offset + numBytes - 1; i >= offset; --i) {
            target[i] = (byte)value;
            value >>= 8;
        }
    }

    public static void toLongLE(byte[] target, int offset, int numBytes, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value not allowed");
        }
        int limit = offset + numBytes;
        for (int i = offset; i < limit; ++i) {
            target[i] = (byte)value;
            value >>= 8;
        }
    }

    public static long fromLong(byte[] src, int offset, int numBytes) {
        if (src == null || src.length == 0) {
            return 0L;
        }
        long rv = 0L;
        int limit = offset + numBytes;
        for (int i = offset; i < limit; ++i) {
            rv <<= 8;
            rv |= (long)(src[i] & 0xFF);
        }
        if (rv < 0L) {
            throw new IllegalArgumentException("wtf, fromLong got a negative? " + rv + ": offset=" + offset + " numBytes=" + numBytes);
        }
        return rv;
    }

    public static long fromLongLE(byte[] src, int offset, int numBytes) {
        long rv = 0L;
        for (int i = offset + numBytes - 1; i >= offset; --i) {
            rv <<= 8;
            rv |= (long)(src[i] & 0xFF);
        }
        if (rv < 0L) {
            throw new IllegalArgumentException("wtf, fromLong got a negative? " + rv + ": offset=" + offset + " numBytes=" + numBytes);
        }
        return rv;
    }

    public static Date readDate(InputStream in) throws DataFormatException, IOException {
        long date = DataHelper.readLong(in, 8);
        if (date == 0L) {
            return null;
        }
        return new Date(date);
    }

    public static void writeDate(OutputStream out, Date date) throws DataFormatException, IOException {
        if (date == null) {
            DataHelper.writeLong(out, 8, 0L);
        } else {
            DataHelper.writeLong(out, 8, date.getTime());
        }
    }

    @Deprecated
    public static byte[] toDate(Date date) throws IllegalArgumentException {
        if (date == null) {
            return DataHelper.toLong(8, 0L);
        }
        return DataHelper.toLong(8, date.getTime());
    }

    public static void toDate(byte[] target, int offset, long when) throws IllegalArgumentException {
        DataHelper.toLong(target, offset, 8, when);
    }

    public static Date fromDate(byte[] src, int offset) throws DataFormatException {
        if (src == null || offset + 8 > src.length) {
            throw new DataFormatException("Not enough data to read a date");
        }
        try {
            long when = DataHelper.fromLong(src, offset, 8);
            if (when <= 0L) {
                return null;
            }
            return new Date(when);
        }
        catch (IllegalArgumentException iae) {
            throw new DataFormatException(iae.getMessage());
        }
    }

    public static String readString(InputStream in) throws DataFormatException, IOException {
        int size = in.read();
        if (size == -1) {
            throw new EOFException("EOF reading string");
        }
        if (size == 0) {
            return "";
        }
        byte[] raw = new byte[size &= 0xFF];
        int read = DataHelper.read(in, raw);
        if (read != size) {
            throw new EOFException("EOF reading string");
        }
        return new String(raw, "UTF-8");
    }

    public static void writeString(OutputStream out, String string) throws DataFormatException, IOException {
        if (string == null) {
            out.write(0);
        } else {
            int len = string.length();
            if (len > 255) {
                throw new DataFormatException("The I2P data spec limits strings to 255 bytes or less, but this is " + len + " [" + string + "]");
            }
            out.write((byte)len);
            for (int i = 0; i < len; ++i) {
                out.write((byte)(string.charAt(i) & 0xFF));
            }
        }
    }

    private static void writeStringUTF8(OutputStream out, String string) throws DataFormatException, IOException {
        if (string == null) {
            out.write(0);
        } else {
            byte[] raw = string.getBytes("UTF-8");
            int len = raw.length;
            if (len > 255) {
                throw new DataFormatException("The I2P data spec limits strings to 255 bytes or less, but this is " + len + " [" + string + "]");
            }
            out.write((byte)len);
            out.write(raw);
        }
    }

    public static Boolean readBoolean(InputStream in) throws DataFormatException, IOException {
        int val = in.read();
        switch (val) {
            case -1: {
                throw new EOFException("EOF reading boolean");
            }
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return null;
            }
        }
        throw new DataFormatException("Uhhh.. readBoolean read a value that isn't a known ternary val (0,1,2): " + val);
    }

    @Deprecated
    public static void writeBoolean(OutputStream out, Boolean bool) throws DataFormatException, IOException {
        if (bool == null) {
            DataHelper.writeLong(out, 1, 2L);
        } else if (Boolean.TRUE.equals(bool)) {
            DataHelper.writeLong(out, 1, 1L);
        } else {
            DataHelper.writeLong(out, 1, 0L);
        }
    }

    @Deprecated
    public static Boolean fromBoolean(byte[] data, int offset) {
        if (data[offset] == 1) {
            return Boolean.TRUE;
        }
        if (data[offset] == 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Deprecated
    public static void toBoolean(byte[] data, int offset, boolean value) {
        data[offset] = value ? (byte)1 : 0;
    }

    @Deprecated
    public static void toBoolean(byte[] data, int offset, Boolean value) {
        data[offset] = value == null ? 2 : (value != false ? 1 : 0);
    }

    public static final boolean eq(Object lhs, Object rhs) {
        try {
            boolean eq = lhs == null && rhs == null || lhs != null && lhs.equals(rhs);
            return eq;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public static final boolean eq(Collection lhs, Collection rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.size() != rhs.size()) {
            return false;
        }
        Iterator liter = lhs.iterator();
        Iterator riter = rhs.iterator();
        while (liter.hasNext() && riter.hasNext()) {
            if (DataHelper.eq(liter.next(), riter.next())) continue;
            return false;
        }
        return true;
    }

    public static final boolean eq(byte[] lhs, byte[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @Deprecated
    public static final boolean eq(int lhs, int rhs) {
        return lhs == rhs;
    }

    @Deprecated
    public static final boolean eq(long lhs, long rhs) {
        return lhs == rhs;
    }

    @Deprecated
    public static final boolean eq(byte lhs, byte rhs) {
        return lhs == rhs;
    }

    public static final boolean eq(byte[] lhs, int offsetLeft, byte[] rhs, int offsetRight, int length) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (lhs[offsetLeft + i] == rhs[offsetRight + i]) continue;
            return false;
        }
        return true;
    }

    public static final int compareTo(byte[] lhs, byte[] rhs) {
        if (rhs == null && lhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (rhs.length < lhs.length) {
            return 1;
        }
        if (rhs.length > lhs.length) {
            return -1;
        }
        for (int i = 0; i < rhs.length; ++i) {
            if ((rhs[i] & 0xFF) > (lhs[i] & 0xFF)) {
                return -1;
            }
            if ((rhs[i] & 0xFF) >= (lhs[i] & 0xFF)) continue;
            return 1;
        }
        return 0;
    }

    public static final byte[] xor(byte[] lhs, byte[] rhs) {
        if (lhs == null || rhs == null || lhs.length != rhs.length) {
            return null;
        }
        byte[] diff = new byte[lhs.length];
        DataHelper.xor(lhs, 0, rhs, 0, diff, 0, lhs.length);
        return diff;
    }

    public static final void xor(byte[] lhs, int startLeft, byte[] rhs, int startRight, byte[] out, int startOut, int len) {
        if (lhs == null || rhs == null || out == null) {
            throw new NullPointerException("Null params to xor");
        }
        if (lhs.length < startLeft + len) {
            throw new IllegalArgumentException("Left hand side is too short");
        }
        if (rhs.length < startRight + len) {
            throw new IllegalArgumentException("Right hand side is too short");
        }
        if (out.length < startOut + len) {
            throw new IllegalArgumentException("Result is too short");
        }
        for (int i = 0; i < len; ++i) {
            out[startOut + i] = (byte)(lhs[startLeft + i] ^ rhs[startRight + i]);
        }
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public static int hashCode(Date obj) {
        if (obj == null) {
            return 0;
        }
        return (int)obj.getTime();
    }

    public static int hashCode(byte[] b) {
        int rv = 0;
        if (b != null) {
            if (b.length <= 32) {
                rv = Arrays.hashCode(b);
            } else {
                for (int i = 0; i < 32; ++i) {
                    rv ^= b[i] << i;
                }
            }
        }
        return rv;
    }

    public static int hashCode(Collection col) {
        if (col == null) {
            return 0;
        }
        int c = 0;
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            c = 7 * c + DataHelper.hashCode(iter.next());
        }
        return c;
    }

    public static int read(InputStream in, byte[] target) throws IOException {
        return DataHelper.read(in, target, 0, target.length);
    }

    public static int read(InputStream in, byte[] target, int offset, int length) throws IOException {
        int cur;
        int numRead;
        for (cur = offset; cur < length; cur += numRead) {
            numRead = in.read(target, cur, length - cur);
            if (numRead != -1) continue;
            if (cur == offset) {
                return -1;
            }
            return cur;
        }
        return cur;
    }

    public static String readLine(InputStream in) throws IOException {
        return DataHelper.readLine(in, (MessageDigest)null);
    }

    public static String readLine(InputStream in, Sha256Standalone hash) throws IOException {
        StringBuilder buf = new StringBuilder(128);
        boolean ok = DataHelper.readLine(in, buf, hash);
        if (ok) {
            return buf.toString();
        }
        return null;
    }

    public static String readLine(InputStream in, MessageDigest hash) throws IOException {
        StringBuilder buf = new StringBuilder(128);
        boolean ok = DataHelper.readLine(in, buf, hash);
        if (ok) {
            return buf.toString();
        }
        return null;
    }

    @Deprecated
    public static boolean readLine(InputStream in, StringBuffer buf) throws IOException {
        return DataHelper.readLine(in, buf, null);
    }

    @Deprecated
    public static boolean readLine(InputStream in, StringBuffer buf, Sha256Standalone hash) throws IOException {
        int c = -1;
        int i = 0;
        while ((c = in.read()) != -1) {
            if (++i > 8192) {
                throw new IOException("Line too long - max 8192");
            }
            if (hash != null) {
                hash.update((byte)c);
            }
            if (c == 10) break;
            buf.append((char)c);
        }
        return c != -1;
    }

    public static boolean readLine(InputStream in, StringBuilder buf) throws IOException {
        return DataHelper.readLine(in, buf, (MessageDigest)null);
    }

    public static boolean readLine(InputStream in, StringBuilder buf, Sha256Standalone hash) throws IOException {
        int c = -1;
        int i = 0;
        while ((c = in.read()) != -1) {
            if (++i > 8192) {
                throw new IOException("Line too long - max 8192");
            }
            if (hash != null) {
                hash.update((byte)c);
            }
            if (c == 10) break;
            buf.append((char)c);
        }
        return c != -1;
    }

    public static boolean readLine(InputStream in, StringBuilder buf, MessageDigest hash) throws IOException {
        int c = -1;
        int i = 0;
        while ((c = in.read()) != -1) {
            if (++i > 8192) {
                throw new IOException("Line too long - max 8192");
            }
            if (hash != null) {
                hash.update((byte)c);
            }
            if (c == 10) break;
            buf.append((char)c);
        }
        return c != -1;
    }

    public static void write(OutputStream out, byte[] data, Sha256Standalone hash) throws IOException {
        hash.update(data);
        out.write(data);
    }

    public static void write(OutputStream out, byte[] data, MessageDigest hash) throws IOException {
        hash.update(data);
        out.write(data);
    }

    public static List<? extends DataStructure> sortStructures(Collection<? extends DataStructure> dataStructures) {
        if (dataStructures == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<? extends DataStructure> rv = new ArrayList<DataStructure>(dataStructures);
        DataHelper.sortStructureList(rv);
        return rv;
    }

    static void sortStructureList(List<? extends DataStructure> dataStructures) {
        Collections.sort(dataStructures, new DataStructureComparator());
    }

    public static String formatDuration(long ms) {
        if (ms < 5000L) {
            return ms + "ms";
        }
        if (ms < 180000L) {
            return ms / 1000L + "s";
        }
        if (ms < 0x6DDD00L) {
            return ms / 60000L + "m";
        }
        if (ms < 259200000L) {
            return ms / 3600000L + "h";
        }
        if (ms > 86400000000L) {
            return "n/a";
        }
        return ms / 86400000L + "d";
    }

    public static String formatDuration2(long ms) {
        String t;
        long ams;
        long l = ams = ms >= 0L ? ms : 0L - ms;
        if (ms == 0L) {
            return "0";
        }
        if (ams < 3000L) {
            t = DataHelper.ngettext("1 ms", "{0,number,####} ms", (int)ms);
        } else if (ams < 120000L) {
            t = DataHelper.ngettext("1 sec", "{0} sec", (int)(ms / 1000L));
        } else if (ams < 0x6DDD00L) {
            t = DataHelper.ngettext("1 min", "{0} min", (int)(ms / 60000L));
        } else if (ams < 172800000L) {
            t = DataHelper.ngettext("1 hour", "{0} hours", (int)(ms / 3600000L));
        } else {
            if (ams > 86400000000L) {
                return DataHelper._("n/a");
            }
            t = DataHelper.ngettext("1 day", "{0} days", (int)(ms / 86400000L));
        }
        if (ms < 0L) {
            t = t.replace("-", "&minus;");
        }
        return t.replace(" ", "&nbsp;");
    }

    private static String _(String key) {
        return Translate.getString(key, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    private static String ngettext(String s, String p, int n) {
        return Translate.getString(n, s, p, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    public static String formatSize(long bytes) {
        double val;
        int scale = 0;
        for (val = (double)bytes; val >= 1024.0; val /= 1024.0) {
            ++scale;
        }
        DecimalFormat fmt = new DecimalFormat("##0.00");
        String str = fmt.format(val);
        switch (scale) {
            case 1: {
                return str + "K";
            }
            case 2: {
                return str + "M";
            }
            case 3: {
                return str + "G";
            }
            case 4: {
                return str + "T";
            }
            case 5: {
                return str + "P";
            }
            case 6: {
                return str + "E";
            }
            case 7: {
                return str + "Z";
            }
            case 8: {
                return str + "Y";
            }
        }
        return bytes + "";
    }

    public static String formatSize2(long bytes) {
        double val;
        int scale = 0;
        for (val = (double)bytes; val >= 1024.0; val /= 1024.0) {
            ++scale;
        }
        DecimalFormat fmt = new DecimalFormat("##0.00");
        String str = fmt.format(val);
        switch (scale) {
            case 1: {
                return str + "&nbsp;K";
            }
            case 2: {
                return str + "&nbsp;M";
            }
            case 3: {
                return str + "&nbsp;G";
            }
            case 4: {
                return str + "&nbsp;T";
            }
            case 5: {
                return str + "&nbsp;P";
            }
            case 6: {
                return str + "&nbsp;E";
            }
            case 7: {
                return str + "&nbsp;Z";
            }
            case 8: {
                return str + "&nbsp;Y";
            }
        }
        return bytes + "&nbsp;";
    }

    public static String stripHTML(String orig) {
        if (orig == null) {
            return "";
        }
        String t1 = orig.replace('<', ' ');
        String rv = t1.replace('>', ' ');
        return rv;
    }

    public static String escapeHTML(String unescaped) {
        if (unescaped == null) {
            return null;
        }
        String escaped = unescaped;
        for (int i = 0; i < escapeChars.length; ++i) {
            escaped = escaped.replaceAll(escapeChars[i], escapeCodes[i]);
        }
        return escaped;
    }

    public static byte[] compress(byte[] orig) {
        return DataHelper.compress(orig, 0, orig.length);
    }

    public static byte[] compress(byte[] orig, int offset, int size) {
        return DataHelper.compress(orig, offset, size, 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] orig, int offset, int size, int level) {
        if (orig == null || orig.length <= 0) {
            return orig;
        }
        if (size > 40960) {
            throw new IllegalArgumentException("tell jrandom size=" + size);
        }
        ReusableGZIPOutputStream out = ReusableGZIPOutputStream.acquire();
        out.setLevel(level);
        try {
            byte[] rv;
            out.write(orig, offset, size);
            out.finish();
            out.flush();
            byte[] byArray = rv = out.getData();
            return byArray;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            ReusableGZIPOutputStream.release(out);
        }
    }

    public static byte[] decompress(byte[] orig) throws IOException {
        return orig != null ? DataHelper.decompress(orig, 0, orig.length) : null;
    }

    public static byte[] decompress(byte[] orig, int offset, int length) throws IOException {
        int read;
        if (orig == null || orig.length <= 0) {
            return orig;
        }
        if (offset + length > orig.length) {
            throw new IOException("Bad params arrlen " + orig.length + " off " + offset + " len " + length);
        }
        ReusableGZIPInputStream in = ReusableGZIPInputStream.acquire();
        in.initialize(new ByteArrayInputStream(orig, offset, length));
        ByteCache cache = ByteCache.getInstance(8, 40960);
        ByteArray outBuf = cache.acquire();
        int written = 0;
        while ((read = in.read(outBuf.getData(), written, 40960 - written)) != -1) {
            if ((written += read) < 40960) continue;
            if (in.available() <= 0) break;
            throw new IOException("Uncompressed data larger than 40960");
        }
        byte[] rv = new byte[written];
        System.arraycopy(outBuf.getData(), 0, rv, 0, written);
        cache.release(outBuf);
        ReusableGZIPInputStream.release(in);
        return rv;
    }

    public static byte[] getUTF8(String orig) {
        if (orig == null) {
            return null;
        }
        try {
            return orig.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("no utf8!?");
        }
    }

    public static byte[] getUTF8(StringBuffer orig) {
        if (orig == null) {
            return null;
        }
        return DataHelper.getUTF8(orig.toString());
    }

    public static String getUTF8(byte[] orig) {
        if (orig == null) {
            return null;
        }
        try {
            return new String(orig, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("no utf8!?");
        }
    }

    public static String getUTF8(byte[] orig, int offset, int len) {
        if (orig == null) {
            return null;
        }
        try {
            return new String(orig, offset, len, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("no utf8!?");
        }
    }

    static {
        String[] keys = new String[]{"cost", "host", "port", "key", "ihost0", "iport0", "ikey0", "itag0", "ihost1", "iport1", "ikey1", "itag1", "ihost2", "iport2", "ikey2", "itag2", "caps", "coreVersion", "netId", "router.version", "stat_bandwidthReceiveBps.60m", "stat_bandwidthSendBps.60m", "stat_tunnel.buildClientExpire.60m", "stat_tunnel.buildClientReject.60m", "stat_tunnel.buildClientSuccess.60m", "stat_tunnel.buildExploratoryExpire.60m", "stat_tunnel.buildExploratoryReject.60m", "stat_tunnel.buildExploratorySuccess.60m", "stat_tunnel.participatingTunnels.60m", "stat_uptime", "version", "created", "upgraded", "lists", "a", "s"};
        _propertiesKeyCache = new HashMap<String, String>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            _propertiesKeyCache.put(keys[i], keys[i]);
        }
        EMPTY_BUFFER = "".getBytes();
        escapeChars = new String[]{"&", "\"", "<", ">"};
        escapeCodes = new String[]{"&amp;", "&quot;", "&lt;", "&gt;"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataStructureComparator
    implements Comparator<DataStructure> {
        private DataStructureComparator() {
        }

        @Override
        public int compare(DataStructure l, DataStructure r) {
            return l.calculateHash().toBase64().compareTo(r.calculateHash().toBase64());
        }
    }
}

